nt
    the explicit setting on that request, and the setting in the session. If a
    setting is a dictionary, they will be merged together using `dict_class`
    Nc                 S   s   g | ]\}}|d kr|qS N ).0kvr'   r'   A/usr/lib/python3.8/site-packages/pip/_vendor/requests/sessions.py
<listcomp>I   s      z!merge_setting.<locals>.<listcomp>)
isinstancer
   r   updateitems)Zrequest_settingZsession_setting
dict_classZmerged_settingZ	none_keyskeyr'   r'   r+   
merge_setting1   s    r2   c                 C   s@   |dks| dg kr| S | dks0|  dg kr4|S t| ||S )zProperly merges both requests and session hooks.

    This is necessary because when request_hooks == {'response': []}, the
    merge breaks Session hooks entirely.
    Nresponse)getr2   )Z
request_hooksZ
session_hooksr0   r'   r'   r+   merge_hooksP   s
    r5   c                   @   s>   e Zd Zdd Zdd Zddd	Zd
d Zdd
 Zdd ZdS )SessionRedirectMixinc                 C   s,   |j r(|jd }tr|d}t|dS dS )z7Receives a Response. Returns a redirect URI or ``None``locationlatin1utf8N)Zis_redirectheadersr   encoder   )selfrespr7   r'   r'   r+   get_redirect_targeta   s    


z(SessionRedirectMixin.get_redirect_targetc                 C   s   t |}t |}|j|jkr dS |jdkrL|jdkrL|jdkrL|jdkrLdS |j|jk}|j|jk}t|jddf}|s|j|kr|j|krdS |p|S )zFDecide whether Authorization header should be removed when redirectingTZhttp)P   NZhttps)i  NFN)r	   ZhostnameschemeZportr   r4   )r<   Zold_urlZnew_urlZ
old_parsedZ
new_parsedZchanged_portZchanged_schemeZdefault_portr'   r'   r+   should_strip_authv   s$    z&SessionRedirectMixin.should_strip_authFNTc	              
   k   sZ  g }
|  |}t|jj}|rV| }
|
| |
dd |_z
|j W n( tt	t
fk
rr   |jjdd Y nX t
|j| jkrtd| j |d|  |drt|j}dt|j|f }t|}|jd	kr|r|j|d
}n|jr|j}| }|jst|jt|}nt|}t||
_| |
| |jtjtjfkrld}|D ]}|
j|d qPd|
_ |
j}z
|d= W n t!k
r   Y nX t"|
j#||j t$|
j#| j% |
&|
j# | '|
|}| (|
| |
j)dk	od
|kpd|k}|rt*|
 |
}|r|V  q| j+|f|||||dd|	}t"| j%|
|j |  |}|V  qdS )zBReceives a Response. Returns a generator of Responses or Requests.r   NF)Zdecode_contentzExceeded %s redirects.)r3   z//z%s:%s )fragment)Content-LengthzContent-TypeTransfer-EncodingZCookierD   rE   )streamtimeoutverifycertproxiesallow_redirects),r>   r	   urlrC   copyappendhistorycontentr   r   RuntimeErrorrawreadlen
max_redirectsr   close
startswithr   r@   _replaceZgeturlZnetlocr   r   rebuild_methodstatus_coder$   Ztemporary_redirectZpermanent_redirectr:   popZbodyKeyErrorr   Z_cookiesr   cookiesZprepare_cookiesrebuild_proxiesrebuild_authZ_body_positionr#   send)r<   r=   reqrF   rG   rH   rI   rJ   yield_requestsZadapter_kwargsZhistrL   Zprevious_fragmentprepared_requestZparsed_rurlZparsedZpurged_headersheaderr:   Z
rewindabler'   r'   r+   resolve_redirects   s    







z&SessionRedirectMixin.resolve_redirectsc                 C   sR   |j }|j}d|kr*| |jj|r*|d= | jr8t|nd}|dk	rN|| dS )zWhen being redirected we may want to strip authentication from the
        request to avoid leaking credentials. This method intelligently removes
        and reapplies authentication where possible to avoid credential loss.
        Z
AuthorizationN)r:   rL   rA   request	trust_envr    Zprepare_auth)r<   rc   r3   r:   rL   Znew_authr'   r'   r+   r_      s    
z!SessionRedirectMixin.rebuild_authc           
      C   s   |dk	r|ni }|j }|j}t|j}| }|d}t||d}| jr||s|t||d}	|	||	d}
|
r||	||
 d|kr|d= zt
|| \}}W n tk
r   d\}}Y nX |r|rt|||d< |S )a  This method re-evaluates the proxy configuration by considering the
        environment variables. If we are redirected to a URL covered by
        NO_PROXY, we strip the proxy configuration. Otherwise, we set missing
        proxy keys for this URL (in case they were stripped by a previous
        redirect).

        This method also replaces the Proxy-Authorization header where
        necessary.

        :rtype: dict
        Nno_proxyrh   allzProxy-Authorization)NN)
r:   rL   r	   r@   rM   r4   r!   rg   r   
setdefaultr"   r\   r   )
r<   rc   rJ   r:   rL   r@   Znew_proxiesrh   Zbypass_proxyZenviron_proxiesproxyZusernameZpasswordr'   r'   r+   r^     s*    


z$SessionRedirectMixin.rebuild_proxiesc                 C   sX   |j }|jtjkr|dkrd}|jtjkr6|dkr6d}|jtjkrN|dkrNd}||_ dS )zWhen being redirected we may want to change the method of the request
        based on certain specs or browser behavior.
        HEADGETPOSTN)methodrZ   r$   Z	see_otherfoundZmoved)r<   rc   r3   rp   r'   r'   r+   rY   =  s    z#SessionRedirectMixin.rebuild_method)FNTNNF)	__name__
__module____qualname__r>   rA   re   r_   r^   rY   r'   r'   r'   r+   r6   _   s           
q)r6   c                   @   s   e Zd ZdZdddddddd	d
ddd
dg
Zdd Zdd Zdd Zdd Zd7ddZ	dd Z
dd Zdd  Zd8d!d"Z
d9d#d$Zd:d%d&Zd'd( Zd)d* Zd+d, Zd-d. Zd/d0 Zd1d2 Zd3d4 Zd5d6 ZdS );Sessiona  A Requests session.

    Provides cookie persistence, connection-pooling, and configuration.

    Basic Usage::

      >>> import requests
      >>> s = requests.Session()
      >>> s.get('https://httpbin.org/get')
      <Response [200]>

    Or as a context manager::

      >>> with requests.Session() as s:
      >>>     s.get('https://httpbin.org/get')
      <Response [200]>
    r:   r]   authrJ   hooksparamsrH   rI   ZprefetchadaptersrF   rg   rU   c                 C   sr   t  | _d | _i | _t | _i | _d| _d| _d | _	t
| _d| _t
i | _t | _| dt  | dt  d S )NFTzhttps://zhttp://)r   r:   rv   rJ   r   rw   rx   rF   rH   rI   r   rU   rg   r   r]   r   ry   mountr   r<   r'   r'   r+   __init__m  s    
zSession.__init__c                 C   s   | S r&   r'   r{   r'   r'   r+   	__enter__  s    zSession.__enter__c                 G   s   |    d S r&   )rV   )r<   argsr'   r'   r+   __exit__  s    zSession.__exit__c              
   C   s   |j pi }t|tjst|}ttt | j |}|j}| jrR|sR| jsRt	|j
}t }|j|j
 |j
|j|j|jt|j| jtdt|j| jt|| j|t|j| jd
 |S )a  Constructs a :class:`PreparedRequest <PreparedRequest>` for
        transmission and returns it. The :class:`PreparedRequest` has settings
        merged from the :class:`Request <Request>` instance and those of the
        :class:`Session`.

        :param request: :class:`Request` instance to prepare with this
            session's settings.
        :rtype: requests.PreparedRequest
        )r0   )
rp   rL   filesdatajsonr:   rx   rv   r]   rw   )r]   r-   r   Z	CookieJarr   r   r
   rv   rg   r    rL   r   Zpreparerp   upperr   r   r   r2   r:   r   rx   r5   rw   )r<   rf   r]   Zmerged_cookiesrv   pr'   r'   r+   prepare_request  s0    

 

zSession.prepare_requestNTc                 C   st   t | ||||pi ||pi |||d
}| |}|p8i }| |j||
||}|	|
d}|| | j|f|}|S )a  Constructs a :class:`Request <Request>`, prepares it and sends it.
        Returns :class:`Response <Response>` object.

        :param method: method for the new :class:`Request` object.
        :param url: URL for the new :class:`Request` object.
        :param params: (optional) Dictionary or bytes to be sent in the query
            string for the :class:`Request`.
        :param data: (optional) Dictionary, list of tuples, bytes, or file-like
            object to send in the body of the :class:`Request`.
        :param json: (optional) json to send in the body of the
            :class:`Request`.
        :param headers: (optional) Dictionary of HTTP Headers to send with the
            :class:`Request`.
        :param cookies: (optional) Dict or CookieJar object to send with the
            :class:`Request`.
        :param files: (optional) Dictionary of ``'filename': file-like-objects``
            for multipart encoding upload.
        :param auth: (optional) Auth tuple or callable to enable
            Basic/Digest/Custom HTTP Auth.
        :param timeout: (optional) How long to wait for the server to send
            data before giving up, as a float, or a :ref:`(connect timeout,
            read timeout) <timeouts>` tuple.
        :type timeout: float or tuple
        :param allow_redirects: (optional) Set to True by default.
        :type allow_redirects: bool
        :param proxies: (optional) Dictionary mapping protocol or protocol and
            hostname to the URL of the proxy.
        :param stream: (optional) whether to immediately download the response
            content. Defaults to ``False``.
        :param verify: (optional) Either a boolean, in which case it controls whether we verify
            the server's TLS certificate, or a string, in which case it must be 