llerr  r  Z	processedZbestZto_activateZ
req_extrasr   r   r   r   r   Z
dependent_reqZnew_requirementsZnew_requirementr   r   r   r     sT    


  




zWorkingSet.resolvec                 C   s
  t |}|  i }i }|dkr4t| j}||7 }n|| }| g }	t t|	j|  |D ]}
||
 D ]}| g}z|	|||}
W nB t	k
r } z$|||< |rW Y qfn
W Y  qZW 5 d}~X Y qfX t t|	j|
 |
t|
  qZqfqZt |}|  ||fS )as  Find all activatable distributions in `plugin_env`

        Example usage::

            distributions, errors = working_set.find_plugins(
                Environment(plugin_dirlist)
            )
            # add plugins+libs to sys.path
            map(working_set.add, distributions)
            # display errors
            print('Could not load', errors)

        The `plugin_env` should be an ``Environment`` instance that contains
        only distributions that are in the project's "plugin directory" or
        directories. The `full_env`, if supplied, should be an ``Environment``
        contains all currently-available distributions.  If `full_env` is not
        supplied, one is created automatically from the ``WorkingSet`` this
        method is called on, which will typically mean that every directory on
        ``sys.path`` will be scanned for distributions.

        `installer` is a standard installer callback as used by the
        ``resolve()`` method. The `fallback` flag indicates whether we should
        attempt to resolve older versions of a plugin if the newest version
        cannot be resolved.

        This method returns a 2-tuple: (`distributions`, `error_info`), where
        `distributions` is a list of the distributions found in `plugin_env`
        that were loadable, along with any other distributions that are needed
        to resolve their dependencies.  `error_info` is a dictionary mapping
        unloadable plugin distributions to an exception instance describing the
        error that occurred. Usually this will be a ``DistributionNotFound`` or
        ``VersionConflict`` instance.
        N)
r  sortre   r   r   r   r   as_requirementr   rk   r%   r'   r(   )r   Z
plugin_envZfull_envr  ZfallbackZplugin_projectsZ
error_infoZ
distributionsr  Z
shadow_setr  r   r   Z	resolveesr"   r   r   r   find_plugins'  s4    $




zWorkingSet.find_pluginsc                 G   s&   |  t|}|D ]}| | q|S )a  Ensure that distributions matching `requirements` are activated

        `requirements` must be a string or a (possibly-nested) sequence
        thereof, specifying the distributions and versions required.  The
        return value is a sequence of the distributions that needed to be
        activated to fulfill the requirements; all relevant distributions are
        included, even if they were already activated in this working set.
        )r   rp   r   )r   r  Zneededr   r   r   r   rP   {  s    	zWorkingSet.requirec                 C   s8   || j krdS | j | |s"dS | D ]}|| q&dS )zInvoke `callback` for all distributions

        If `existing=True` (default),
        call on all existing ones, as well.
        N)r   r   )r   callbackexistingr   r   r   r   	subscribe  s    
zWorkingSet.subscribec                 C   s   | j D ]}|| qd S r   )r   )r   r   r  r   r   r   r    s    
zWorkingSet._added_newc                 C   s,   | j d d  | j | j | jd d  fS r   )r   r   r2   r   r   r   r   r   r   r0     s
      zWorkingSet.__getstate__c                 C   s@   |\}}}}|d d  | _ | | _| | _|d d  | _d S r   )r   r2   r   r   r   )r   Ze_k_b_cr   r
  r   r   r   r   r   r1     s
    

zWorkingSet.__setstate__)N)N)NTF)NNFN)NNT)T)r   r   r   r   r   classmethodr   r   r   r   r   rW   rQ   r  r   r   r  rP   r  r  r0   r1   r   r   r   r   rf   )  s4   





    
]     
T
c                   @   s   e Zd ZdZdddZdS )r
  z>
    Map each requirement to the extras that demanded it.
    Nc                    s2    fdd|   d|pd D } j p0t|S )z
        Evaluate markers for req against each extra that
        demanded it.

        Return False if the req has a marker and fails
        evaluation. Otherwise, return True.
        c                 3   s   | ]} j d |iV  qdS )extraNmarkerevaluate)r   r!  r   r   r   r     s   z*_ReqExtras.markers_pass.<locals>.<genexpr>r   r   )r   r#  any)r   r   r  Zextra_evalsr   r%  r   r    s    
z_ReqExtras.markers_pass)N)r   r   r   r   r  r   r   r   r   r
    s   r
  c                   @   sx   e Zd ZdZde efddZdd Zdd Zdd	d
Z	dd Z
d
d ZdddZdddZ
dd Zdd Zdd ZdS )re   z5Searchable snapshot of distributions on a search pathNc                 C   s    i | _ || _|| _| | dS )a!  Snapshot distributions available on a search path

        Any distributions found on `search_path` are added to the environment.
        `search_path` should be a sequence of ``sys.path`` items.  If not
        supplied, ``sys.path`` is used.

        `platform` is an optional string specifying the name of the platform
        that platform-specific distributions must be compatible with.  If
        unspecified, it defaults to the current platform.  `python` is an
        optional string naming the desired version of Python (e.g. ``'3.6'``);
        it defaults to the current version.

        You may explicitly set `platform` (and/or `python`) to ``None`` if you
        wish to map *all* distributions, not just those compatible with the
        running platform or Python version.
        N)_distmaprH   pythonscan)r   search_pathrH   r(  r   r   r   r     s    zEnvironment.__init__c                 C   s2   | j dkp|jdkp|j| j k}|o0t|j| jS )zIs distribution `dist` acceptable for this environment?

        The distribution must match the platform and python version
        requirements specified when this environment was created, or False
        is returned.
        N)r(  
py_versionrt   rH   )r   r   Z	py_compatr   r   r   can_add  s    

zEnvironment.can_addc                 C   s   | j |j | dS )z"Remove `dist` from the environmentN)r'  r8   remover   r   r   r   r-    s    zEnvironment.removec                 C   s4   |dkrt j}|D ]}t|D ]}| | qqdS )ad  Scan `search_path` for distributions usable in this environment

        Any distributions found are added to the environment.
        `search_path` should be a sequence of ``sys.path`` items.  If not
        supplied, ``sys.path`` is used.  Only distributions conforming to
        the platform/python version defined at initialization are added.
        N)rG   r   ra   r   )r   r*  r  r   r   r   r   r)    s
    zEnvironment.scanc                 C   s   |  }| j|g S )a  Return a newest-to-oldest list of distributions for `project_name`

        Uses case-insensitive `project_name` comparison, assuming all the
        project's distributions use their project's name converted to all
        lowercase as their key.

        )lowerr'  r   )r   r  Zdistribution_keyr   r   r   __getitem__  s    zEnvironment.__getitem__c                 C   sL   |  |rH| rH| j|jg }||krH|| |jtddd dS )zLAdd `dist` if we ``can_add()`` it and it has not already been added
        hashcmpTr8   reverseN)	r,  has_versionr'  r   r8   r   r  operator
attrgetter)r   r   r   r   r   r   r     s
    
zEnvironment.addFc                 C   sf   z| |}W n tk
r,   |s$ d}Y nX |dk	r:|S | |j D ]}||krD|  S qD| ||S )a  Find distribution best matching `req` and usable on `working_set`

        This calls the ``find(req)`` method of the `working_set` to see if a
        suitable distribution is already active.  (This may raise
        ``VersionConflict`` if an unsuitable version of the project is already
        active in the specified `working_set`.)  If a suitable distribution
        isn't active, this method returns the newest distribution in the
        environment that meets the ``Requirement`` in `req`.  If no suitable
        distribution is found, and `installer` is supplied, then the result of
        calling the environment's ``obtain(req, installer)`` method will be
        returned.
        N)r   rl   r8   obtain)r   r   r_   r  r  r   r   r   r   r    s    

zEnvironment.best_matchc                 C   s   |dk	r||S dS )a  Obtain a distribution matching `requirement` (e.g. via download)

        Obtain a distro that matches requirement (e.g. via download).  In the
        base ``Environment`` class, this routine just returns
        ``installer(requirement)``, unless `installer` is None, in which case
        None is returned instead.  This method is a hook that allows subclasses
        to attempt other ways of obtaining a distribution before falling back
        to the `installer` argument.Nr   )r   Zrequirementr  r   r   r   r6  +  s    	zEnvironment.obtainc                 c   s"   | j  D ]}| | r
|V  q
dS )z=Yield the unique project names of the available distributionsN)r'  r
  r   r8   r   r   r   r  7  s    zEnvironment.__iter__c                 C   sV   t |tr| | n<t |trD|D ]}|| D ]}| | q0q$ntd|f | S )z2In-place addition of a distribution or environmentzCan't add %r to environment)r   rh   r   re   r   )r   otherZprojectr   r   r   r   __iadd__=  s    

zEnvironment.__iadd__c                 C   s*   | j g ddd}| |fD ]}||7 }q|S )z4Add an environment or distribution to an environmentN)rH   r(  r   )r   r8  newr  r   r   r   __add__I  s    
zEnvironment.__add__)N)NF)N)r   r   r   r   rO   PY_MAJORr   r,  r-  r)  r/  r   r  r6  r  r9  r<  r   r   r   r   re     s"    


   

c                   @   s   e Zd ZdZdS )ro   aT  An error occurred extracting a resource

    The following attributes are available from instances of this exception:

    manager
        The resource manager that raised this exception

    cache_path
        The base directory for resource extraction

    original_error
        The exception instance that caused extraction to fail
    Nr   r   r   r   r   ro   U  s   c                   @   s   e Zd ZdZdZdd Zdd Zdd Zd	d
 Zdd Z	d
d Z
dd Zdd ZdddZ
edd Zdd Zdd Zd ddZdS )!rg   z'Manage resource extraction and packagesNc                 C   s
   i | _ d S r   )cached_filesr   r   r   r   r   i  s    zResourceManager.__init__c                 C   s   t ||S )zDoes the named resource exist?)rR   r   r   Zpackage_or_requirementr   r   r   r   r\   l  s    zResourceManager.resource_existsc                 C   s   t ||S )z,Is the named resource an existing directory?)rR   r]   r?  r   r   r   r]   p  s    zResourceManager.resource_isdirc                 C   s   t || |S )z4Return a true filesystem path for specified resource)rR   r   r?  r   r   r   rZ   v  s     z!ResourceManager.resource_filenamec                 C   s   t || |S )z9Return a readable file-like object for specified resource)rR   r   r?  r   r   r   rY   |  s     zResourceManager.resource_streamc                 C   s   t || |S )z%Return specified resource as a string)rR   r   r?  r   r   r   rX     s     zResourceManager.resource_stringc                 C   s   t ||S )z1List the contents of the named resource directory)rR   r[   r?  r   r   r   r[     s    z ResourceManager.resource_listdirc                 C   sR   t  d }| jpt }td }t|jf t	 }| |_
||_||_|dS )z5Give an error message for problems extracting file(s)r   a  
            Can't extract file(s) to egg cache

            The following error occurred while trying to extract file(s)
            to the Python egg cache:

              {old_exc}

            The Python egg cache directory is currently set to:

              {cache_path}

            Perhaps your account does not have write access to this directory?
            You can change the cache directory by setting the PYTHON_EGG_CACHE
            environment variable to point to an accessible directory.
            N)
rG   exc_infoextraction_pathrd   textwrapdedentlstripro   r   r   r   
cache_pathZoriginal_error)r   old_excrE  tmplerrr   r   r   extraction_error  s    z ResourceManager.extraction_errorr   c                 C   sf   | j p
t }tjj||d f| }zt| W n tk
rL   |   Y nX | | d| j	|< |S )a  Return absolute location in cache for `archive_name` and `names`

        The parent directory of the resulting path will be created if it does
        not already exist.  `archive_name` should be the base filename of the
        enclosing egg (which may not be the name of the enclosing zipfile!),
        including its ".egg" extension.  `names`, if provided, should be a
        sequence of path name parts "under" the egg's extraction location.

        This method should only be called by resource providers that need to
        obtain an extraction location, and only for names they intend to
        extract, as it tracks the generated names for possible cleanup later.
        z-tmpr   )
rA  rd   r   r   rI   _bypass_ensure_directory	ExceptionrI  _warn_unsafe_extraction_pathr>  )r   Zarchive_namenamesZextract_pathZtarget_pathr   r   r   get_cache_path  s    


zResourceManager.get_cache_pathc                 C   sV   t jdkr| t jd sdS t | j}|tj@ s>|tj@ rRd|  }t	|t
 dS )aN  
        If the default extraction path is overridden and set to an insecure
        location, such as /tmp, it opens up an opportunity for an attacker to
        replace an extracted file with an unauthorized payload. Warn the user
        if a known insecure location is used.

        See Distribute #375 for more details.
        ntZwindirNz%s is writable by group/others and vulnerable to attack when used with get_resource_filename. Consider a more secure location (set with .set_extraction_path or the PYTHON_EGG_CACHE environment variable).)r   r   r   environstatst_modeS_IWOTHS_IWGRPwarningswarnUserWarning)r   modemsgr   r   r   rL    s    
z,ResourceManager._warn_unsafe_extraction_pathc                 C   s.   t jdkr*t |jdB d@ }t || dS )a4  Perform any platform-specific postprocessing of `tempname`

        This is where Mac header rewrites should be done; other platforms don't
        have anything special they should do.

        Resource providers should call this method ONLY after successfully
        extracting a compressed resource.  They must NOT call it on resources
        that are already in the filesystem.

        `tempname` is the current (temporary) name of the file, and `filename`
        is the name it will be renamed to by the caller after this routine
        returns.
        posixim  i  N)r   r   rQ  rR  chmod)r   ZtempnamefilenamerX  r   r   r   postprocess  s    
zResourceManager.postprocessc                 C   s   | j rtd|| _dS )a  Set the base path where resources will be extracted to, if needed.

        If you do not call this routine before any extractions take place, the
        path defaults to the return value of ``get_default_cache()``.  (Which
        is based on the ``PYTHON_EGG_CACHE`` environment variable, with various
        platform-specific fallbacks.  See that routine's documentation for more
        details.)

        Resources are extracted to subdirectories of this path based upon
        information given by the ``IResourceProvider``.  You may set this to a
        temporary directory, but then you must call ``cleanup_resources()`` to
        delete the extracted files when done.  There is no guarantee that
        ``cleanup_resources()`` will be able to remove all extracted files.

        (Note: you may not change the extraction path for a given resource
        manager once resources have been extracted, unless you first call
        ``cleanup_resources()``.)
        z5Can't change extraction path, files already extractedN)r>  rL   rA  r   r   r   r   r   rb     s
    z#ResourceManager.set_extraction_pathFc                 C   s   dS )aB  
        Delete all extracted resource files and directories, returning a list
        of the file and directory names that could not be successfully removed.
        This function does not have any concurrency protection, so it should
        generally only be called when the extraction path is a temporary
        directory exclusive to a single process.  This method is not
        automatically called; you must call it explicitly or register it as an
        ``atexit`` function if you wish to ensure cleanup of a temporary
        directory used for extractions.
        Nr   )r   forcer   r   r   rc     s    z!ResourceManager.cleanup_resources)r   )F)r   r   r   r   rA  r   r\   r]   rZ   rY   rX   r[   rI  rN  staticmethodrL  r]  rb   rc   r   r   r   r   rg   e  s    

c                   C   s   t jdptjddS )z
    Return the ``PYTHON_EGG_CACHE`` environment variable
    or a platform-relevant user cache dir for an app
    named "Python-Eggs".
    ZPYTHON_EGG_CACHEzPython-Eggs)Zappname)r   rP  r   r   Zuser_cache_dirr   r   r   r   rd     s    
c                 C   s   t dd| S )zConvert an arbitrary string to a standard distribution name

    Any runs of non-alphanumeric/. characters are replaced with a single '-'.
    [^A-Za-z0-9.]+-)resubr   r   r   r   rq   %  s    c                 C   sJ   zt tj| W S  tjjk
rD   | dd} tdd|  Y S X dS )zB
    Convert an arbitrary string to a standard version string
    r   rB   ra  rb  N)r   r   r   r   r    r   rc  rd  )r   r   r   r   rr   -  s
    c                 C   s   t dd|  S )zConvert an arbitrary string to a standard 'extra' name

    Any runs of non-alphanumeric characters are replaced with a single '_',
    and the result is always lowercased.
    z[^A-Za-z0-9.-]+r   )rc  rd  r.  )r!  r   r   r   rw   9  s    c                 C   s   |  ddS )z|Convert a project or version name to its filename-escaped form

    Any '-' characters are currently replaced with '_'.
    rb  r   r  r   r   r   r   rx   B  s    c              
   C   sH   zt |  W n6 tk
rB } zd|_d|_| W Y S d}~X Y nX dS )zo
    Validate text as a PEP 508 environment marker; return an exception
    if invalid or False otherwise.
    NF)rz   SyntaxErrorr\  lineno)texter   r   r   ry   J  s    c              
   C   sJ   zt j| }| W S  t jjk
rD } zt|W 5 d}~X Y nX dS )z
    Evaluate a PEP 508 environment marker.
    Return a boolean indicating the marker result in this environment.
    Raise SyntaxError if marker is invalid.

    This implementation uses the 'pyparsing' module.
    N)r   ZmarkersZMarkerr$  Z
InvalidMarkerre  )rg  r!  r#  rh  r   r   r   rz   X  s
    
c                   @   s   e Zd ZdZdZdZdZdd Zdd Zdd Z	d	d
 Z
dd Zd
d Zdd Z
dd Zdd Zdd Zdd Zdd Zdd Zdd Zdd  Zd!d" Zd#d$ Zd%d& Zed'd( Zd)d* ZdS )+r   zETry to implement resources and metadata for arbitrary PEP 302 loadersNc                 C   s(   t |dd | _tjt |dd| _d S )Nr   __file__r   )r   r   r   r   dirnamemodule_pathr   r   r   r   r   r   n  s    zNullProvider.__init__c                 C   s   |  | j|S r   )_fnrk  r   r   r   r   r   r   r   r  s    z"NullProvider.get_resource_filenamec                 C   s   t | ||S r   )ioBytesIOr   rn  r   r   r   r   u  s    z NullProvider.get_resource_streamc                 C   s   |  | | j|S r   )_getrm  rk  rn  r   r   r   r   x  s    z NullProvider.get_resource_stringc                 C   s   |  | | j|S r   )_hasrm  rk  r   r   r   r   r   r   {  s    zNullProvider.has_resourcec                 C   s   |  | j|S r   )rm  egg_infor   r   r   r   r   _get_metadata_path~  s    zNullProvider._get_metadata_pathc                 C   s    | j s| j S | |}| |S r   )rt  rv  rr  r   r   r   r   r   r   r     s    
zNullProvider.has_metadatac              
   C   st   | j s
dS | |}| |}tjr(|S z|dW S  tk
rn } z| jd||7  _ W 5 d }~X Y nX d S )Nr   utf-8z in {} file at path: {})	rt  rv  rq  r   PY2decodeUnicodeDecodeErrorreasonr   )r   r   r   valueexcr   r   r   r     s    

zNullProvider.get_metadatac                 C   s   t | |S r   ru   r   ru  r   r   r   r     s    zNullProvider.get_metadata_linesc                 C   s   |  | | j|S r   )_isdirrm  rk  rs  r   r   r   r]     s    zNullProvider.resource_isdirc                 C   s   | j o| | | j |S r   )rt  r  rm  ru  r   r   r   r     s    zNullProvider.metadata_isdirc                 C   s   |  | | j|S r   )_listdirrm  rk  rs  r   r   r   r[     s    zNullProvider.resource_listdirc                 C   s   | j r| | | j |S g S r   )rt  r  rm  ru  r   r   r   r     s    zNullProvider.metadata_listdirc           
      C   s   d| }|  |s$tdjf t | |dd}|dd}| | j|}||d< tj	
|rt| }t
||d}t||| n>dd	lm} t|d|d|f||< t
||d}	t|	|| d S )
Nzscripts/z<Script {script!r} not found in metadata at {self.egg_info!r}z


ri  execr   )cache)r   rk   r   r   r   r   rm  rt  r   r   r   r   readcompiler  	linecacher  lenr   )
r   r   r   ZscriptZscript_textZscript_filenamesourcecoder  Zscript_coder   r   r   rQ     s.    
   zNullProvider.run_scriptc                 C   s   t dd S Nz9Can't perform this operation for unregistered loader typeNotImplementedErrorr^  r   r   r   rr    s    zNullProvider._hasc                 C   s   t dd S r  r  r^  r   r   r   r    s    zNullProvider._isdirc                 C   s   t dd S r  r  r^  r   r   r   r    s    zNullProvider._listdirc                 C   s*   |  | |r&tjj|f|d S |S )N/)_validate_resource_pathr   r   rI   r   )r   baser   r   r   r   rm    s    
zNullProvider._fnc                 C   sp   t jj| tjkp&t| p&t| }|s0dS d}t| rPt| sPt|t	j
|dd d tdd dS )aO  
        Validate the resource paths according to the docs.
        https://setuptools.readthedocs.io/en/latest/pkg_resources.html#basic-resource-access

        >>> warned = getfixture('recwarn')
        >>> warnings.simplefilter('always')
        >>> vrp = NullProvider._validate_resource_path
        >>> vrp('foo/bar.txt')
        >>> bool(warned)
        False
        >>> vrp('../foo/bar.txt')
        >>> bool(warned)
        True
        >>> warned.clear()
        >>> vrp('/foo/bar.txt')
        >>> bool(warned)
        True
        >>> vrp('foo/../../bar.txt')
        >>> bool(warned)
        True
        >>> warned.clear()
        >>> vrp('foo/f../bar.txt')
        >>> bool(warned)
        False

        Windows path separators are straight-up disallowed.
        >>> vrp(r'\foo/bar.txt')
        Traceback (most recent call last):
        ...
        ValueError: Use of .. or absolute path in a resource path is not allowed.

        >>> vrp(r'C:\foo/bar.txt')
        Traceback (most recent call last):
        ...
        ValueError: Use of .. or absolute path in a resource path is not allowed.

        Blank values are allowed

        >>> vrp('')
        >>> bool(warned)
        False

        Non-string values are not.

        >>> vrp(None)
        Traceback (most recent call last):
        ...
        AttributeError: ...
        Nz=Use of .. or absolute path in a resource path is not allowed.r   z/ and will raise exceptions in a future release.r   
stacklevel)r   r   pardirr   	posixpathsepisabsntpathrL   rU  rV  DeprecationWarning)r   ZinvalidrY  r   r   r   r    s    6z$NullProvider._validate_resource_pathc                 C   s$   t | jdr| j|S tdd S )Nget_dataz=Can't perform this operation for loaders without 'get_data()')r   r   r  r  r^  r   r   r   rq    s
    zNullProvider._get)r   r   r   r   egg_namert  r   r   r   r   r   r   rv  r   r   r   r]   r   r[   r   rQ   rr  r  r  rm  r`  r  rq  r   r   r   r   r   g  s2   
Jc                   @   s    e Zd ZdZdd Zdd ZdS )r   z&Provider based on a virtual filesystemc                 C   s   t | | |   d S r   )r   r   
_setup_prefixrl  r   r   r   r   -  s    zEggProvider.__init__c                 C   sZ   | j }d }||krVt|r@tj|| _tj|d| _|| _qV|}tj	|\}}q
d S )NEGG-INFO)
rk  _is_egg_pathr   r   basenamer  rI   rt  egg_rootr   )r   r   oldr  r   r   r   r  1  s    zEggProvider._setup_prefixN)r   r   r   r   r   r  r   r   r   r   r   *  s   c                   @   sD   e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Ze	dd
 Z
dS )r   z6Provides access to package resources in the filesystemc                 C   s   t j|S r   )r   r   r   r^  r   r   r   rr  C  s    zDefaultProvider._hasc                 C   s   t j|S r   )r   r   r
   r^  r   r   r   r  F  s    zDefaultProvider._isdirc                 C   s
   t |S r   )r   listdirr^  r   r   r   r  I  s    zDefaultProvider._listdirc                 C   s   t | | j|dS Nrb)r   rm  rk  rn  r   r   r   r   L  s    z#DefaultProvider.get_resource_streamc              
   C   s*   t |d}| W  5 Q R  S Q R X d S r  )r   r  )r   r   streamr   r   r   rq  O  s    zDefaultProvider._getc                 C   s,   d}|D ]}t t|td }t||  qd S )N)SourceFileLoaderSourcelessFileLoader)r   importlib_machinerytyper   )r   Zloader_namesr   Z
loader_clsr   r   r   	_registerS  s    zDefaultProvider._registerN)r   r   r   r   rr  r  r  r   rq  r   r  r   r   r   r   r   @  s   c                   @   s8   e Zd ZdZdZdd  ZZdd Zdd Zd	d
 Z	dS )r   z.Provider that returns nothing for all requestsNc                 C   s   dS NFr   r^  r   r   r   r?   c  r@   zEmptyProvider.<lambda>c                 C   s   dS Nr   r   r^  r   r