rllib3.exceptionsr#   simplefilterr%   r&   r'   r(   r)   r*   r+   r,   r-    r.   r/   Zmodelsr0   r1   r2   Zapir3   r4   r5   r6   r   r7   r8   r9   Zsessionsr:   r;   Zstatus_codesr<   r=   r>   r?   r@   rA   rB   rC   rD   rE   ZloggingrF   Z	getLogger__name__Z
addHandlerr   r   r   r   <module>   sP   # 
(,PK       ! 蛂Me   e   (  requests/__pycache__/auth.cpython-38.pycnu [        U

    .e'                     @   s   d Z ddlZddlZddlZddlZddlZddlZddlmZ ddl	m
Z
mZmZ ddl
mZ ddlmZ ddlmZ d	Zd
Zdd ZG d
d deZG dd deZG dd deZG dd deZdS )z]
requests.auth
~~~~~~~~~~~~~

This module contains the authentication handlers for Requests.
    N)	b64encode   )urlparsestr
basestring)extract_cookies_to_jar)to_native_string)parse_dict_headerz!application/x-www-form-urlencodedzmultipart/form-datac                 C   s   t | ts&tjd| td t| } t |tsLtjd|td t|}t | tr`| d} t |trt|d}dtt	d
| |f  }|S )zReturns a Basic Auth string.zNon-string usernames will no longer be supported in Requests 3.0.0. Please convert the object you've passed in ({!r}) to a string or bytes object in the near future to avoid problems.)categoryzNon-string passwords will no longer be supported in Requests 3.0.0. Please convert the object you've passed in ({!r}) to a string or bytes object in the near future to avoid problems.latin1zBasic    :)
isinstancer   warningswarnformatDeprecationWarningr   encoder   r   joinstrip)usernamepasswordZauthstr r   =/usr/lib/python3.8/site-packages/pip/_vendor/requests/auth.py_basic_auth_str   s0    






r   c                   @   s   e Zd ZdZdd ZdS )AuthBasez4Base class that all auth implementations derive fromc                 C   s   t dd S )NzAuth hooks must be callable.)NotImplementedErrorselfrr   r   r   __call__K   s    zAuthBase.__call__N__name__
__module____qualname____doc__r   r   r   r   r   r   H   s   r   c                   @   s0   e Zd ZdZdd Zdd Zdd Zdd	 Zd
S )
HTTPBasicAuthz?Attaches HTTP Basic Authentication to the given Request object.c                 C   s   || _ || _d S N)r   r   r   r   r   r   r   r   __init__R   s    zHTTPBasicAuth.__init__c                 C   s(   t | jt|dd k| jt|dd kgS Nr   r   allr   getattrr   r   otherr   r   r   __eq__V   s    zHTTPBasicAuth.__eq__c                 C   s
   | |k S r&   r   r-   r   r   r   __ne__\   s    zHTTPBasicAuth.__ne__c                 C   s   t | j| j|jd< |S )N
Authorizationr   r   r   headersr   r   r   r   r   _   s    zHTTPBasicAuth.__call__N)r!   r"   r#   r$   r(   r/   r0   r   r   r   r   r   r%   O   s
   r%   c                   @   s   e Zd ZdZdd ZdS )
HTTPProxyAuthz=Attaches HTTP Proxy Authentication to a given Request object.c                 C   s   t | j| j|jd< |S )NzProxy-Authorizationr2   r   r   r   r   r   g   s    zHTTPProxyAuth.__call__Nr    r   r   r   r   r4   d   s   r4   c                   @   sP   e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	dd Z
dd ZdS )HTTPDigestAuthz@Attaches HTTP Digest Authentication to the given Request object.c                 C   s   || _ || _t | _d S r&   )r   r   	threadingZlocal
_thread_localr'   r   r   r   r(   o   s    zHTTPDigestAuth.__init__c                 C   s@   t | jds<d| j_d| j_d| j_i | j_d | j_d | j_d S )NinitT r   )hasattrr7   r8   
last_noncenonce_countchalpos
num_401_calls)r   r   r   r   init_per_thread_stateu   s    z$HTTPDigestAuth.init_per_thread_statec                    s  | j jd }| j jd }| j jd}| j jd}| j jd}d |dkrTd}n| }|dksl|dkrzd	d
 }	|	 n@|dkrdd
 }
|
 n*|dkrdd }| n|dkrdd }|  fdd}
 dkrdS d}t|}|jpd}|jr|d|j 7 }d| j|| jf }d||f } |} |}|| j j	krJ| j  j
d7  _
nd| j _
d| j j
 }t| j j
d}||d7 }|t
 d7 }|td7 }t| dd }|dkrЈ d|||f }|s|
|d||f }n<|dksd|d kr"d!|||d|f }|
||}ndS || j _	d"| j||||f }|rT|d#| 7 }|rf|d$| 7 }|rx|d%| 7 }|r|d&||f 7 }d'| S )(z
        :rtype: str
        realmnonceqop	algorithmopaqueNZMD5zMD5-SESSc                 S   s"   t | tr| d} t|  S Nutf-8)r
   r   r   hashlibZmd5	hexdigestxr   r   r   md5_utf8   s    

z4HTTPDigestAuth.build_digest_header.<locals>.md5_utf8ZSHAc                 S   s"   t | tr| d} t|  S rF   )r
   r   r   rH   sha1rI   rJ   r   r   r   sha_utf8   s    

z4HTTPDigestAuth.build_digest_header.<locals>.sha_utf8zSHA-256c                 S   s"   t | tr| d} t|  S rF   )r
   r   r   rH   Zsha256rI   rJ   r   r   r   sha256_utf8   s    

z7HTTPDigestAuth.build_digest_header.<locals>.sha256_utf8zSHA-512c                 S   s"   t | tr| d} t|  S rF   )r
   r   r   rH   Zsha512rI   rJ   r   r   r   sha512_utf8   s    

z7HTTPDigestAuth.build_digest_header.<locals>.sha512_utf8c                    s    d| |f S )N%s:%sr   )sdZ	hash_utf8r   r   <lambda>       z4HTTPDigestAuth.build_digest_header.<locals>.<lambda>/?z%s:%s:%srQ   r   z%08xrG         Zauth,z%s:%s:%s:%s:%sz>username="%s", realm="%s", nonce="%s", uri="%s", response="%s"z
, opaque="%s"z, algorithm="%s"z
, digest="%s"z , qop="auth", nc=%s, cnonce="%s"z	Digest %s)r7   r=   getupperr   pathZqueryr   r   r;   r<   r   r   timectimeosurandomrH   rM   rI   split)r   methodurlrA   rB   rC   rD   rE   Z
_algorithmrL   rN   rO   rP   ZKDZentdigZp_parsedr^   ZA1ZA2ZHA1ZHA2ZncvaluerR   ZcnonceZrespdigZnoncebitbaser   rT   r   build_digest_header   s    

    z"HTTPDigestAuth.build_digest_headerc                 K   s   |j rd| j_dS )z)Reset num_401_calls counter on redirects.r   N)Zis_redirectr7   r?   )r   r   kwargsr   r   r   handle_redirect   s    zHTTPDigestAuth.handle_redirectc                 K   s"  d|j   krdk s$n d| j_|S | jjdk	rB|jj| jj |jdd}d|	 kr| jjdk r| j jd7  _t
jd	t
jd
}t
|jd|dd| j_|j |  |j }t|j|j|j ||j | |j|j|jd< |jj|f|}|j| ||_|S d| j_|S )
zo
        Takes the given response and tries digest-auth, if needed.

        :rtype: requests.Response
        i  i  r   Nzwww-authenticater9   Zdigest   zdigest )flags)countr1   )Zstatus_coder7   r?   r>   Zrequestbodyseekr3   r\   lowerrecompile
IGNORECASEr	   subr=   Zcontentclosecopyr   Z_cookiesrawZprepare_cookiesrg   rd   re   Z
connectionsendhistoryappend)r   r   rh   Zs_authZpatZprepZ_rr   r   r   
handle_401   s2    	
 
zHTTPDigestAuth.handle_401c                 C   s~   |    | jjr&| |j|j|jd< z|j | j_	W n t
k
rT   d | j_	Y nX |d| j |d| j
 d| j_|S )Nr1   Zresponser   )r@   r7   r;   rg   rd   re   r3   rm   tellr>   AttributeErrorZ
register_hookrz   ri   r?   r   r   r   r   r     s    zHTTPDigestAuth.__call__c                 C   s(   t | jt|dd k| jt|dd kgS r)   r*   r-   r   r   r   r/   *  s    zHTTPDigestAuth.__eq__c                 C   s
   | |k S r&   r   r-   r   r   r   r0   0  s    zHTTPDigestAuth.__ne__N)r!   r"   r#   r$   r(   r@   rg   ri   rz   r   r/   r0   r   r   r   r   r5   l   s   
f,r5   )r$   ra   rp   r_   rH   r6   r   base64r   compatr   r   r   Zcookiesr   Z_internal_utilsr   Zutilsr	   ZCONTENT_TYPE_FORM_URLENCODEDZCONTENT_TYPE_MULTI_PARTr   objectr   r%   r4   r5   r   r   r   r   <module>   s$   ,PK       ! |c    /  requests/__pycache__/__version__.cpython-38.pycnu [        U

    .e                     @   s,   d Z dZdZdZdZdZdZdZdZd	Z	d
S )ZrequestszPython HTTP for Humans.zhttp://python-requests.orgz2.22.0i " z
Kenneth Reitzzme@kennethreitz.orgz
Apache 2.0zCopyright 2019 Kenneth Reitzu   ✨ 🍰 ✨N)
Z	__title__Z__description__Z__url____version__Z	__build__
__author__Z__author_email__Z__license__Z
__copyright__Z__cake__ r   r   D/usr/lib/python3.8/site-packages/pip/_vendor/requests/__version__.py<module>   s   PK       ! :U  U  /  requests/__pycache__/certs.cpython-38.opt-1.pycnu [        U

    .e                     @   s&   d Z ddlmZ edkr"ee  dS )uF  
requests.certs
~~~~~~~~~~~~~~

This module returns the preferred default CA certificate bundle. There is
only one — the one from the certifi package.

If you are packaging Requests, e.g., for a Linux distribution or a managed
environment, you can change the definition of where() to return a separately
packaged CA bundle.
    )where__main__N)__doc__Zpip._vendor.certifir   __name__print r   r   >/usr/lib/python3.8/site-packages/pip/_vendor/requests/certs.py<module>   s   PK       ! u'QV  V  /  requests/__pycache__/utils.cpython-38.opt-1.pycnu [        U

    .eau                     @   s  d Z ddlZddlZddlZddlZddlZddlZddlZddlZddl	Z	ddl
Z
ddlZddlmZ ddl
mZ ddlmZ ddlmZ ddlmZmZmZmZmZmZmZmZmZmZmZmZm Z m!Z!m"Z" dd	l#m$Z$ dd
l%m&Z& ddl'm(Z(m)Z)m*Z*m+Z+ dZ,e- Z.d
ddZ/ej0dkr2dd Z1dd Zdd Z2dd Z3dhddZ4dd Z5dd Z6d d! Z7d"d# Z8d$d% Z9d&d' Z:did(d)Z;d*d+ Z<d,d- Z=d.d/ Z>d0d1 Z?d2d3 Z@d4d5 ZAd6d7 ZBd8d9 ZCeDd:ZEd;d< ZFd=d> ZGd?d@ ZHdAdB ZIdCdD ZJdEdF ZKejLdGdH ZMdIdJ ZNdjdKdLZOdMdN ZPdkdPdQZQdRdS ZRdTdU ZSdVTdWZUeUdX ZVeUdY ZWdZd[ ZXd\d] ZYd^d_ ZZe[d`Z\e[daZ]dbdc Z^ddde Z_dfdg Z`dS )lz
requests.utils
~~~~~~~~~~~~~~

This module provides utility functions that are used within Requests
that are also useful for external consumption.
    N   __version__)certs)to_native_string)parse_http_list)quoteurlparsebytesstrOrderedDictunquote
getproxiesproxy_bypass
urlunparse
basestring
integer_typesis_py3proxy_bypass_environmentgetproxies_environmentMappingcookiejar_from_dict)CaseInsensitiveDict)
InvalidURL
InvalidHeaderFileModeWarningUnrewindableBodyError)z.netrc_netrcP   i  )ZhttpZhttpsZwin32c                 C   s   zt rdd l}ndd l}W n tk
r0   Y dS X z6||jd}t||dd }||dd }W n tk
r~   Y dS X |r|sdS |	d}|D ]T}|dkrd| kr d	S |
dd
}|
dd}|
d
d}t|| tj
r d	S qdS )Nr   Fz;Software\Microsoft\Windows\CurrentVersion\Internet SettingsZProxyEnableZ
ProxyOverride;z<local>.Tz\.*z.*?)r   winreg_winregImportErrorOpenKeyHKEY_CURRENT_USERintZQueryValueExOSErrorsplitreplacerematchI)hostr$   ZinternetSettingsZproxyEnableZ
proxyOverrideZtest r1   >/usr/lib/python3.8/site-packages/pip/_vendor/requests/utils.pyproxy_bypass_registry/   sF    

r3   c                 C   s   t  rt| S t| S dS )zReturn True, if the host should be bypassed.

        Checks proxy settings gathered from the environment, if specified,
        or the registry.
        N)r   r   r3   )r0   r1   r1   r2   r   V   s    r   c                 C   s   t | dr|  } | S )z/Returns an internal sequence dictionary update.items)hasattrr4   )dr1   r1   r2   dict_to_sequenceb   s    
r7   c              	   C   s4  d }d}t | drt| }nbt | dr.| j}nPt | dr~z|  }W n tjk
rZ   Y n$X t|j}d| jkr~t	
dt t | drz|  }W n$ t
tfk
r   |d k	r|}Y n^X t | dr|d krz&| dd	 |  }| |pd W n t
tfk
r   d}Y nX |d kr&d}td|| S )
Nr   __len__lenfilenoba%  Requests has determined the content-length for this request using the binary size of the file: however, the file has been opened in text mode (i.e. without the 'b' flag in the mode). This may lead to an incorrect content-length. In Requests 3.0, support will be removed for files in text mode.tellseek   )r5   r9   r:   ioUnsupportedOperationosfstatst_sizemodewarningswarnr   r<   r*   IOErrorr=   max)oZtotal_lengthZcurrent_positionr:   r1   r1   r2   	super_lenk   sB    








rJ   Fc              	   C   s&  zddl m }m} d}tD ]J}ztjd|}W n tk
rP   Y  W dS X tj|r|} qhq|dkrvW dS t	| }d}t
| tr|d}|j
|d }	z:|||	}
|
r|
d rdnd}|
| |
d fW W S W n" |tfk
r   | r Y nX W n ttfk
r    Y nX dS )	z;Returns the Requests tuple auth for a given url from netrc.r   )netrcNetrcParseErrorNz~/{}   :asciir   r>   )rK   rL   NETRC_FILESrA   path
expanduserformatKeyErrorexistsr	   
isinstancer   decodenetlocr+   ZauthenticatorsrG   r&   AttributeError)urlZraise_errorsrK   rL   Z
netrc_pathfZlocZriZsplitstrr0   r   Zlogin_ir1   r1   r2   get_netrc_auth   s8    

r[   c                 C   sB   t | dd}|r>t|tr>|d dkr>|d dkr>tj|S dS )z0Tries to guess the filename of the given object.nameNr   <>)getattrrU   r   rA   rP   basename)objr\   r1   r1   r2   guess_filename   s
    
rc   c                 C   s   t j| r| S t j| \}}|rPt j|sPt j|\}}d||g}q t|s^| S t|}|| krx| S t	
 }t jj|f|d }t j|s|j||d}|S )zReplace nonexistent paths that look like they refer to a member of a zip
    archive with the location of an extracted copy of the target, or else
    just return the provided path unchanged.
    /)rP   )rA   rP   rT   r+   joinzipfileZ
is_zipfileZZipFileZnamelisttempfileZ
gettempdirextract)rP   archivememberprefixZzip_fileZtmpZextracted_pathr1   r1   r2   extract_zipped_paths   s     

rl   c                 C   s.   | dkrdS t | ttttfr&tdt| S )a  Take an object and test to see if it can be represented as a
    dictionary. Unless it can not be represented as such, return an
    OrderedDict, e.g.,

    ::

        >>> from_key_val_list([('key', 'val')])
        OrderedDict([('key', 'val')])
        >>> from_key_val_list('string')
        ValueError: cannot encode objects that are not 2-tuples
        >>> from_key_val_list({'key': 'val'})
        OrderedDict([('key', 'val')])

    :rtype: OrderedDict
    N+cannot encode objects that are not 2-tuples)rU   r   r
   boolr)   
ValueErrorr   valuer1   r1   r2   from_key_val_list  s
    rr   c                 C   s@   | dkrdS t | ttttfr&tdt | tr8|  } t| S )a  Take an object and test to see if it can be represented as a
    dictionary. If it can be, return a list of tuples, e.g.,

    ::

        >>> to_key_val_list([('key', 'val')])
        [('key', 'val')]
        >>> to_key_val_list({'key': 'val'})
        [('key', 'val')]
        >>> to_key_val_list('string')
        ValueError: cannot encode objects that are not 2-tuples.

    :rtype: list
    Nrm   )	rU   r   r
   rn   r)   ro   r   r4   listrp   r1   r1   r2   to_key_val_list  s    
rt   c                 C   sX   g }t | D ]F}|dd |dd   kr4dkrHn nt|dd }|| q|S )a  Parse lists as described by RFC 2068 Section 2.

    In particular, parse comma-separated lists where the elements of
    the list may include quoted-strings.  A quoted-string could
    contain a comma.  A non-quoted string could have quotes in the
    middle.  Quotes are removed automatically after parsing.

    It basically works like :func:`parse_set_header` just that items
    may appear multiple times and case sensitivity is preserved.

    The return value is a standard :class:`list`:

    >>> parse_list_header('token, "quoted value"')
    ['token', 'quoted value']

    To create a header from the :class:`list` again, use the
    :func:`dump_header` function.

    :param value: a string with a list header.
    :return: :class:`list`
    :rtype: list
    Nr   r^   ")_parse_list_headerunquote_header_valueappend)rq   resultitemr1   r1   r2   parse_list_header8  s    (r{   c                 C   sx   i }t | D ]f}d|kr"d||< q|dd\}} | dd | dd   krVdkrjn nt| dd } | ||< q|S )a^  Parse lists of key, value pairs as described by RFC 2068 Section 2 and
    convert them into a python dict:

    >>> d = parse_dict_header('foo="is a fish", bar="as well"')
    >>> type(d) is dict
    True
    >>> sorted(d.items())
    [('bar', 'as well'), ('foo', 'is a fish')]

 