 eggs.
    z.whlNr  r  r   
.dist-info)r  endswithr   r   rh   
from_filenamer[   r  r   r   rI   find_eggs_in_zip	zipimportzipimporterr.  rt  
from_location)	r  r  r  r  Zsubitemsubpathr   r   Zsubmetar   r   r   r    s$    

r  c                 C   s   dS r  r   )r  r  r  r   r   r   find_nothing  s    r  c                 C   s   dd }t | |ddS )aL  
    Given a list of filenames, return them in descending order
    by version number.

    >>> names = 'bar', 'foo', 'Python-2.7.10.egg', 'Python-2.7.2.egg'
    >>> _by_version_descending(names)
    ['Python-2.7.10.egg', 'Python-2.7.2.egg', 'foo', 'bar']
    >>> names = 'Setuptools-1.2.3b1.egg', 'Setuptools-1.2.3.egg'
    >>> _by_version_descending(names)
    ['Setuptools-1.2.3.egg', 'Setuptools-1.2.3b1.egg']
    >>> names = 'Setuptools-1.2.3b1.egg', 'Setuptools-1.2.3.post1.egg'
    >>> _by_version_descending(names)
    ['Setuptools-1.2.3.post1.egg', 'Setuptools-1.2.3b1.egg']
    c                 S   s2   t j| \} }t| d|g}dd |D S )z6
        Parse each component of the filename
        rb  c                 S   s   g | ]}t j|qS r   )r   r   r   )r   partr   r   r   
<listcomp>  s     z?_by_version_descending.<locals>._by_version.<locals>.<listcomp>)r   r   splitext	itertoolschainr   )r   extr  r   r   r   _by_version  s    z+_by_version_descending.<locals>._by_versionTr1  )sorted)rM  r  r   r   r   _by_version_descending  s    r  c           
      #   s   t tr4tjttjddV  dS t} fdd|D }t	|}|D ]2}tj|}t
| }||D ]
}	|	V  qq\dS )z6Yield distributions accessible on a sys.path directoryr  r  Nc                 3   s   | ]}t | r|V  qd S r   )dist_factory)r   r   r  r  r   r   r     s   zfind_on_path.<locals>.<genexpr>)_normalize_cached_is_unpacked_eggrh   r  r   r   r   rI   safe_listdirr  r  )
r  r  r  r   ZfilteredZpath_item_entriesr   fullpathfactoryr   r   r  r   find_on_path  s(      r  c                 C   sH   |  }tt|jd}|r tS |s0t|r0tS |sB|drBtS t S )z9
    Return a dist_factory for a path_item and entry
    )	.egg-infor  z	.egg-link)	r.  r&  r   r  distributions_from_metadatar  ra   resolve_egg_linkNoDists)r  r   r  r.  Zis_metar   r   r   r    s    r  c                   @   s*   e Zd ZdZdd ZejreZdd ZdS )r  zS
    >>> bool(NoDists())
    False

    >>> list(NoDists()('anything'))
    []
    c                 C   s   dS r  r   r   r   r   r   __bool__.  s    zNoDists.__bool__c                 C   s   t dS r  )iter)r   r	  r   r   r   __call__3  s    zNoDists.__call__N)	r   r   r   r   r  r   ry  Z__nonzero__r  r   r   r   r   r  &  s
   r  c              
   C   sv   zt | W S  ttfk
r$   Y nN tk
rp } z0|jtjtjtjfkpXt	|dddk}|s` W 5 d}~X Y nX dS )zI
    Attempt to list contents of path, but suppress some exceptions.
    ZwinerrorNi  r   )
r   r  PermissionErrorNotADirectoryErrorOSErrorerrnoZENOTDIRZEACCESZENOENTr   )r   rh  Z	ignorabler   r   r   r  7  s    r  c                 c   sf   t j| }t j| r:tt | dkr.d S t|| }nt| }t j| }t	j
|||tdV  d S )Nr   )
precedence)r   r   rj  r
   r  r  r   r   r  rh   r  r   )r   rootr  r   r   r   r   r
  L  s       r
  c              	   c   s4   t | "}|D ]}| }|r|V  qW 5 Q R X dS )z1
    Yield non-empty lines from file at path
    N)r   strip)r   r  liner   r   r   non_empty_lines[  s
    
r  c                    s.   t  } fdd|D }tt|}t|dS )za
    Given a path to an .egg-link, resolve distributions
    present in the referenced path.
    c                 3   s$   | ]}t jt j |V  qd S r   )r   r   rI   rj  )r   refr  r   r   r   l  s   z#resolve_egg_link.<locals>.<genexpr>r   )r  r   ra   next)r   Zreferenced_pathsZresolved_pathsZdist_groupsr   r  r   r  f  s    

r  
FileFinder_namespace_handlers)_namespace_packagesc                 C   s   |t | < dS )a  Register `namespace_handler` to declare namespace packages

    `importer_type` is the type or class of a PEP 302 "Importer" (sys.path item
    handler), and `namespace_handler` is a callable like this::

        def namespace_handler(importer, path_entry, moduleName, module):
            # return a path_entry to use for child packages

    Namespace handlers are only called if the importer object has already
    agreed that it can handle the relevant path item, and they should only
    return a subpath if the module __path__ does not already contain an
    equivalent subpath.  For an example namespace handler, see
    ``pkg_resources.file_ns_handler``.
    Nr  )r  Znamespace_handlerr   r   r   r   }  s    c              	   C   s   t |}|dkrdS t  td || }W 5 Q R X |dkrHdS tj| }|dkrt	|  }tj| < g |_
t|  nt|dst
d| tt|}|||| |}|dk	r|j
}|| ||  t|| | |S )zEEnsure that named package includes a subpath of path_item (if needed)Nignore__path__Not a package:)r   rU  catch_warningssimplefilterfind_modulerG   r   r   types
ModuleTyper#  _set_parent_nsr   r   r   r   r   load_module_rebuild_mod_path)packageNamer  r  r   r   Zhandlerr  r   r   r   r   
_handle_ns  s.    







r.  c                    sj   dd t jD fdd fdd}t| |d}dd |D }t|jtr`||jd	d	< n||_d	S )
zq
    Rebuild module.__path__ ensuring that all entries are ordered
    corresponding to their sys.path order
    c                 S   s   g | ]}t |qS r   r  r   pr   r   r   r    s     z%_rebuild_mod_path.<locals>.<listcomp>c                    s.   z  | W S  tk
r(   td Y S X dS )z/
        Workaround for #520 and #513.
        infN)indexrL   float)r   )sys_pathr   r   safe_sys_path_index  s    z._rebuild_mod_path.<locals>.safe_sys_path_indexc                    s<   |  tj} dd }|d|  }ttj|S )zR
        Return the ordinal of the path based on its position in sys.path
        rB   r   N)r   r   r  countr  rI   )r   
path_partsZmodule_partsr  )package_namer6  r   r   position_in_sys_path  s    z/_rebuild_mod_path.<locals>.position_in_sys_path)r8   c                 S   s   g | ]}t |qS r   r/  r0  r   r   r   r    s     N)rG   r   r  r   r#  r  )	orig_pathr9  r   r:  new_pathr   )r9  r6  r5  r   r,    s    		r,  c                 C   s   t   z| tkrW dS tj}| d\}}}|r|t| |tkrLt| ztj	| j
}W n tk
rz   td|Y nX t
|pdg |  t
| g  |D ]}t| | qW 5 t   X dS )z9Declare that package 'packageName' is a namespace packageNrB   r$  )_impacquire_lockrelease_lockr!  rG   r   
rpartitionr^   r   r   r#  r  r   r   r   r.  )r-  r   r  r   r  r   r   r   r^     s&    c                 C   sF   t   z.t|dD ]}t|| }|rt|| qW 5 t   X dS )zDEnsure that previously-declared namespace packages include path_itemr   N)r=  r>  r?  r!  r   r.  r   )r  r  packager  r   r   r   r     s    
c                 C   sD   t j||dd }t|}|jD ]}t||kr& q@q&|S dS )zBCompute an ns-package subpath for a filesystem or zipfile importerrB   r   N)r   r   rI   r   r  r#  )r  r  r-  r   r  Z
normalizedr  r   r   r   file_ns_handler  s    
rB  c                 C   s   d S r   r   )r  r  r-  r   r   r   r   null_ns_handler	  s    rC  c                 C   s    t jt jt jt| S )z1Normalize a file/dir name for comparison purposes)r   r   normcaserealpathr  
_cygwin_patchr\  r   r   r   r|   	  s    c                 C   s   t jdkrtj| S | S )a  
    Contrary to POSIX 2008, on Cygwin, getcwd (3) contains
    symlink components. Using
    os.path.abspath() works around this limitation. A fix in os.getcwd()
    would probably better, in Cygwin even more so, except
    that this seems to be by design...
    cygwin)rG   rH   r   r   abspathrG  r   r   r   rF  	  s    rF  c                 C   s8   z
||  W S  t k
r2   t|  || < }| Y S X d S r   )r   r|   )r\  r   resultr   r   r   r  )	  s
    
r  c                 C   s   |   dS )z7
    Determine if given path appears to be an egg.
    .egg)r.  r  r  r   r   r   r  1	  s    r  c                 C   s    t | otjtj| ddS )z@
    Determine if given path appears to be an unpacked egg.
    r  r  )r  r   r   r  rI   r  r   r   r   r  8	  s    r  c                 C   s<   |  d}| }|r8d|}ttj| |tj|   d S )NrB   )r   r  rI   setattrrG   r   )r-  r  r   r  r   r   r   r*  B	  s
    

r*  c                 c   sZ   t | tjr8|  D ] }| }|r|ds|V  qn| D ]}t|D ]
}|V  qHq<dS )z9Yield non-empty/non-comment lines of a string or sequence#N)r   r   r   
splitlinesr  r   ru   )strssZssr   r   r   ru   J	  s    
z\w+(\.\w+)*$z
    (?P<name>[^-]+) (
        -(?P<ver>[^-]+) (
            -py(?P<pyver>[^-]+) (
                -(?P<plat>.+)
            )?
        )?
    )?
    c                   @   s   e Zd ZdZdddZdd Zdd	 ZdddZd
d ZdddZ	e
dZe
dddZe
dd Ze
dddZe
dddZdS ) rj   z3Object representing an advertised importable objectr   Nc                 C   s<   t |std||| _|| _t|| _t|| _|| _d S )NzInvalid module name)MODULErL   r   module_nametupleattrsr  r   )r   r   rR  rT  r  r   r   r   r   r   j	  s    


zEntryPoint.__init__c                 C   sH   d| j | jf }| jr*|dd| j 7 }| jrD|dd| j 7 }|S )Nz%s = %s:rB   z [%s],)r   rR  rT  rI   r  )r   rP  r   r   r   r   s	  s    zEntryPoint.__str__c                 C   s   dt |  S )NzEntryPoint.parse(%r)r   r   r   r   r   r   {	  s    zEntryPoint.__repr__Tc                 O   s4   |r|s|rt jdtdd |r,| j|| |  S )zH
        Require packages for this EntryPoint, then resolve it.
        zJParameters to load are deprecated.  Call .resolve and .require separately.rC   r  )rU  rV  r   rP   r   )r   rP   r>   kwargsr   r   r   r  ~	  s    zEntryPoint.loadc              
   C   sX   t | jdgdd}ztt| j|W S  tk
rR } ztt|W 5 d}~X Y nX dS )zD
        Resolve the entry point from its module and attrs.
        r   r   )fromlistlevelN)	r   rR  	functoolsreducer   rT  r  r   r   )r   r   r~  r   r   r   r   	  s
    zEntryPoint.resolvec                 C   sL   | j r| jstd| | j| j }tj|||| j d}tttj| d S )Nz&Can't require() without a distribution)r  )	r  r   rn   r  r_   r   r  r   r   )r   r  r  r   r+   r   r   r   rP   	  s
    
zEntryPoint.requirez]\s*(?P<name>.+?)\s*=\s*(?P<module>[\w.]+)\s*(:\s*(?P<attr>[\w.]+))?\s*(?P<extras>\[.*\])?\s*$c                 C   sf   | j |}|sd}t||| }| |d }|d rJ|d dnd}| |d |d |||S )a  Parse a single entry point from string `src`

        Entry point syntax follows the form::

            name = some.module:some.attr [extra1, extra2]

        The entry name and module name are required, but the ``:attrs`` and
        ``[extras]`` parts are optional
        z9EntryPoint must be in 'name=module:attrs [extras]' formatr  attrrB   r   r   r   )patternrF   rL   	groupdict
_parse_extrasr   )r   srcr   rN   rY  resr  rT  r   r   r   r   	  s    
zEntryPoint.parsec                 C   s(   |sdS t d| }|jr"t |jS )Nr   x)ri   r   specsrL   r  )r   Zextras_specr   r   r   r   r`  	  s    zEntryPoint._parse_extrasc                 C   sV   t |std|i }t|D ]2}| ||}|j|krFtd||j|||j< q|S )zParse an entry point groupzInvalid group namezDuplicate entry point)rQ  rL   ru   r   r   )r   rK   linesr   thisr  epr   r   r   parse_group	  s    

zEntryPoint.parse_groupc                 C   st   t |tr| }nt|}i }|D ]J\}}|dkrB|s:q$td| }||kr\td|| |||||< q$|S )z!Parse a map of entry point groupsNz%Entry points must be listed in groupszDuplicate group name)r   r'   r+   rv   rL   r  rh  )r   datar   mapsrK   re  r   r   r   	parse_map	  s    


zEntryPoint.parse_map)r   r   N)T)NN)N)N)N)r   r   r   r   r   r   r   r  r   rP   rc  r  r^  r   r   r`  rh  rk  r   r   r   r   rj   g	  s$   
	



	
c                 C   s>   | sdS t j| }|d dr:t j|d d d S | S )Nr   r   zmd5=)r   )r   r   Zurlparser   Z
urlunparse)r  Zparsedr   r   r   _remove_md5_fragment	  s    rl  c                 C   s@   dd }t || }tt|d}|d\}}}t| p>dS )z
    Given an iterable of lines from a Metadata file, return
    the value of the Version field, if present, or None otherwise.
    c                 S   s   |   dS )Nzversion:)r.  r   )r  r   r   r   is_version_line	  s    z+_version_from_file.<locals>.is_version_liner   rU  N)r   r  r  	partitionrr   r  )re  rm  Z
version_linesr  r   r}  r   r   r   _version_from_file	  s
    
ro  c                       s  e Zd ZdZdZddddedefddZedSddZ	dd	 Z
ed
d Zdd
 Z
dd Zdd Zdd Zdd Zdd Zdd Zedd Zedd Zdd Zed d! Zed"d# Zed$d% Zd&d' ZdTd)d*Zd+d, Zd-d. Zd/d0 ZdUd2d3Z d4d5 Z!d6d7 Z"d8d9 Z#d:d; Z$ fd<d=Z%e&e'd>s4[%edVd?d@Z(dAdB Z)dCdD Z*dWdEdFZ+dGdH Z,dXdIdJZ-dKdL Z.dMdN Z/dOdP Z0edQdR Z1  Z2S )Yrh   z5Wrap an actual or potential sys.path entry w/metadatar  Nc                 C   sF   t |pd| _|d k	r t|| _|| _|| _|| _|| _|p>t| _	d S )NZUnknown)
rq   r  rr   _versionr+  rH   r  r  r   	_provider)r   r  r  r  r   r+  rH   r  r   r   r   r   
  s    
zDistribution.__init__c                 K   s~   d gd \}}}}t j|\}}	|	 tkr^t|	  } t|}
|
r^|
dddd\}}}}| ||f||||d| S )Nr   r   ZverZpyverrM   )r  r   r+  rH   )r   r   r  r.  _distributionImplEGG_NAMErK   _reload_version)r   r  r  r  r)   r  r   r+  rH   r   rF   r   r   r   r  
  s.          zDistribution.from_locationc                 C   s   | S r   r   r   r   r   r   rt  #
  s    zDistribution._reload_versionc                 C   s(   | j | j| jt| j| jpd| jp$dfS r  )parsed_versionr  r8   rl  r  r+  rH   r   r   r   r   r0  &
  s    zDistribution.hashcmpc                 C   s
   t | jS r   )hashr0  r   r   r   r   __hash__1
  s    zDistribution.__hash__c                 C   s   | j |j k S r   r0  r   r8  r   r   r   __lt__4
  s    zDistribution.__lt__c                 C   s   | j |j kS r   rx  ry  r   r   r   __le__7
  s    zDistribution.__le__c                 C   s   | j |j kS r   rx  ry  r   r   r   __gt__:
  s    zDistribution.__gt__c                 C   s   | j |j kS r   rx  ry  r   r   r   __ge__=
  s    zDistribution.__ge__c                 C   s   t || jsdS | j|jkS r  )r   r   r0  ry  r   r   r   __eq__@
  s    zDistribution.__eq__c                 C   s
   | |k S r   r   ry  r   r   r   __ne__F
  s    zDistribution.__ne__c                 C   s6   z| j W S  tk
r0   | j  | _ }| Y S X d S r   )Z_keyr  r  r.  r7  r   r   r   r8   M
  s
    zDistribution.keyc                 C   s   t | dst| j| _| jS )N_parsed_version)r   r#   r   r  r   r   r   r   ru  U
  s    
zDistribution.parsed_versionc                 C   sX   t jj}t| j|}|sd S | js&d S td dd}t	
|jf t| t
 d S )Na>  
            '{project_name} ({version})' is being parsed as a legacy,
            non PEP 440,
            version. You may find odd behavior and sort order.
            In particular it will be sorted as less than 0.0. It
            is recommended to migrate to PEP 440 compatible
            versions.
            r  r   )r   r   r!   r   r  rB  rC  r  r   rU  rV  r   varsr   )r   ZLVZ	is_legacyrG  r   r   r   _warn_legacy_version\
  s     	z!Distribution._warn_legacy_versionc                 C   sZ   z| j W S  tk
rT   |  }|d krL| | j}d| j|}t|| | Y S X d S )Nz4Missing 'Version:' header and/or {} file at path: {})rp  r  _get_version_get_metadata_path_for_displayPKG_INFOr   rL   )r   r   r   rY  r   r   r   r   v
  s     
zDistribution.versionc                 C   s4   z| j W S  tk
r,   | |  | _ Y nX | j S )z~
        A map of extra to its list of (direct) requirements
        for this distribution, including the null extra.
        )Z_Distribution__dep_mapr  _filter_extras_build_dep_mapr   r   r   r   _dep_map
  s
    zDistribution._dep_mapc                 C   sr   t td| D ]^}|}| |}|d\}}}|oDt|pDt| }|rNg }t|pXd}| |g | q| S )z
        Given a mapping of extras to dependencies, strip off
        environment markers and filter out any dependencies
        not matching the markers.
        NrU  )	r  r   r  rn  ry   rz   rw   r   r  )dmr!  Z	new_extrar   r   r#  Zfails_markerr   r   r   r  
  s    
zDistribution._filter_extrasc                 C   s@   i }dD ]2}t | |D ]\}}||g t| qq|S )N)zrequires.txtzdepends.txt)rv   
_get_metadatar   r  rp   )r   r  r   r!  r   r   r   r   r  
  s
    zDistribution._build_dep_mapr   c              	   C   sf   | j }g }||dd |D ]@}z||t|  W q  tk
r^   td| |f Y q X q |S )z@List of Requirements needed for this distro if `extras` are usedNr   z%s has no such extra feature %r)r  r  r   rw   r   rn   )r   r  r  Zdepsr   r   r   r   r  
  s    
zDistribution.requiresc                 C   s,   z| j |}W n tk
r&   Y dS X |S )zK
        Return the path to the given metadata file, if available.
        z[could not detect])rq  rv  rK  rw  r   r   r   r  
  s
    z+Distribution._get_metadata_path_for_displayc                 c   s$   |  |r | |D ]
}|V  qd S r   )r   r   )r   r   r  r   r   r   r  
  s    
zDistribution._get_metadatac                 C   s   |  | j}t|}|S r   )r  r  ro  )r   re  r   r   r   r   r  
  s    zDistribution._get_versionFc                 C   sV   |dkrt j}| j||d |t jkrRt| j | dD ]}|t jkr:t| q:dS )z>Ensure distribution is importable on `path` (default=sys.path)Nr  namespace_packages.txt)rG   r   r  r   r  r  r   r^   )r   r   r   Zpkgr   r 