 d S Nr   _setupZ_connection_classr   r  r  rb  r,   r,   r-   r     s    z
HTTP.__init__)r   Nr   r   r   r   r,   r,   r,   r-   r    s   r  c                   @   s   e Zd ZdddZdS )HTTPSr   Nc                 K   s&   |dkrd }|  | j||f| d S r  r  r  r,   r,   r-   r     s    zHTTPS.__init__)r   Nr  r,   r,   r,   r-   r    s   r  c                   @   s   e Zd ZdddZdd ZdS )	Transportr   c                 C   s   || _ tj| | d S rt   )r  r   r  r   r   r  use_datetimer,   r,   r-   r     s    zTransport.__init__c                 C   s`   |  |\}}}tdkr(t|| jd}n4| jr<|| jd krR|| _|t|f| _| jd }|S )Nr  )r  r   r   )
get_host_info	_ver_infor  r  _connection_extra_headersr   ZHTTPConnection)r   r  hehZx509r(   r,   r,   r-   make_connection
  s    
zTransport.make_connectionN)r   r   r   r   r   r  r,   r,   r,   r-   r    s   
r  c                   @   s   e Zd ZdddZdd ZdS )
SafeTransportr   c                 C   s   || _ tj| | d S rt   )r  r   r  r   r  r,   r,   r-   r     s    zSafeTransport.__init__c                 C   sx   |  |\}}}|si }| j|d< tdkr:t|d f|}n:| jrN|| jd krj|| _|tj|d f|f| _| jd }|S )Nr  r  r   r   )r  r  r  r  r  r  r   r  )r   r  r  r  rb  r(   r,   r,   r-   r    s    

zSafeTransport.make_connectionN)r   r  r,   r,   r,   r-   r    s   
r  c                   @   s   e Zd Zdd ZdS )ServerProxyc           	      K   st   | dd  | _}|d k	r^t|\}}|dd}|dkr@t}nt}|||d |d< }|| _tjj	| |f| d S )Nr  r  r   Zhttps)r  	transport)
rg   r  r   rG  r  r  r  r   r  r   )	r   rZ   rb  r  rW   r]   r  Ztclsr\   r,   r,   r-   r   ,  s    zServerProxy.__init__Nr  r,   r,   r,   r-   r  +  s   r  c                 K   s6   t jd dk r|d7 }nd|d< d|d< t| |f|S )Nr   r   br   newliner   r   )rp   r   r   )rV  r   rb  r,   r,   r-   	_csv_open@  s
    
r  c                   @   s4   e Zd ZedededdZdd Zdd Zd	S )
CSVBaserC   "r  )Z	delimiterZ	quotecharZlineterminatorc                 C   s   | S rt   r,   r   r,   r,   r-   	__enter__R  s    zCSVBase.__enter__c                 G   s   | j   d S rt   )r   r   )r   r$  r,   r,   r-   __exit__U  s    zCSVBase.__exit__N)r   r   r   r  defaultsr  r  r,   r,   r,   r-   r  K  s   r  c                   @   s(   e Zd Zdd Zdd Zdd ZeZdS )	CSVReaderc                 K   s\   d|kr4|d }t jd dkr,td|}|| _nt|d d| _tj| jf| j| _d S )Nr   r   r   r   rb   rE  )	rp   r   r   r   r   r  csvrI  r  )r   rb  r   r,   r,   r-   r   Z  s    zCSVReader.__init__c                 C   s   | S rt   r,   r   r,   r,   r-   __iter__e  s    zCSVReader.__iter__c                 C   sF   t | j}tjd dk rBt|D ] \}}t|ts |d||< q |S Nr   r   r   )nextrI  rp   r   r5  rw   r   r  )r   r(   r[   r  r,   r,   r-   r  h  s    

zCSVReader.nextN)r   r   r   r   r  r  __next__r,   r,   r,   r-   r  Y  s   r  c                   @   s   e Zd Zdd Zdd ZdS )	CSVWriterc                 K   s$   t |d| _tj| jf| j| _d S )Nr   )r  r   r  writerr  )r   rV  rb  r,   r,   r-   r   s  s    zCSVWriter.__init__c                 C   sN   t jd dk r>g }|D ]"}t|tr.|d}|| q|}| j| d S r  )rp   r   rw   r   r   r"   r  writerow)r   rowrE  r  r,   r,   r-   r  w  s    

zCSVWriter.writerowN)r   r   r   r   r  r,   r,   r,   r-   r  r  s   r  c                       sH   e Zd ZeejZded< d fdd	Zdd Zdd	 Zd
d Z	  Z
S )
Configuratorinc_convertZincNc                    s"   t t| | |pt | _d S rt   )superr  r   ra   r   ri   )r   configri   	__class__r,   r-   r     s    zConfigurator.__init__c           
         s   fdd  d}t|s*|}  dd }  dd}|r\tfdd|D } fd	d D }t|}|||}|r| D ]\}}	t|||	 q|S )
Nc                    sv   t | ttfr*t|  fdd| D }nHt | trhd| krH| }qri }| D ]} | | ||< qPn
| }|S )Nc                    s   g | ]} |qS r,   r,   )rN   r[   convertr,   r-   rO     s     zBConfigurator.configure_custom.<locals>.convert.<locals>.<listcomp>())rw   r
  ry  typedictconfigure_customr  )or(   r   )r  r   r,   r-   r    s    

z.Configurator.configure_custom.<locals>.convertr  r  z[]r,   c                    s   g | ]} |qS r,   r,   )rN   r
  r  r,   r-   rO     s     z1Configurator.configure_custom.<locals>.<listcomp>c                    s$   g | ]}t |r| | fqS r,   )r   )rN   r   )r  r  r,   r-   rO     s      )rg   r  r  ry  r  r   setattr)
r   r  r}   Zpropsra  r   rb  r(   r@  rI   r,   )r  r  r   r-   r	    s    


zConfigurator.configure_customc                 C   s4   | j | }t|tr0d|kr0| | | j |< }|S )Nr  )r  rw   r  r	  )r   r   r(   r,   r,   r-   __getitem__  s    
zConfigurator.__getitem__c              	   C   sF   t j|st j| j|}tj|ddd}t|}W 5 Q R X |S )z*Default converter for the inc:// protocol.rE  r   r   )	ra   rb   isabsr$   ri   r   r   r   r   )r   r   r   r(   r,   r,   r-   r    s
    zConfigurator.inc_convert)N)r   r   r   r  r   Zvalue_convertersr   r	  r  r  
__classcell__r,   r,   r  r-   r    s   
r  c                   @   s*   e Zd ZdZd
ddZdd Zdd	 ZdS )SubprocessMixinzC
    Mixin for running subprocesses and capturing their output
    FNc                 C   s   || _ || _d S rt   )verboseprogress)r   r  r  r,   r,   r-   r     s    zSubprocessMixin.__init__c                 C   sj   | j }| j}| }|sq^|dk	r.||| q|s@tjd ntj|d tj  q|  dS )z
        Read lines from a subprocess' output stream and either pass to a progress
        callable (if specified) or write progress information to sys.stderr.
        Nr  r   )	r  r  readlinerp   stderrr   r  flushr   )r   r   r  r  r  r+   r,   r,   r-   rI    s    zSubprocessMixin.readerc                 K   s   t j|ft jt jd|}tj| j|jdfd}|  tj| j|jdfd}|  |	  |
  |
  | jd k	r| dd n| jrt
jd |S )N)stdoutr  r  )r   ra  r  zdone.mainzdone.
)
subprocessPopenPIPE	threadingZThreadrI  r  r;  r  waitr$   r  r  rp   r   )r   cmdrb  r|   t1t2r,   r,   r-   run_command  s"    
zSubprocessMixin.run_command)FN)r   r   r   rX  r   rI  r  r,   r,   r,   r-   r    s   
r  c                 C   s   t dd|  S )z,Normalize a python package name a la PEP 503z[-_.]+r9  )r<  subry   )rP   r,   r,   r-   normalize_name  s    r!  )NN)r   )N)N)NT)r   collectionsr   
contextlibr  Zglobr   r  r  r   Zloggingra   r   r<  r   r  ImportErrorr  rp   r  r   r   r  Zdummy_threadingr  r   r   compatr   r   r   r	   r
   r   r   r
   r   r   r   r   r   r   r   r   r   r   r   r   r   Z	getLoggerr   r   r   r   rG   rF   r6   r>   r:   rV   r#   r?   r^   rm   rs   rx   r~   r   r   r   contextmanagerr   r   r   r   r   r   r   r  r  VERBOSEr  r   r+  r-  r/  r1  r4  r7  Ir>  r:  rA  rB  rC  rF  rK  rN  rO  rQ  rR  rY  rd  ZARCHIVE_EXTENSIONSr  r  r  r  r  r  r  r  r  r  r  r  r  r  r   r  r  r  r  r  r  r  r  r  r  r  r  r!  r,   r,   r,   r-   <module>   s   
\








Yy

	/

		 8
)



,H 
C]


*)	
7.PK       ! 2FT  T  +  distlib/__pycache__/database.cpython-38.pycnu [        U

    .eU                     @   s  d Z ddlmZ ddlZddlZddlZddlZddlZddlZddl	Z	ddl
Z
ddlZddlm
Z
mZ ddlmZ ddlmZmZ ddlmZmZmZmZ dd	lmZmZmZmZmZmZm Z  d
ddd
dgZ!e"e#Z$dZ%dZ&deddde%dfZ'dZ(G dd de)Z*G dd de)Z+G dd
 d
e)Z,G dd de,Z-G dd de-Z.G dd
 d
e-Z/e.Z0e/Z1G dd de)Z2d)d!d"Z3d#d$ Z4d%d& Z5d'd( Z6dS )*zPEP 376 implementation.    )unicode_literalsN   )DistlibException	resources)StringIO)
get_schemeUnsupportedVersionError)MetadataMETADATA_FILENAMEWHEEL_METADATA_FILENAMELEGACY_METADATA_FILENAME)parse_requirementcached_propertyparse_name_and_versionread_exports
write_exports	CSVReader	CSVWriterDistributionBaseInstalledDistributionInstalledDistributionEggInfoDistributionDistributionPathzpydist-exports.jsonzpydist-commands.jsonZ	INSTALLERRECORD	REQUESTED	RESOURCESSHAREDz
.dist-infoc                   @   s(   e Zd ZdZdd Zdd Zdd ZdS )	_CachezL
    A simple cache mapping names and .dist-info paths to distributions
    c                 C   s   i | _ i | _d| _dS )zZ
        Initialise an instance. There is normally one for each DistributionPath.
        FN)namepath	generatedself r#   @/usr/lib/python3.8/site-packages/pip/_vendor/distlib/database.py__init__1   s    z_Cache.__init__c                 C   s   | j   | j  d| _dS )zC
        Clear the cache, setting it to its initial state.
        FN)r   clearr   r    r!   r#   r#   r$   r&   9   s    

z_Cache.clearc                 C   s2   |j | j kr.|| j |j < | j|jg | dS )z`
        Add a distribution to the cache.
        :param dist: The distribution to add.
        N)r   r   
setdefaultkeyappendr"   distr#   r#   r$   addA   s    z
_Cache.addN)__name__
__module____qualname____doc__r%   r&   r,   r#   r#   r#   r$   r   -   s   r   c                   @   s   e Zd ZdZdddZdd Zdd	 ZeeeZd
d Z	dd
 Z
dd Zedd Z
dd Zdd ZdddZdd ZdddZdS )r   zU
    Represents a set of distributions installed on a path (typically sys.path).
    NFc                 C   sD   |dkrt j}|| _d| _|| _t | _t | _d| _td| _	dS )a  
        Create an instance from a path, optionally including legacy (distutils/
        setuptools/distribute) distributions.
        :param path: The path to use, as a list of directories. If not specified,
                     sys.path is used.
        :param include_egg: If True, this instance will look for and return legacy
                            distributions as well as those based on PEP 376.
        NTdefault)
sysr   
_include_dist_include_eggr   _cache
_cache_egg_cache_enabledr   _scheme)r"   r   Zinclude_eggr#   r#   r$   r%   O   s    	zDistributionPath.__init__c                 C   s   | j S Nr7   r!   r#   r#   r$   _get_cache_enabledc   s    z#DistributionPath._get_cache_enabledc                 C   s
   || _ d S r9   r:   )r"   valuer#   r#   r$   _set_cache_enabledf   s    z#DistributionPath._set_cache_enabledc                 C   s   | j   | j  dS )z,
        Clears the internal cache.
        N)r5   r&   r6   r!   r#   r#   r$   clear_cachek   s    
zDistributionPath.clear_cachec           
      c   sD  t  }| jD ]0}t|}|dkr&q|d}|r|js<qt|j}|D ]}||}|rJ|j|krhqJ| jr|t	rt
ttg}|D ]"}t
||}	||	}
|
r qqqJt|
 }t|dd}W 5 Q R X td|j ||j t|j|| dV  qJ| jrJ|drJtd|j ||j t|j| V  qJqdS )zD
        Yield .dist-info and/or .egg(-info) distributions.
        N legacyfileobjschemezFound %s)metadataenv)	.egg-info.egg)setr   r   finder_for_pathfindZis_containersortedr3   endswithDISTINFO_EXTr
   r   r   	posixpathjoin
contextlibclosing	as_streamr	   loggerdebugr,   new_dist_classr4   old_dist_class)
r"   seenr   finderrZrsetentryZpossible_filenamesZmetadata_filenameZ
metadata_pathZpydiststreamrD   r#   r#   r$   _yield_distributionss   sF    






z%DistributionPath._yield_distributionsc                 C   sp   | j j }| jo| jj }|s"|rl|  D ](}t|trF| j | q*| j| q*|r`d| j _|rld| j_dS )zk
        Scan the path for distributions and populate the cache with
        those that are found.
        TN)r5   r    r4   r6   r\   
isinstancer   r,   )r"   Zgen_distZgen_eggr+   r#   r#   r$   _generate_cache   s    

z DistributionPath._generate_cachec                 C   s   | dd}d||gt S )ao  
        The *name* and *version* parameters are converted into their
        filename-escaped form, i.e. any ``'-'`` characters are replaced
        with ``'_'`` other than the one in ``'dist-info'`` and the one
        separating the name from the version number.

        :parameter name: is converted to a standard distribution name by replacing
                         any runs of non- alphanumeric characters with a single
                         ``'-'``.
        :type name: string
        :parameter version: is converted to a standard version string. Spaces
                            become dots, and all other non-alphanumeric characters
                            (except dots) become dashes, with runs of multiple
                            dashes condensed to a single dash.
        :type version: string
        :returns: directory name
        :rtype: string-_)replacerO   rM   )clsr   versionr#   r#   r$   distinfo_dirname   s    z!DistributionPath.distinfo_dirnamec                 c   s^   | j s|  D ]
}|V  qn>|   | jj D ]
}|V  q0| jrZ| jj D ]
}|V  qNdS )a5  
        Provides an iterator that looks for distributions and returns
        :class:`InstalledDistribution` or
        :class:`EggInfoDistribution` instances for each one of them.

        :rtype: iterator of :class:`InstalledDistribution` and
                :class:`EggInfoDistribution` instances
        N)r7   r\   r^   r5   r   valuesr4   r6   r*   r#   r#   r$   get_distributions   s    	
z"DistributionPath.get_distributionsc                 C   s   d}|  }| js4|  D ]}|j|kr|} q|qnH|   || jjkrZ| jj| d }n"| jr||| jjkr|| jj| d }|S )a=  
        Looks for a named distribution on the path.

        This function only returns the first result found, as no more than one
        value is expected. If nothing is found, ``None`` is returned.

        :rtype: :class:`InstalledDistribution`, :class:`EggInfoDistribution`
                or ``None``
        Nr   )	lowerr7   r\   r(   r^   r5   r   r4   r6   )r"   r   resultr+   r#   r#   r$   get_distribution   s    

z!DistributionPath.get_distributionc           	      c   s   d}|dk	rJz| j d||f }W n$ tk
rH   td||f Y nX |  D ]p}t|dsntd| qR|j}|D ]H}t	|\}}|dkr||kr|V   qRqx||krx|
|rx|V   qRqxqRdS )a  
        Iterates over all distributions to find which distributions provide *name*.
        If a *version* is provided, it will be used to filter the results.

        This function only returns the first result found, since no more than
        one values are expected. If the directory is not found, returns ``None``.

        :parameter version: a version specifier that indicates the version
                            required, conforming to the format in ``PEP-345``

        :type name: string
        :type version: string
        N%s (%s)zinvalid name or version: %r, %rprovideszNo "provides": %s)r8   matcher
ValueErrorr   rf   hasattrrS   rT   rk   r   match)	r"   r   rc   rl   r+   providedpp_namep_verr#   r#   r$   provides_distribution   s*    
z&DistributionPath.provides_distributionc                 C   s(   |  |}|dkrtd| ||S )z5
        Return the path to a resource file.
        Nzno distribution named %r found)ri   LookupErrorget_resource_path)r"   r   
relative_pathr+   r#   r#   r$   
get_file_path!  s    
zDistributionPath.get_file_pathc                 c   sX   |   D ]J}|j}||kr|| }|dk	r>||krR|| V  q| D ]
}|V  qFqdS )z
        Return all of the exported entries in a particular category.

        :param category: The category to search for entries.
        :param name: If specified, only entries with that name are returned.
        N)rf   exportsre   )r"   categoryr   r+   rY   dvr#   r#   r$   get_exported_entries*  s    z%DistributionPath.get_exported_entries)NF)N)N)r-   r.   r/   r0   r%   r;   r=   propertyZ
cache_enabledr>   r\   r^   classmethodrd   rf   ri   rt   rx   r}   r#   r#   r#   r$   r   K   s   

,

)	c                   @   s   e Zd ZdZdZdZdd Zedd ZeZ	edd Z
ed	d
 Zdd Zed
d Z
edd Zedd Zedd Zedd Zdd Zdd Zdd Zdd ZdS ) r   z
    A base class for distributions, whether installed or from indexes.
    Either way, it must have some metadata, so that's all that's needed
    for construction.
    Fc                 C   sL   || _ |j| _| j | _|j| _d| _d| _d| _d| _t	 | _
i | _dS )z
        Initialise an instance.
        :param metadata: The instance of :class:`Metadata` describing this
        distribution.
        N)rD   r   rg   r(   rc   ZlocatordigestextrascontextrH   Z
download_urlsZdigests)r"   rD   r#   r#   r$   r%   O  s    zDistribution.__init__c                 C   s   | j jS )zH
        The source archive download URL for this distribution.
        )rD   
source_urlr!   r#   r#   r$   r   `  s    zDistribution.source_urlc                 C   s   d| j | jf S )zX
        A utility property which displays the name and version in parentheses.
        rj   r   rc   r!   r#   r#   r$   name_and_versioni  s    zDistribution.name_and_versionc                 C   s.   | j j}d| j| jf }||kr*|| |S )z
        A set of distribution names and versions provided by this distribution.
        :return: A set of "name (version)" strings.
        rj   )rD   rk   r   rc   r)   )r"   Zplistsr#   r#   r$   rk   p  s
    
zDistribution.providesc                 C   s8   | j }td|  t||}t|j|| j| jdS )Nz%Getting requirements from metadata %r)r   rE   )	rD   rS   rT   ZtodictgetattrrH   Zget_requirementsr   r   )r"   Zreq_attrmdZreqtsr#   r#   r$   _get_requirements|  s    
zDistribution._get_requirementsc                 C   s
   |  dS )Nrun_requiresr   r!   r#   r#   r$   r     s    zDistribution.run_requiresc                 C   s
   |  dS )N
meta_requiresr   r!   r#   r#   r$   r     s    zDistribution.meta_requiresc                 C   s
   |  dS )Nbuild_requiresr   r!   r#   r#   r$   r     s    zDistribution.build_requiresc                 C   s
   |  dS )N
test_requiresr   r!   r#   r#   r$   r     s    zDistribution.test_requiresc                 C   s
   |  dS )Ndev_requiresr   r!   r#   r#   r$   r     s    zDistribution.dev_requiresc           
   	   C   s   t |}t| jj}z||j}W n6 tk
rZ   td| |	 d }||}Y nX |j
}d}| jD ]D}t|\}}	||krqlz|
|	}W  qW ql tk
r   Y qlX ql|S )z
        Say if this instance matches (fulfills) a requirement.
        :param req: The requirement to match.
        :rtype req: str
        :return: True if it matches, else False.
        +could not read version %r - using name onlyr   F)r
   r   rD   rC   rl   requirementr   rS   warningsplitr(   rk   r   ro   )
r"   reqrY   rC   rl   r   rh   rq   rr   rs   r#   r#   r$   matches_requirement  s,    	


z Distribution.matches_requirementc                 C   s(   | j rd| j  }nd}d| j| j|f S )zC
        Return a textual representation of this instance,
        z [%s]r?   z<Distribution %s (%s)%s>)r   r   rc   )r"   suffixr#   r#   r$   __repr__  s    zDistribution.__repr__c                 C   s>   t |t | k	rd}n$| j|jko8| j|jko8| j|jk}|S )a<  
        See if this distribution is the same as another.
        :param other: The distribution to compare with. To be equal to one
                      another. distributions must have the same type, name,
                      version and source_url.
        :return: True if it is the same, else False.
        F)typer   rc   r   )r"   otherrh   r#   r#   r$   __eq__  s    

zDistribution.__eq__c                 C   s   t | jt | j t | j S )zH
        Compute hash in a way which matches the equality test.
        )hashr   rc   r   r!   r#   r#   r$   __hash__  s    zDistribution.__hash__N)r-   r.   r/   r0   Zbuild_time_dependency	requestedr%   r~   r   Zdownload_urlr   rk   r   r   r   r   r   r   r   r   r   r   r#   r#   r#   r$   r   =  s4   







"
c                       s0   e Zd ZdZdZd fdd	ZdddZ  ZS )	r   z]
    This is the base class for installed distributions (whether PEP 376 or
    legacy).
    Nc                    s    t t| | || _|| _dS )a  
        Initialise an instance.
        :param metadata: An instance of :class:`Metadata` which describes the
                         distribution. This will normally have been initialised
                         from a metadata file in the ``path``.
        :param path:     The path of the ``.dist-info`` or ``.egg-info``
                         directory for the distribution.
        :param env:      This is normally the :class:`DistributionPath`
                         instance where this distribution was found.
        N)superr   r%   r   	dist_path)r"   rD   r   rE   	__class__r#   r$   r%     s    z"BaseInstalledDistribution.__init__c                 C   sd   |dkr| j }|dkr"tj}d}ntt|}d| j  }|| }t|dd}d||f S )a  
        Get the hash of some data, using a particular hash algorithm, if
        specified.

        :param data: The data to be hashed.
        :type data: bytes
        :param hasher: The name of a hash implementation, supported by hashlib,
                       or ``None``. Examples of valid values are ``'sha1'``,
                       ``'sha224'``, ``'sha384'``, '``sha256'``, ``'md5'`` and
                       ``'sha512'``. If no hasher is specified, the ``hasher``
                       attribute of the :class:`InstalledDistribution` instance
                       is used. If the hasher is determined to be ``None``, MD5
                       is used as the hashing algorithm.
        :returns: The hash of the data. If a hasher was explicitly specified,
                  the returned hash will be prefixed with the specified hasher
                  followed by '='.
        :rtype: str
        Nr?   z%s=   =ascii%s%s)	hasherhashlibmd5r   r   base64Zurlsafe_b64encoderstripdecode)r"   datar   prefixr   r#   r#   r$   get_hash  s    

z"BaseInstalledDistribution.get_hash)N)N)r-   r.   r/   r0   r   r%   r   
__classcell__r#   r#   r   r$   r     s   c                       s   e Zd ZdZdZd' fdd	Zdd Zdd	 Zd
d Ze	dd
 Z
dd Zdd Zdd Z
dd Zd(ddZdd Ze	dd Zd)ddZdd  Zd!d" Zd#d$ Zd%d& ZejZ  ZS )*r   a  
    Created with the *path* of the ``.dist-info`` directory provided to the
    constructor. It reads the metadata contained in ``pydist.json`` when it is
    instantiated., or uses a passed in Metadata instance (useful for when
    dry-run mode is being used).
    Zsha256Nc           
   	      sJ  g | _ t| | _}|d kr*td| |rP|jrP||jjkrP|jj| j}nt|d kr|	t
}|d krt|	t}|d kr|	d}|d krtdt
|f t
| }t|dd}W 5 Q R X tt| ||| |r|jr|j|  |	d}|d k	| _tj|d}tj|rFt|d}| }	W 5 Q R X |	 | _ d S )	Nzfinder unavailable for %sZMETADATAzno %s found in %sr@   rA   r   
top_level.txtrb)modulesr   rI   rX   rm   r7   r5   r   rD   rJ   r
   r   rP   rQ   rR   r	   r   r   r%   r,   r   osrO   existsopenread
splitlines)
r"   r   rD   rE   rX   rY   r[   rq   fr   r   r#   r$   r%     s8    





zInstalledDistribution.__init__c                 C   s   d| j | j| jf S )Nz#<InstalledDistribution %r %s at %r>r   rc   r   r!   r#   r#   r$   r   =  s
      zInstalledDistribution.__repr__c                 C   s   d| j | jf S Nz%s %sr   r!   r#   r#   r$   __str__A  s    zInstalledDistribution.__str__c           
   
   C   s   g }|  d}t| \}t|dF}|D ]:}dd tt|dD }|| \}}}	||||	f q.W 5 Q R X W 5 Q R X |S )a"  
        Get the list of installed files for the distribution
        :return: A list of tuples of path, hash and size. Note that hash and
                 size might be ``None`` for some entries. The path is exactly
                 as stored in the file (which is as in PEP 376).
        r   r[   c                 S   s   g | ]}d qS r9   r#   ).0ir#   r#   r$   
<listcomp>S  s     z6InstalledDistribution._get_records.<locals>.<listcomp>   )get_distinfo_resourcerP   rQ   rR   r   rangelenr)   )
r"   resultsrY   r[   Z
record_readerrowmissingr   checksumsizer#   r#   r$   _get_recordsD  s    
&z"InstalledDistribution._get_recordsc                 C   s   i }|  t}|r|  }|S )a  
        Return the information exported by this distribution.
        :return: A dictionary of exports, mapping an export category to a dict
                 of :class:`ExportEntry` instances describing the individual
                 export entries, and keyed by name.
        )r   EXPORTS_FILENAMEr   )r"   rh   rY   r#   r#   r$   ry   [  s
    
zInstalledDistribution.exportsc              	   C   s8   i }|  t}|r4t| }t|}W 5 Q R X |S )z
        Read exports data from a file in .ini format.

        :return: A dictionary of exports, mapping an export category to a list
                 of :class:`ExportEntry` instances describing the individual
                 export entries.
        )r   r   rP   rQ   rR   r   )r"   rh   rY   r[   r#   r#   r$   r   i  s    
z"InstalledDistribution.read_exportsc              	   C   s.   |  t}t|d}t|| W 5 Q R X dS )a  
        Write a dictionary of exports to a file in .ini format.
        :param exports: A dictionary of exports, mapping an export category to
                        a list of :class:`ExportEntry` instances describing the
                        individual export entries.
        wN)get_distinfo_filer   r   r   )r"   ry   Zrfr   r#   r#   r$   r   x  s    
z#InstalledDistribution.write_exportsc                 C   s   |  d}t| R}t|d<}|D ]0\}}||kr*|  W  5 Q R  W  5 Q R  S q*W 5 Q R X W 5 Q R X td| dS )aW  
        NOTE: This API may change in the future.

        Return the absolute path to a resource file with the given relative
        path.

        :param relative_path: The path, relative to .dist-info, of the resource
                              of interest.
        :return: The absolute path where the resource is to be found.
        r   r   z3no resource file with relative path %r is installedN)r   rP   rQ   rR   r   KeyError)r"   rw   rY   r[   Zresources_readerrelativeZdestinationr#   r#   r$   rv     s    
6z'InstalledDistribution.get_resource_pathc                 c   s   |   D ]
}|V  qdS )z
        Iterates over the ``RECORD`` entries and returns a tuple
        ``(path, hash, size)`` for each line.

        :returns: iterator of (path, hash, size)
        N)r   )r"   rh   r#   r#   r$   list_installed_files  s    z*InstalledDistribution.list_installed_filesFc                 C   s(  t j|d}t j| j}||}t j|d}| d}td| |rRdS t|}|D ]}t j	|sz|
drd }	}
n4dt j| }
t|d}| 
| }	W 5 Q R X ||s|r||rt j||}|||	|
f q`||r
t j||}||ddf W 5 Q R X |S )z
        Writes the ``RECORD`` file, using the ``paths`` iterable passed in. Any
        existing ``RECORD`` file is silently overwritten.

        prefix is used to determine when to write absolute paths.
        r?   r   creating %sNz.pycz.pyoz%dr   )r   r   rO   dirname
startswithr   rS   infor   isdirrL   getsizer   r   r   relpathZwriterow)r"   pathsr   dry_runbaseZbase_under_prefixrecord_pathwriterr   
hash_valuer   fpr#   r#   r$   write_installed_files  s0    



z+InstalledDistribution.write_installed_filesc              
   C   s  g }t j| j}| d}|  D ]\}}}t j|sHt j||}||krRq$t j|sr||dddf q$t j	|r$t
t j|}|r||kr||d||f q$|r$d|kr|ddd }nd	}t
|d
2}	| |	 |}
|
|kr||d||
f W 5 Q R X q$|S )  
        Checks that the hashes and sizes of the files in ``RECORD`` are
        matched by the files themselves. Returns a (possibly empty) list of
        mismatches. Each entry in the mismatch list will be a tuple consisting
        of the path, 'exists', 'size' or 'hash' according to what didn't match
        (existence is checked first, then size, then hash), the expected
        value and the actual value.
        r   r   TFr   =r   r   Nr   r   )r   r   r   r   r   isabsrO   r   r)   isfilestrr   r   r   r   r   )r"   
mismatchesr   r   r   r   r   Zactual_sizer   r   Zactual_hashr#   r#   r$   check_installed_files  s.    	

z+InstalledDistribution.check_installed_filesc              	   C   s   i }t j| jd}t j|rtj|ddd}|  }W 5 Q R X |D ]8}|dd\}}|dkr||	|g 
| qL|||< qL|S )a  
        A dictionary of shared locations whose keys are in the set 'prefix',
        'purelib', 'platlib', 'scripts', 'headers', 'data' and 'namespace'.
        The corresponding value is the absolute path of that category for
        this distribution, and takes into account any paths selected by the
        user at installation time (e.g. via command-line arguments). In the
        case of the 'namespace' key, this would be a list of absolute paths
        for the roots of namespace packages in this distribution.

        The first time this property is accessed, the relevant information is
        read from the SHARED file in the .dist-info directory.
        r   rY   utf-8encodingr   r   	namespace)r   r   rO   r   codecsr   r   r   r   r'   r)   )r"   rh   shared_pathr   linesliner(   r<   r#   r#   r$   shared_locations  s    
z&InstalledDistribution.shared_locationsc           	   	   C   s   t j| jd}td| |r$dS g }dD ].}|| }t j|| r,|d||f  q,|ddD ]}|d|  qhtj	|d	d
d}|
d| W 5 Q R X |S )
aa  
        Write shared location information to the SHARED file in .dist-info.
        :param paths: A dictionary as described in the documentation for
        :meth:`shared_locations`.
        :param dry_run: If True, the action is logged but no file is actually
                        written.
        :return: The path of the file written to.
        r   r   N)r   libZheadersZscriptsr   z%s=%sr   r#   znamespace=%sr   r   r   
)r   r   rO   rS   r   r   r)   getr   r   write)	r"   r   r   r   r   r(   r   nsr   r#   r#   r$   write_shared_locations  s    	z,InstalledDistribution.write_shared_locationsc                 C   sF   |t krtd|| jf t| j}|d kr<td| j ||S )N+invalid path for a dist-info file: %r at %rzUnable to get a finder for %s)
DIST_FILESr   r   r   rI   rJ   )r"   r   rX   r#   r#   r$   r     s    z+InstalledDistribution.get_distinfo_resourcec                 C   s~   | tjdkrT|tjdd \}}|| jtjd krTtd|| j| jf |tkrntd|| jf tj	| j|S )a  
        Returns a path located under the ``.dist-info`` directory. Returns a
        string representing the path.

        :parameter path: a ``'/'``-separated path relative to the
                         ``.dist-info`` directory or an absolute path;
                         If *path* is an absolute path and doesn't start
                         with the ``.dist-info`` directory path,
                         a :class:`DistlibException` is raised
        :type path: str
        :rtype: str
        r   Nz;dist-info file %r does not belong to the %r %s distributionr   )
rJ   r   sepr   r   r   r   rc   r   rO   )r"   r   rd   r#   r#   r$   r   $  s    z'InstalledDistribution.get_distinfo_filec                 c   sR   t j| j}|  D ]6\}}}t j|s:t j||}|| jr|V  qdS )z
        Iterates over the ``RECORD`` entries and returns paths for each line if
        the path is pointing to a file located in the ``.dist-info`` directory
        or one of its subdirectories.

        :returns: iterator of paths
        N)r   r   r   r   r   rO   r   )r"   r   r   r   r   r#   r#   r$   list_distinfo_filesA  s    z)InstalledDistribution.list_distinfo_filesc                 C   s   t |to| j|jkS r9   )r]   r   r   r"   r   r#   r#   r$   r   Q  s    

zInstalledDistribution.__eq__)NN)F)F)r-   r.   r/   r0   r   r%   r   r   r   r   ry   r   r   rv   r   r   r   r   r   r   r   r   r   objectr   r   r#   r#   r   r$   r     s,   "



##

	c                       sj   e Zd ZdZdZi Zd fdd	Zdd Zdd	 Zd
d Z	dd
 Z
dd ZdddZdd Z
ejZ  ZS )r   a  Created with the *path* of the ``.egg-info`` directory or file provided
    to the constructor. It reads the metadata contained in the file itself, or
    if the given path happens to be a directory, the metadata is read from the
    file ``PKG-INFO`` under that directory.TNc                    s   dd }|| _ || _|rJ|jrJ||jj krJ|jj | j}|| |j|j n0| |}|| |j|j |rz|jrz|j|  t	t
| ||| d S )Nc                 S   s   || _ | | _|| _d S r9   )r   rg   r(   rc   )r   nr|   r#   r#   r$   set_name_and_versionc  s    
z:EggInfoDistribution.__init__.<locals>.set_name_and_version)r   r   r7   r6   rD   r   rc   
_get_metadatar,   r   r   r%   )r"   r   rE   r   rD   r   r#   r$   r%   b  s    

zEggInfoDistribution.__init__c              	      s  d }dd   fdd}d  }}| drtj|rtj|d}tj|d}t|dd	}tj|d
}	tj|d}||	}npt|}
t|
	d
d
}t|dd}z,|
	d}|
	d
d} |
d}W n tk
r   d }Y nX nf| drPtj|rBtj|d
}	||	}tj|d}tj|d}t|dd	}ntd| |rl|
| |d kr|d k	rtj|rt|d}
|
 
d}W 5 Q R X |sg }n| }|| _|S )Nc                 S   s   g }|   }|D ]}| }|dr6td|  qt|}|sPtd| q|jr`td |jst||j	 qd
dd |jD }|d|j	|f  q|S )	zCreate a list of dependencies from a requires.txt file.

            *data*: the contents of a setuptools-produced requires.txt file.
            [z.Unexpected line: quitting requirement scan: %rz#Not recognised as a requirement: %rz4extra requirements in requires.txt are not supportedz, c                 s   s   | ]}d | V  qdS )r   Nr#   )r   cr#   r#   r$   	<genexpr>  s     zQEggInfoDistribution._get_metadata.<locals>.parse_requires_data.<locals>.<genexpr>rj   )r   stripr   rS   r   r
   r   Zconstraintsr)   r   rO   )r   reqsr   r   rY   Zconsr#   r#   r$   parse_requires_dataz  s(    

z>EggInfoDistribution._get_metadata.<locals>.parse_requires_datac              	      sH   g }z*t | dd} | }W 5 Q R X W n tk
rB   Y nX |S )zCreate a list of dependencies from a requires.txt file.

            *req_path*: the path to a setuptools-produced requires.txt file.
            rY   r   )r   r   r   IOError)req_pathr  r   r  r#   r$   parse_requires_path  s    z>EggInfoDistribution._get_metadata.<locals>.parse_requires_pathrG   zEGG-INFOzPKG-INFOr@   )r   rC   zrequires.txtr   zEGG-INFO/PKG-INFOutf8rA   zEGG-INFO/requires.txtzEGG-INFO/top_level.txtr   rF   z,path must end with .egg-info or .egg, got %rr   )rL   r   r   r   rO   r	   	zipimportzipimporterr   get_datar   r  r   Zadd_requirementsr   r   r   r   r   )r"   r   requiresr	  Ztl_pathZtl_datarq   	meta_pathrD   r  ZzipfrB   r   r   r#   r  r$   r   w  sX    





z!EggInfoDistribution._get_metadatac                 C   s   d| j | j| jf S )Nz!<EggInfoDistribution %r %s at %r>r   r!   r#   r#   r$   r     s
      zEggInfoDistribution.__repr__c                 C   s   d| j | jf S r   r   r!   r#   r#   r$   r     s    zEggInfoDistribution.__str__c                 C   s`   g }t j| jd}t j|r\|  D ]2\}}}||kr<q(t j|s(||dddf q(|S )r   installed-files.txtr   TF)r   r   rO   r   r   r)   )r"   r   r   r   r`   r#   r#   r$   r     s    	z)EggInfoDistribution.check_installed_filesc              	   C   s   dd }dd }t j| jd}g }t j|rtj|dddx}|D ]l}| }t jt j| j|}t j|st	d	| |
d
rqFt j|sF||||||f qFW 5 Q R X ||ddf |S )z
        Iterates over the ``installed-files.txt`` entries and returns a tuple
        ``(path, hash, size)`` for each line.

        :returns: a list of (path, hash, size)
        c                 S   s0   t | d}z| }W 5 |  X t| S )Nr   )r   closer   r   r   Z	hexdigest)r   r   Zcontentr#   r#   r$   _md5  s
    

z6EggInfoDistribution.list_installed_files.<locals>._md5c                 S   s   t | jS r9   )r   statst_size)r   r#   r#   r$   _size  s    z7EggInfoDistribution.list_installed_files.<locals>._sizer  rY   r   r   zNon-existent file: %sr   N)
r   r   rO   r   r   r   r  normpathrS   r   rL   r   r)   )r"   r  r  r   rh   r   r   rq   r#   r#   r$   r     s"    
$z(EggInfoDistribution.list_installed_filesFc              	   c   s   t j| jd}t j|rd}tj|ddd`}|D ]T}| }|dkrPd}q6|s6t jt j| j|}|| jr6|r|V  q6|V  q6W 5 Q R X dS )	a  
        Iterates over the ``installed-files.txt`` entries and returns paths for
        each line if the path is pointing to a file located in the
        ``.egg-info`` directory or one of its subdirectories.

        :parameter absolute: If *absolute* is ``True``, each returned path is
                          transformed into a local absolute path. Otherwise the
                          raw value from ``installed-files.txt`` is returned.
        :type absolute: boolean
        :returns: iterator of paths
        r  TrY   r   r   z./FN)	r   r   rO   r   r   r   r  r  r   )r"   Zabsoluter   skipr   r   rq   r#   r#   r$   r     s    z'EggInfoDistribution.list_distinfo_filesc                 C   s   t |to| j|jkS r9   )r]   r   r   r   r#   r#   r$   r   .  s    

zEggInfoDistribution.__eq__)N)F)r-   r.   r/   r0   r   r   r%   r   r   r   r   r   r   r   r   r   r   r#   r#   r   r$   r   Y  s   Z&
c                   @   s^   e Zd ZdZdd Zdd ZdddZd	d
 Zdd ZdddZ	dddZ
dd Zdd ZdS )DependencyGrapha  
    Represents a dependency graph between distributions.

    The dependency relationships are stored in an ``adjacency_list`` that maps
    distributions to a list of ``(other, label)`` tuples where  ``other``
    is a distribution and the edge is labeled with ``label`` (i.e. the version
    specifier, if such was provided). Also, for more efficient traversal, for
    every distribution ``x``, a list of predecessors is kept in
    ``reverse_list[x]``. An edge from distribution ``a`` to
    distribution ``b`` means that ``a`` depends on ``b``. If any missing
    dependencies are found, they are stored in ``missing``, which is a
    dictionary that maps distributions to a list of requirements that were not
    provided by any other distributions.
    c                 C   s   i | _ i | _i | _d S r9   )adjacency_listreverse_listr   r!   r#   r#   r$   r%   I  s    zDependencyGraph.__init__c                 C   s   g | j |< g | j|< dS )zAdd the *distribution* to the graph.

        :type distribution: :class:`distutils2.database.InstalledDistribution`
                            or :class:`distutils2.database.EggInfoDistribution`
        N)r  r  )r"   distributionr#   r#   r$   add_distributionN  s    
z DependencyGraph.add_distributionNc                 C   s6   | j | ||f || j| kr2| j| | dS )a  Add an edge from distribution *x* to distribution *y* with the given
        *label*.

        :type x: :class:`distutils2.database.InstalledDistribution` or
                 :class:`distutils2.database.EggInfoDistribution`
        :type y: :class:`distutils2.database.InstalledDistribution` or
                 :class:`distutils2.database.EggInfoDistribution`
        :type label: ``str`` or ``None``
        N)r  r)   r  )r"   xylabelr#   r#   r$   add_edgeX  s    
zDependencyGraph.add_edgec                 C   s&   t d|| | j|g | dS )a  
        Add a missing *requirement* for the given *distribution*.

        :type distribution: :class:`distutils2.database.InstalledDistribution`
                            or :class:`distutils2.database.EggInfoDistribution`
        :type requirement: ``str``
        z
%s missing %rN)rS   rT   r   r'   r)   )r"   r  r   r#   r#   r$   add_missingg  s    zDependencyGraph.add_missingc                 C   s   d|j |jf S r   r   r*   r#   r#   r$   
_repr_distr  s    zDependencyGraph._repr_distr   c                 C   s   |  |g}| j| D ]h\}}|  |}|dk	r<d||f }|d| t|  | ||d }|d}||dd  qd|S )zPrints only a subgraphNz%s [%s]z    r   r   )r"  r  r)   r   	repr_noder   extendrO   )r"   r+   leveloutputr   r  Z	suboutputZsubsr#   r#   r$   r#  u  s    

zDependencyGraph.repr_nodeTc                 C   s   g }| d | j D ]h\}}t|dkr:|s:|| |D ]@\}}|dk	rh| d|j|j|f  q>| d|j|jf  q>q|st|dkr| d | d | d |D ]}| d	|j  | d
 q| d | d dS )a9  Writes a DOT output for the graph to the provided file *f*.

        If *skip_disconnected* is set to ``True``, then all distributions
        that are not dependent on any other distribution are skipped.

        :type f: has to support ``file``-like operations
        :type skip_disconnected: ``bool``
        zdigraph dependencies {
r   Nz"%s" -> "%s" [label="%s"]
z
"%s" -> "%s"
zsubgraph disconnected {
zlabel = "Disconnected"
zbgcolor = red
z"%s"r   z}
)r   r  itemsr   r)   r   )r"   r   Zskip_disconnectedZdisconnectedr+   adjsr   r  r#   r#   r$   to_dot  s(    	





zDependencyGraph.to_dotc                    s   g }i }| j  D ]\}}|dd ||< qg  t| dd D ]\}}|sD | ||= qD shq| D ]\}} fdd|D ||< qptddd  D  |  q,|t| fS )aa  
        Perform a topological sort of the graph.
        :return: A tuple, the first element of which is a topologically sorted
                 list of distributions, and the second element of which is a
                 list of distributions that cannot be sorted because they have
                 circular dependencies and so form a cycle.
        Nc                    s    g | ]\}}| kr||fqS r#   r#   )r   r{   rY   Z	to_remover#   r$   r     s      z4DependencyGraph.topological_sort.<locals>.<listcomp>zMoving to result: %sc                 S   s   g | ]}d |j |jf qS )rj   r   )r   r{   r#   r#   r$   r     s     )r  r'  listr)   rS   rT   r$  keys)r"   rh   Zalistkr|   r#   r*  r$   topological_sort  s$    
z DependencyGraph.topological_sortc                 C   s2   g }| j  D ]\}}|| | qd|S )zRepresentation of the graphr   )r  r'  r)   r#  rO   )r"   r&  r+   r(  r#   r#   r$   r     s    zDependencyGraph.__repr__)N)r   )T)
r-   r.   r/   r0   r%   r  r   r!  r"  r#  r)  r.  r   r#   r#   r#   r$   r  9  s   



 r  r1   c                 C   sV  t |}t }i }| D ]L}|| |jD ]6}t|\}}td||| ||g ||f q*q| D ]}|j	|j
B |jB |jB }|D ]}	z|
|	}
W n6 tk
r   td|	 |	 d }|
|}
Y nX |
j}d}||kr>|| D ]N\}}z|
|}
W n tk
r   d}
Y nX |
r||||	 d} q>q|s|||	 qqh|S )a6  Makes a dependency graph from the given distributions.

    :parameter dists: a list of distributions
    :type dists: list of :class:`distutils2.database.InstalledDistribution` and
                 :class:`distutils2.database.EggInfoDistribution` instances
    :rtype: a :class:`DependencyGraph` instance
    zAdd to provided: %s, %s, %sr   r   FT)r   r  r  rk   r   rS   rT   r'   r)   r   r   r   r   rl   r   r   r   r(   ro   r   r!  )distsrC   graphrp   r+   rq   r   rc   r  r   rl   ZmatchedZproviderro   r#   r#   r$   
make_graph  sN    




r1  c                 C   sv   || krt d|j t| }|g}|j| }|rh| }|| |j| D ]}||krN|| qNq.|d |S )zRecursively generate a list of distributions from *dists* that are
    dependent on *dist*.

    :param dists: a list of distributions
    :param dist: a distribution, member of *dists* for which we are interested
    1given distribution %r is not a member of the listr   )r   r   r1  r  popr)   )r/  r+   r0  Zdeptodor{   Zsuccr#   r#   r$   get_dependent_dists  s    


r5  c                 C   sn   || krt d|j t| }g }|j| }|rj| d }|| |j| D ]}||krP|| qPq,|S )zRecursively generate a list of distributions from *dists* that are
    required by *dist*.

    :param dists: a list of distributions
    :param dist: a distribution, member of *dists* for which we are interested
    r2  r   )r   r   r1  r  r3  r)   )r/  r+   r0  r   r4  r{   Zpredr#   r#   r$   get_required_dists  s    

r6  c                 K   s4   | dd}tf |}| |_||_|p(d|_t|S )zO
    A convenience method for making a dist given just a name and version.
    summaryzPlaceholder for summary)r3  r	   r   rc   r7  r   )r   rc   kwargsr7  r   r#   r#   r$   	make_dist2  s    

r9  )r1   )7r0   Z
__future__r   r   r   rP   r   Zloggingr   rN   r2   r  r?   r   r   compatr   rc   r   r   rD   r	   r
   r   r   utilr
   r   r   r   r   r   r   __all__Z	getLoggerr-   rS   r   ZCOMMANDS_FILENAMEr   rM   r   r   r   r   r   r   r   rU   rV   r  r1  r5  r6  r9  r#   r#   r#   r$   <module>   s`   $ 
   s 7  J ] 
6PK       ! wdg  g  +  distlib/__pycache__/metadata.cpython-38.pycnu [        U

    .e*                     @   s  d Z ddlmZ ddlZddlmZ ddlZddlZddlZddl	m
Z
mZ ddlm
Z
mZmZ ddlmZ dd	lmZmZ dd
lmZmZ eeZG dd de
ZG d
d de
ZG dd de
ZG dd de
ZdddgZdZ dZ!e"dZ#e"dZ$dZ%dZ&dZ'dZ(dZ)dZ*d Z+e*d! Z,d"Z-e. Z/e/0e% e/0e& e/0e( e/0e* e/0e, e"d#Z1d$d% Z2d&d' Z3d(d)d*d+d,d-d.d/d0d1d2d3d4d5d6d7d8d9d:d;d<d=d>d?d@dAdBdCdDdEdFZ4dGZ5dHZ6dIZ7dJZ8dKZ9dLZ:dMZ;e< Z=e"dNZ>dXdPdQZ?G dRdS dSe<Z@dTZAdUZBdVZCG dWd de<ZDdS )YzImplementation of the Metadata for Python packages PEPs.

Supports all metadata formats (1.0, 1.1, 1.2, and 2.0 experimental).
    )unicode_literalsN)message_from_file   )DistlibException__version__)StringIOstring_types	text_type)	interpret)extract_by_key
get_extras)
get_schemePEP440_VERSION_REc                   @   s   e Zd ZdZdS )MetadataMissingErrorzA required metadata is missingN__name__
__module____qualname____doc__ r   r   @/usr/lib/python3.8/site-packages/pip/_vendor/distlib/metadata.pyr      s   r   c                   @   s   e Zd ZdZdS )MetadataConflictErrorz>Attempt to read or write metadata fields that are conflictual.Nr   r   r   r   r   r       s   r   c                   @   s   e Zd ZdZdS ) MetadataUnrecognizedVersionErrorz Unknown metadata version number.Nr   r   r   r   r   r   $   s   r   c                   @   s   e Zd ZdZdS )MetadataInvalidErrorzA metadata value is invalidNr   r   r   r   r   r   (   s   r   MetadataPKG_INFO_ENCODINGPKG_INFO_PREFERRED_VERSIONutf-81.1z

       \|	
        )Metadata-VersionNameVersionPlatformSummaryDescriptionKeywords	Home-pageAuthorAuthor-emailLicense)r    r!   r"   r#   Supported-Platformr$   r%   r&   r'   r(   r)   r*   
ClassifierDownload-URL	ObsoletesProvidesRequires)r.   r/   r0   r,   r-   )r    r!   r"   r#   r+   r$   r%   r&   r'   r(   r)   
MaintainerMaintainer-emailr*   r,   r-   Obsoletes-DistProject-URL
Provides-Dist
Requires-DistRequires-PythonRequires-External)r5   r6   r7   r3   r8   r1   r2   r4   )r    r!   r"   r#   r+   r$   r%   r&   r'   r(   r)   r1   r2   r*   r,   r-   r3   r4   r5   r6   r7   r8   Private-VersionObsoleted-BySetup-Requires-Dist	ExtensionProvides-Extra)r9   r=   r:   r;   r<   )Description-Content-Typer0   r/   )r>   z"extra\s*==\s*("([^"]+)"|'([^']+)')c                 C   sL   | dkrt S | dkrtS | dkr$tS | dkr4tt S | dkr@tS t| d S )N1.0r   1.2)1.32.12.0)_241_FIELDS_314_FIELDS_345_FIELDS_566_FIELDS_426_FIELDSr   )versionr   r   r   _version2fieldlistp   s    rJ   c           
      C   sB  dd }g }|   D ]"\}}|g ddfkr,q|| qddddd	d
g}|D ]}|tkrvd|krv|d td| |tkrd|kr|d td| |tkrd|kr|d td
| |tkrd|kr|d td| |tkrd
|kr|dkr|d
 td| |t	krLd	|krL|d	 td| qLt
|dkrZ|d S t
|dkr|td|  tdd|ko||t}d|ko||t
}d
|ko||t}d	|ko||t}	t|t| t| t|	 dkrtd|s |s |s |	s t|kr tS |r*dS |r4dS |r>d
S d	S )z5Detect the best version depending on the fields used.c                 S   s   |D ]}|| kr dS qdS )NTFr   )keysmarkersmarkerr   r   r   _has_marker   s    z"_best_version.<locals>._has_markerUNKNOWNNr?   r   r@   rA   rC   rB   zRemoved 1.0 due to %szRemoved 1.1 due to %szRemoved 1.2 due to %szRemoved 1.3 due to %sr%   zRemoved 2.1 due to %szRemoved 2.0 due to %sr   r   z)Out of options - unknown metadata set: %szUnknown metadata setz,You used incompatible 1.1/1.2/2.0/2.1 fields)itemsappendrD   removeloggerdebugrE   rF   rG   rH   lenr   _314_MARKERS_345_MARKERS_566_MARKERS_426_MARKERSintr   )
fieldsrN   rK   keyvalueZpossible_versionsZis_1_1Zis_1_2Zis_2_1Zis_2_0r   r   r   
_best_version~   s`    






&
r^   r    r!   r"   r#   r+   r$   r%   r&   r'   r(   r)   r1   r2   r*   r,   r-   r3   r5   r6   r;   r7   r8   r0   r/   r.   r4   r9   r:   r<   r=   )metadata_versionnamerI   platformZsupported_platformsummarydescriptionkeywords	home_pageauthorauthor_email
maintainermaintainer_emaillicense
classifierdownload_urlobsoletes_dist
provides_dist
requires_distsetup_requires_distrequires_pythonrequires_externalrequiresprovides	obsoletesproject_urlZprivate_versionZobsoleted_by	extensionZprovides_extra)r6   r3   r5   )r7   )r"   )r#   r,   r.   r0   r/   r3   r5   r6   r8   r4   r+   r;   r=   r<   )r4   )r&   )r(   r1   r$   r%   z[^A-Za-z0-9.]+Fc                 C   s0   |r$t d| } t d|dd}d| |f S )zhReturn the distribution name with version.

    If for_filename is true, return a filename-escaped form.- .z%s-%s)	_FILESAFEsubreplace)r`   rI   Zfor_filenamer   r   r   _get_name_and_version   s    r~   c                   @   s
  e Zd ZdZd?ddZdd Zdd	 Zd
d Zdd
 Zdd Z	dd Z
dd Zdd Zdd Z
dd Zd@ddZdd Zdd  Zd!d" Zd#d$ ZdAd%d&ZdBd'd(ZdCd)d*Zd+d, Zefd-d.ZdDd/d0ZdEd1d2Zd3d4 Zd5d6 Zd7d8 Zd9d: Zd;d< Z d=d> Z!dS )FLegacyMetadataaa  The legacy metadata of a release.

    Supports versions 1.0, 1.1 and 1.2 (auto-detected). You can
    instantiate the class with one of these arguments (or none):
    - *path*, the path to a metadata file
    - *fileobj* give a file-like object with metadata as content
    - *mapping* is a dict-like object
    - *scheme* is a version scheme name
    Ndefaultc                 C   sz   |||g d dk rtdi | _g | _d | _|| _|d k	rH| | n.|d k	r\| | n|d k	rv| | | 	  d S )N   'path, fileobj and mapping are exclusive)
count	TypeError_fieldsZrequires_filesZ
_dependenciesschemeread	read_fileupdateset_metadata_version)selfpathfileobjmappingr   r   r   r   __init__  s    
zLegacyMetadata.__init__c                 C   s   t | j| jd< d S Nr    )r^   r   r   r   r   r   r   "  s    z#LegacyMetadata.set_metadata_versionc                 C   s   | d||f  d S )Nz%s: %s
)write)r   r   r`   r]   r   r   r   _write_field%  s    zLegacyMetadata._write_fieldc                 C   s
   |  |S N)getr   r`   r   r   r   __getitem__(  s    zLegacyMetadata.__getitem__c                 C   s   |  ||S r   )set)r   r`   r]   r   r   r   __setitem__+  s    zLegacyMetadata.__setitem__c                 C   s8   |  |}z| j|= W n tk
r2   t|Y nX d S r   )
_convert_namer   KeyError)r   r`   
field_namer   r   r   __delitem__.  s
    
zLegacyMetadata.__delitem__c                 C   s   || j kp| || j kS r   )r   r   r   r   r   r   __contains__5  s    
zLegacyMetadata.__contains__c                 C   s(   |t kr|S |dd }t||S )Nrx   _)_ALL_FIELDSr}   lower_ATTR2FIELDr   r   r   r   r   r   9  s    zLegacyMetadata._convert_namec                 C   s   |t ks|tkrg S dS )NrO   )_LISTFIELDS_ELEMENTSFIELDr   r   r   r   _default_value?  s    zLegacyMetadata._default_valuec                 C   s&   | j dkrtd|S td|S d S )Nr?   r   
)r_   _LINE_PREFIX_PRE_1_2r|   _LINE_PREFIX_1_2r   r]   r   r   r   _remove_line_prefixD  s    
z"LegacyMetadata._remove_line_prefixc                 C   s   |t kr| | S t|d S r   )r   AttributeErrorr   r   r   r   __getattr__J  s    zLegacyMetadata.__getattr__Fc                 C   s   t | d | d |S )zhReturn the distribution name with version.

        If filesafe is true, return a filename-escaped form.r!   r"   )r~   )r   Zfilesafer   r   r   get_fullnameU  s    zLegacyMetadata.get_fullnamec                 C   s   |  |}|tkS )z+return True if name is a valid metadata key)r   r   r   r   r   r   is_field[  s    
zLegacyMetadata.is_fieldc                 C   s   |  |}|tkS r   )r   r   r   r   r   r   is_multi_field`  s    
zLegacyMetadata.is_multi_fieldc                 C   s.   t j|ddd}z| | W 5 |  X dS )z*Read the metadata values from a file path.rr   encodingN)codecsopencloser   )r   filepathfpr   r   r   r   d  s    zLegacyMetadata.readc                 C   s   t |}|d | jd< tD ]p}||kr(q|tkrf||}|tkrX|dk	rXdd |D }| || q|| }|dk	r|dkr| || qdS )z,Read the metadata values from a file object.zmetadata-versionr    Nc                 S   s   g | ]}t |d qS ,)tuplesplit.0r]   r   r   r   
<listcomp>y  s     z,LegacyMetadata.read_file.<locals>.<listcomp>rO   )r   r   r   r   Zget_all_LISTTUPLEFIELDSr   )r   Zfileobmsgfieldvaluesr]   r   r   r   r   l  s    
zLegacyMetadata.read_filec                 C   s0   t j|ddd}z| || W 5 |  X dS )z&Write the metadata fields to filepath.wr   r   N)r   r   r   
write_file)r   r   skip_unknownr   r   r   r   r     s    zLegacyMetadata.writec                 C   s   |    t| d D ]}| |}|r8|dg dgfkr8q|tkrV| ||d| q|tkr|dkr| jdkr~|dd}n|dd}|g}|t	krd	d
 |D }|D ]}| ||| qqdS )z0Write the PKG-INFO format data to a file object.r    rO   r   r%   r   r   r   z	
       |c                 S   s   g | ]}d  |qS r   joinr   r   r   r   r     s     z-LegacyMetadata.write_file.<locals>.<listcomp>N)
r   rJ   r   r   r   r   r   r_   r}   r   )r   Z
fileobjectr   r   r   r]   r   r   r   r     s$    

zLegacyMetadata.write_filec                    sv    fdd}|sn@t |dr:| D ]}||||  q$n|D ]\}}||| q>|rr| D ]\}}||| q^dS )a  Set metadata values from the given iterable `other` and kwargs.

        Behavior is like `dict.update`: If `other` has a ``keys`` method,
        they are looped over and ``self[key]`` is assigned ``other[key]``.
        Else, ``other`` is an iterable of ``(key, value)`` iterables.

        Keys that don't match a metadata field or that have an empty value are
        dropped.
        c                    s"   | t kr|r  | | d S r   )r   r   r   )r\   r]   r   r   r   _set  s    z#LegacyMetadata.update.<locals>._setrK   N)hasattrrK   rP   )r   otherkwargsr   kvr   r   r   r     s    

zLegacyMetadata.updatec                 C   sh  |  |}|tks|dkrNt|ttfsNt|trHdd |dD }qzg }n,|tkrzt|ttfszt|trv|g}ng }t	t
jr<| d }t| j
}|tkr|dk	r|D ](}||dd std	||| qnb|tkr|dk	r||s<td
||| n0|tkr<|dk	r<||s<td
||| |tkrZ|dkrZ| |}|| j|< dS )z"Control then set a metadata field.r#   c                 S   s   g | ]}|  qS r   )strip)r   r   r   r   r   r     s     z&LegacyMetadata.set.<locals>.<listcomp>r   r!   N;r   z$'%s': '%s' is not valid (field '%s')z.'%s': '%s' is not a valid version (field '%s')r%   )r   r   
isinstancelistr   r   r   r   rS   ZisEnabledForloggingZWARNINGr
   r   _PREDICATE_FIELDSis_valid_matcherwarning_VERSIONS_FIELDSis_valid_constraint_list_VERSION_FIELDSis_valid_version_UNICODEFIELDSr   r   )r   r`   r]   Zproject_namer   r   r   r   r   r     sV    



      


zLegacyMetadata.setc                 C   s   |  |}|| jkr*|tkr&| |}|S |tkr@| j| }|S |tkr| j| }|dkr^g S g }|D ].}|tkr~|| qf||d |d f qf|S |tkr| j| }t	|t
r|dS | j| S )zGet a metadata field.Nr   r   r   )r   r   _MISSINGr   r   r   r   rQ   r   r   r   r   )r   r`   r   r]   resvalr   r   r   r     s.    







zLegacyMetadata.getc                    s   |    g g  }}dD ]}|| kr|| q|rP|g krPdd| }t|dD ]}|| krT|| qT| d dkr||fS t| j  fdd}t|ft jft	 j
ffD ]@\}}|D ]2}	| |	d	}
|
d	k	r||
s|d
|	|
f  qq||fS )zkCheck if the metadata is compliant. If strict is True then raise if
        no Name or Version are provided)r!   r"   zmissing required metadata: %s, )r'   r(   r    r@   c                    s(   | D ]}  |dd s dS qdS )Nr   r   FT)r   r   )r]   r   r   r   r   are_valid_constraints#  s    z3LegacyMetadata.check.<locals>.are_valid_constraintsNzWrong value for '%s': %s)r   rQ   r   r   r
   r   r   r   r   r   r   r   )r   strictmissingwarningsattrr   r   r[   Z
controllerr   r]   r   r   r   check	  s8    

zLegacyMetadata.checkc                 C   s   |    d}i }|D ]"\}}|r*|| jkr| | ||< q| d dkrd}|D ]B\}}|rb|| jkrL|dkrx| | ||< qLdd | | D ||< qLn8| d dkrd	}|D ]"\}}|r|| jkr| | ||< q|S )
zReturn fields as a dict.

        Field names will be converted to use the underscore-lowercase style
        instead of hyphen-mixed case (i.e. home_page instead of Home-page).
        )
)r_   r    )r`   r!   )rI   r"   )rb   r$   )re   r'   )rf   r(   )rg   r)   )rj   r*   )rc   r%   )rd   r&   )ra   r#   )classifiersr,   )rl   r-   r    r@   ))ro   r6   )rq   r7   )rr   r8   )rn   r5   )rm   r3   )rv   r4   )rh   r1   )ri   r2   rv   c                 S   s   g | ]}d  |qS r   r   )r   ur   r   r   r   b  s     z)LegacyMetadata.todict.<locals>.<listcomp>r   ))rt   r/   )rs   r0   )ru   r.   )r   r   )r   Zskip_missingZmapping_1_0datar\   r   Zmapping_1_2Zmapping_1_1r   r   r   todict5  s&    
zLegacyMetadata.todictc                 C   s8   | d dkr$dD ]}|| kr| |= q| d  |7  < d S )Nr    r   )r.   r0   r/   r6   r   )r   requirementsr   r   r   r   add_requirementsp  s
    zLegacyMetadata.add_requirementsc                 C   s   t t| d S r   )r   rJ   r   r   r   r   rK   {  s    zLegacyMetadata.keysc                 c   s   |   D ]
}|V  qd S r   rK   )r   r\   r   r   r   __iter__~  s    zLegacyMetadata.__iter__c                    s    fdd   D S )Nc                    s   g | ]} | qS r   r   r   r\   r   r   r   r     s     z)LegacyMetadata.values.<locals>.<listcomp>r   r   r   r   r   r     s    zLegacyMetadata.valuesc                    s    fdd   D S )Nc                    s   g | ]}| | fqS r   r   r   r   r   r   r     s     z(LegacyMetadata.items.<locals>.<listcomp>r   r   r   r   r   rP     s    zLegacyMetadata.itemsc                 C   s   d| j j| j| jf S )Nz
<%s %s %s>)	__class__r   r`   rI   r   r   r   r   __repr__  s    zLegacyMetadata.__repr__)NNNr   )F)F)F)N)F)F)"r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   rK   r   r   rP   r   r   r   r   r   r     s@     




,
,
;r   zpydist.jsonz
metadata.jsonZMETADATAc                   @   s  e Zd ZdZedZedejZe	Z
edZdZde
 Zdddd	Zd
ZdZedfedfe
dfedfdZd
ZdDddZedZdefZdefZdefdefeeedefeeeedefddd
Z[[dd ZdEddZdd Zed d! Z ed"d# Z!e!j"d$d# Z!dFd%d&Z#ed'd( Z$ed)d* Z%e%j"d+d* Z%d,d- Z&d.d/ Z'd0d1 Z(d2d3 Z)d4d5d6d7d8dd9Z*d:d; Z+dGd>d?Z,d@dA Z-dBdC Z.dS )Hr   z
    The metadata of a release. This implementation uses 2.0 (JSON)
    metadata where possible. If not possible, it wraps a LegacyMetadata
    instance which handles the key-value metadata format.
    z
^\d+(\.\d+)*$z!^[0-9A-Z]([0-9A-Z_.-]*[0-9A-Z])?$z	.{1,2047}rC   zdistlib (%s)r   )legacy)r`   rI   rb   zqname version license summary description author author_email keywords platform home_page classifiers download_urlzwextras run_requires test_requires build_requires dev_requires provides meta_requires obsoleted_by supports_environments)r_   r`   rI   rb   )_legacy_datar   Nr   c              	   C   s0  |||g d dk rtdd | _d | _|| _|d k	rzz| || || _W n* tk
rv   t||d| _|   Y nX nd }|rt	|d}|
 }W 5 Q R X n|r|
 }|d kr| j| jd| _ndt
|ts|d}zt|| _| | j| W n0 tk
r*   tt||d| _|   Y nX d S )Nr   r   )r   r   rbr_   	generatorr   )r   r   )r   r   r   r   r   _validate_mappingr   r   validater   r   METADATA_VERSION	GENERATORr   r	   decodejsonloads
ValueErrorr   )r   r   r   r   r   r   fr   r   r   r     s@    



zMetadata.__init__)r`   rI   rj   rd   rb   r6   r;   r=   r,   )r-   N)r    N)
run_requiresbuild_requiresdev_requiresZ
test_requires
meta_requiresextrasmodules
namespacesexportscommandsr   Z
source_urlr_   c           
      C   sX  t | d}t | d}||kr|| \}}| jr^|d krP|d krHd n| }n| j|}n|d krjd n| }|dkr| j||}nt  }|}| jd}	|	r
|dkr|	d|}nP|dkr|	d}	|	r|	||}n,|	d	}	|	s| jd	}	|	r
|	||}||krT|}n:||kr2t | |}n"| jrH| j|}n| j|}|S )
Ncommon_keysmapped_keysr	  r  r  r  r   
extensionsr	  python.commandsr   python.detailspython.exports)object__getattribute__r   r   r   )
r   r\   commonmappedlkZmakerresultr]   sentineldr   r   r   r     sD    




zMetadata.__getattribute__c                 C   sH   || j krD| j | \}}|p | j|krD||}|sDtd||f d S )Nz.'%s' is an invalid value for the '%s' property)SYNTAX_VALIDATORSr   matchr   )r   r\   r]   r   pattern
exclusionsmr   r   r   _validate_value+  s    

zMetadata._validate_valuec                 C   s*  |  || t| d}t| d}||kr|| \}}| jrV|d krJt|| j|< nf|dkrj|| j|< nR| jdi }|dkr||d< n2|dkr|di }|||< n|d	i }|||< nh||krt| || nP|d
krt|t	r|
 }|r| }ng }| jr|| j|< n
|| j|< d S )Nr
  r  r  r
  r	  r  r   r  r  rd   )r  r  r  r   NotImplementedErrorr   
setdefault__setattr__r   r   r   r   )r   r\   r]   r  r  r  r   r  r   r   r   r!  5  s<    




zMetadata.__setattr__c                 C   s   t | j| jdS NT)r~   r`   rI   r   r   r   r   name_and_version\  s    zMetadata.name_and_versionc                 C   sF   | j r| j d }n| jdg }d| j| jf }||krB|| |S )Nr5   rt   z%s (%s))r   r   r   r`   rI   rQ   )r   r  sr   r   r   rt   `  s    
zMetadata.providesc                 C   s    | j r|| j d< n
|| jd< d S )Nr5   rt   )r   r   r   r   r   r   rt   k  s    c           
      C   s   | j r|}ng }t|pg | j}|D ]d}d|kr>d|kr>d}n8d|krLd}n|d|k}|rv|d}|rvt||}|r$||d  q$dD ]F}d| }	|	|kr||	 | jd| g }|| j|||d q|S )	a  
        Base method to get dependencies, given a set of extras
        to satisfy and an optional environment context.
        :param reqts: A list of sometimes-wanted dependencies,
                      perhaps dependent on extras and environment.
        :param extras: A list of optional components being requested.
        :param env: An optional environment for marker evaluation.
        extraenvironmentTrs   )ZbuildZdevZtestz:%s:z%s_requires)r  env)	r   r   r  r   r
   extendrR   r   get_requirements)
r   reqtsr  r'  r  r  ZincluderM   r\   er   r   r   r)  r  s2    	



zMetadata.get_requirementsc                 C   s   | j r|  S | jS r   )r   _from_legacyr   r   r   r   r   
dictionary  s    zMetadata.dictionaryc                 C   s   | j rtnt| j| jS d S r   )r   r  r   r   DEPENDENCY_KEYSr   r   r   r   dependencies  s    zMetadata.dependenciesc                 C   s   | j rtn| j| d S r   )r   r  r   r   r   r   r   r   r/    s    c           	      C   s   | d| jkrt g }| j D ]"\}}||kr$||kr$|| q$|rbdd| }t|| D ]\}}| ||| qjd S )Nr_   zMissing metadata items: %sr   )	r   r   r   MANDATORY_KEYSrP   rQ   r   r   r  )	r   r   r   r   r\   r  r   r   r   r   r   r   r     s    zMetadata._validate_mappingc                 C   sB   | j r.| j d\}}|s|r>td|| n| | j| j d S )NTz#Metadata: missing: %s, warnings: %s)r   r   rS   r   r   r   r   )r   r   r   r   r   r   r     s     zMetadata.validatec                 C   s(   | j r| j dS t| j| j}|S d S r"  )r   r   r   r   
INDEX_KEYS)r   r  r   r   r   r     s    zMetadata.todictc           
      C   s   | j r| jrt| j| jd}| j d}dD ]*}||kr.|dkrHd}n|}|| ||< q.|dg }|dgkrtg }||d< d	}|D ]*\}}||kr|| rd
|| ig||< q| j|d< i }i }	|S )Nr   T)r`   rI   rj   rb   rc   rk   rk   r   r&    rd   ))ro   r  )rp   r  rs   rt   )r   r   AssertionErrorr   r   r   r   rt   )
r   r  Zlmdr   nkkwrK   okrf   rh   r   r   r   r,    s.    

zMetadata._from_legacyr!   r"   r*   r$   r%   )r`   rI   rj   rb   rc   r   c                 C   s   dd }| j r| jrtt }| j }| j D ]\}}||kr.|| ||< q.|| j| j }|| j| j	 }| j
rt| j
|d< t||d< t||d< |S )Nc                 S   s   t  }| D ]|}|d}|d}|d }|D ]V}|sF|sF|| q.d}|rVd| }|rp|rld||f }n|}|d||f q.q
|S )Nr%  r&  rs   r2  z
extra == "%s"z(%s) and %sr   )r   r   addr   )entriesr*  r+  r%  r'  Zrlistr   rM   r   r   r   process_entries  s"    

z,Metadata._to_legacy.<locals>.process_entriesr=   r6   r;   )r   r   r3  r   LEGACY_MAPPINGrP   r  r  r  r  r  sorted)r   r9  r  Znmdr4  r6  Zr1Zr2r   r   r   
_to_legacy  s    zMetadata._to_legacyFTc              	   C   s   ||g d dkrtd|   |r`| jr4| j}n|  }|rP|j||d q|j||d n^| jrp|  }n| j}|rt	j
||dddd n.t|dd}t	j
||dddd W 5 Q R X d S )	Nr   z)Exactly one of path and fileobj is needed)r   Tr   )Zensure_asciiindentZ	sort_keysr   r   )
r   r   r   r   r<  r   r   r,  r   r   dumpr   r   )r   r   r   r   r   Z	legacy_mdr  r   r   r   r   r     s*    
zMetadata.writec                 C   s   | j r| j | nr| jdg }d }|D ]}d|kr*d|kr*|} qHq*|d krfd|i}|d| n t|d t|B }t||d< d S )Nr  r&  r%  rs   r   )r   r   r   r   insertr   r;  )r   r   r  alwaysentryZrsetr   r   r   r   3  s    zMetadata.add_requirementsc                 C   s*   | j pd}| jpd}d| jj| j||f S )Nz	(no name)z
no versionz<%s %s %s (%s)>)r`   rI   r   r   r_   )r   r`   rI   r   r   r   r   D  s    

  zMetadata.__repr__)NNNr   )N)NN)NNFT)/r   r   r   r   recompileZMETADATA_VERSION_MATCHERIZNAME_MATCHERr   ZVERSION_MATCHERZSUMMARY_MATCHERr   r   r   r0  r1  r.  r  	__slots__r   r   r
  r   Z	none_listdictZ	none_dictr  r  r  r!  propertyr#  rt   setterr)  r-  r/  r   r   r   r,  r:  r<  r   r   r   r   r   r   r   r     s   

  
-+

'




*


		%
)F)Er   Z
__future__r   r   Zemailr   r   r   rB  r2  r   r   compatr   r   r	   rL   r
   utilr   r   rI   r
   r   Z	getLoggerr   rS   r   r   r   r   __all__r   r   rC  r   r   rD   rE   rV   rF   rW   rH   rY   rG   rX   r   r   r   ZEXTRA_RErJ   r^   r   r   r   r   r   r   r   r   r  r   r{   r~   r   ZMETADATA_FILENAMEZWHEEL_METADATA_FILENAMEZLEGACY_METADATA_FILENAMEr   r   r   r   r   <module>   s   










H!


   
PK       ! 
u:'  '  +  distlib/__pycache__/manifest.cpython-38.pycnu [        U

    .e9                     @   s   d Z ddlZddlZddlZddlZddlZddlmZ ddlm	Z	 ddl
mZ dgZe
eZedejZed	ejejB Zejdd
 ZG dd deZdS )zu
Class representing the list of files in a distribution.

Equivalent to distutils.filelist, but fixes some problems.
    N   )DistlibException)fsdecodeconvert_pathManifestz\\w*
z#.*?(?=
)|
(?=$)   c                   @   sz   e Zd ZdZdddZdd Zdd Zd	d
 Zddd
Zdd Z	dd Z
dd ZdddZd ddZ
d!ddZdd ZdS )"r   z~A list of files built by on exploring the filesystem and filtered by
    applying various patterns to what we find there.
    Nc                 C   s>   t jt j|pt  | _| jt j | _d| _t	 | _
dS )zd
        Initialise an instance.

        :param base: The base directory to explore under.
        N)ospathabspathnormpathgetcwdbasesepprefixallfilessetfiles)selfr    r   @/usr/lib/python3.8/site-packages/pip/_vendor/distlib/manifest.py__init__*   s    zManifest.__init__c                 C   s   ddl m}m}m} g  | _}| j}|g}|j}|j}|r| }t	|}	|	D ]R}
tj
||
}t |}|j}
||
r|t
| qN||
rN||
sN|| qNq6dS )zmFind all files under the base and set ``allfiles`` to the absolute
        pathnames of files found.
        r   )S_ISREGS_ISDIRS_ISLNKN)statr   r   r   r   r   popappendr	   listdirr
   joinst_moder   )r   r   r   r   r   rootstackr   pushnamesnamefullnamer   moder   r   r   findall9   s"    


zManifest.findallc                 C   s4   | | jstj| j|}| jtj| dS )zz
        Add a file to the manifest.

        :param item: The pathname to add. This can be relative to the base.
        N)	
startswithr   r	   r
   r   r   r   addr   )r   itemr   r   r   r*   T   s    zManifest.addc                 C   s   |D ]}|  | qdS )z
        Add a list of files to the manifest.

        :param items: The pathnames to add. These can be relative to the base.
        N)r* 