e all whitespace-delimited content between delimiters
    as a list of separate values.

    Use the C{ignoreExpr} argument to define expressions that may contain
    opening or closing characters that should not be treated as opening
    or closing characters for nesting, such as quotedString or a comment
    expression.  Specify multiple expressions using an C{L{Or}} or C{L{MatchFirst}}.
    The default is L{quotedString}, but if no expressions are to be ignored,
    then pass C{None} for this argument.

    Example::
        data_type = oneOf("void int short long char float double")
        decl_data_type = Combine(data_type + Optional(Word('*')))
        ident = Word(alphas+'_', alphanums+'_')
        number = pyparsing_common.number
        arg = Group(decl_data_type + ident)
        LPAR,RPAR = map(Suppress, "()")

        code_body = nestedExpr('{', '}', ignoreExpr=(quotedString | cStyleComment))

        c_function = (decl_data_type("type") 
                      + ident("name")
                      + LPAR + Optional(delimitedList(arg), [])("args") + RPAR 
                      + code_body("body"))
        c_function.ignore(cStyleComment)
        
        source_code = '''
            int is_odd(int x) { 
                return (x%2); 
            }
                
            int dec_to_hex(char hchar) { 
                if (hchar >= '0' && hchar <= '9') { 
                    return (ord(hchar)-ord('0')); 
                } else { 
                    return (10+ord(hchar)-ord('A'));
                } 
            }
        '''
        for func in c_function.searchString(source_code):
            print("%(name)s (%(type)s) args: %(args)s" % func)

    prints::
        is_odd (int) args: [['int', 'x']]
        dec_to_hex (int) args: [['char', 'hchar']]
    z.opening and closing strings cannot be the sameNrr   )r
  c             S   s   | d j  S )Nr   )r   )rv   rw   rw   rx   ry   9  s    znestedExpr.<locals>.<lambda>c             S   s   | d j  S )Nr   )r   )rv   rw   rw   rx   ry   <  s    c             S   s   | d j  S )Nr   )r   )rv   rw   rw   rx   ry   B  s    c             S   s   | d j  S )Nr   )r   )rv   rw   rw   rx   ry   F  s    zOopening and closing arguments must be strings if no content expression is givenznested %s%s expression)r  rz   r   r   r
   r   r	   r$   rN  r   rC   r   r   r   r   r+   r2   ri  )openerZcloserZcontentrO  r   rw   rw   rx   rP     s4    :

*$c                s    fdd} fdd} fdd}t t jdj }t t j| jd}t j|jd	}t j|jd
}	|rtt|| t |t|  t|  |	 }
n$tt|t |t|  t|  }
| j	t
t   |
jdS )a
	  
    Helper method for defining space-delimited indentation blocks, such as
    those used to define block statements in Python source code.

    Parameters:
     - blockStatementExpr - expression defining syntax of statement that
            is repeated within the indented block
     - indentStack - list created by caller to manage indentation stack
            (multiple statementWithIndentedBlock expressions within a single grammar
            should share a common indentStack)
     - indent - boolean indicating whether block must be indented beyond the
            the current level; set to False for block of left-most statements
            (default=C{True})

    A valid block must contain at least one C{blockStatement}.

    Example::
        data = '''
        def A(z):
          A1
          B = 100
          G = A2
          A2
          A3
        B
        def BB(a,b,c):
          BB1
          def BBA():
            bba1
            bba2
            bba3
        C
        D
        def spam(x,y):
             def eggs(z):
                 pass
        '''


        indentStack = [1]
        stmt = Forward()

        identifier = Word(alphas, alphanums)
        funcDecl = ("def" + identifier + Group( "(" + Optional( delimitedList(identifier) ) + ")" ) + ":")
        func_body = indentedBlock(stmt, indentStack)
        funcDef = Group( funcDecl + func_body )

        rvalue = Forward()
        funcCall = Group(identifier + "(" + Optional(delimitedList(rvalue)) + ")")
        rvalue << (funcCall | identifier | Word(nums))
        assignment = Group(identifier + "=" + rvalue)
        stmt << ( funcDef | assignment | identifier )

        module_body = OneOrMore(stmt)

        parseTree = module_body.parseString(data)
        parseTree.pprint()
    prints::
        [['def',
          'A',
          ['(', 'z', ')'],
          ':',
          [['A1'], [['B', '=', '100']], [['G', '=', 'A2']], ['A2'], ['A3']]],
         'B',
         ['def',
          'BB',
          ['(', 'a', 'b', 'c', ')'],
          ':',
          [['BB1'], [['def', 'BBA', ['(', ')'], ':', [['bba1'], ['bba2'], ['bba3']]]]]],
         'C',
         'D',
         ['def',
          'spam',
          ['(', 'x', 'y', ')'],
          ':',
          [[['def', 'eggs', ['(', 'z', ')'], ':', [['pass']]]]]]] 
    c                sN   |t | krd S t|| }| d krJ| d kr>t| |dt| |dd S )Nrr   zillegal nestingznot a peer entryrs   rs   )r   r9   r!   r   )r   r5  rv   curCol)indentStackrw   rx   checkPeerIndent  s     
z&indentedBlock.<locals>.checkPeerIndentc                s2   t || }| d kr" j| nt| |dd S )Nrr   znot a subentryrs   )r9   r   r   )r   r5  rv   r  )r  rw   rx   checkSubIndent  s    
z%indentedBlock.<locals>.checkSubIndentc                sN   |t | krd S t|| } o4| d k o4| d ksBt| |d j  d S )Nrr   rq   znot an unindentrs   r:  )r   r9   r   r   )r   r5  rv   r  )r  rw   rx   
checkUnindent  s     
z$indentedBlock.<locals>.checkUnindentz	 INDENTr   ZUNINDENTzindented block)r   r   r  r  r
   r   ri  r   r   r  rk  )ZblockStatementExprr  r  r  r  r  r!  r  ZPEERZUNDENTZsmExprrw   )r  rx   rf   Q  s    N,z#[\0xc0-\0xd6\0xd8-\0xf6\0xf8-\0xff]z[\0xa1-\0xbf\0xd7\0xf7]z_:zany tagzgt lt amp nbsp quot aposz><& "'z&(?P<entity>rn  z);zcommon HTML entityc             C   s   t j| jS )zRHelper parser action to replace common HTML entities with their special characters)_htmlEntityMapr   Zentity)rv   rw   rw   rx   r[     s    z/\*(?:[^*]|\*(?!/))*z*/zC style commentz<!--[\s\S]*?-->zHTML commentz.*zrest of linez//(?:\\\n|[^\n])*z
// commentzC++ style commentz#.*zPython style comment)r  z 		commaItem)r   c               @   s  e Zd ZdZeeZeeZe	e
jdjeZ
e	ejdjeedZedjdjeZe jed e je jdZejd	d
  eeeedj e  B jdZeje ed
jdjeZedjdjeZeeB eB j ZedjdjeZe	ed ed jdZedjdZ edjdZ!e!de! d  jdZ"ee!de! d>  d ee!de! d?   jdZ#e#j$d d
  d!e  jd"Z%e&e"e%B e#B jd#jd#Z'ed$jd%Z(e)d@d'd(Z*e)dAd*d+Z+ed,jd-Z,ed.jd/Z-ed0jd1Z.e/j e0j B Z1e)d2d3 Z2e&e3e4d4 e5   e	e6d4d5 ee7d6 j jd7Z8e9ee:j; e8B d8d9jd:Z<e)ed;d
 Z=e)ed<d
 Z>d=S )Brn   a
  
    Here are some common low-level expressions that may be useful in jump-starting parser development:
     - numeric forms (L{integers<integer>}, L{reals<real>}, L{scientific notation<sci_real>})
     - common L{programming identifiers<identifier>}
     - network addresses (L{MAC<mac_address>}, L{IPv4<ipv4_address>}, L{IPv6<ipv6_address>})
     - ISO8601 L{dates<iso8601_date>} and L{datetime<iso8601_datetime>}
     - L{UUID<uuid>}
     - L{comma-separated list<comma_separated_list>}
    Parse actions:
     - C{L{convertToInteger}}
     - C{L{convertToFloat}}
     - C{L{convertToDate}}
     - C{L{convertToDatetime}}
     - C{L{stripHTMLTags}}
     - C{L{upcaseTokens}}
     - C{L{downcaseTokens}}

    Example::
        pyparsing_common.number.runTests('''
            # any int or real number, returned as the appropriate type
            100
            -100
            +100
            3.14159
            6.02e23
            1e-12
            ''')

        pyparsing_common.fnumber.runTests('''
            # any int or real number, returned as float
            100
            -100
            +100
            3.14159
            6.02e23
            1e-12
            ''')

        pyparsing_common.hex_integer.runTests('''
            # hex numbers
            100
            FF
            ''')

        pyparsing_common.fraction.runTests('''
            # fractions
            1/2
            -3/4
            ''')

        pyparsing_common.mixed_integer.runTests('''
            # mixed fractions
            1
            1/2
            -3/4
            1-3/4
            ''')

        import uuid
        pyparsing_common.uuid.setParseAction(tokenMap(uuid.UUID))
        pyparsing_common.uuid.runTests('''
            # uuid
            12345678-1234-5678-1234-567812345678
            ''')
    prints::
        # any int or real number, returned as the appropriate type
        100
        [100]

        -100
        [-100]

        +100
        [100]

        3.14159
        [3.14159]

        6.02e23
        [6.02e+23]

        1e-12
        [1e-12]

        # any int or real number, returned as float
        100
        [100.0]

        -100
        [-100.0]

        +100
        [100.0]

        3.14159
        [3.14159]

        6.02e23
        [6.02e+23]

        1e-12
        [1e-12]

        # hex numbers
        100
        [256]

        FF
        [255]

        # fractions
        1/2
        [0.5]

        -3/4
        [-0.75]

        # mixed fractions
        1
        [1]

        1/2
        [0.5]

        -3/4
        [-0.75]

        1-3/4
        [1.75]

        # uuid
        12345678-1234-5678-1234-567812345678
        [UUID('12345678-1234-5678-1234-567812345678')]
    integerzhex integerrt  z[+-]?\d+zsigned integerr  fractionc             C   s   | d | d  S )Nr   rr   rs   rw   )rv   rw   rw   rx   ry     s    zpyparsing_common.<lambda>r8  z"fraction or mixed integer-fractionz
[+-]?\d+\.\d*zreal numberz+[+-]?\d+([eE][+-]?\d+|\.\d*([eE][+-]?\d+)?)z$real number with scientific notationz[+-]?\d+\.?\d*([eE][+-]?\d+)?fnumberrB  
identifierzK(25[0-5]|2[0-4][0-9]|1?[0-9]{1,2})(\.(25[0-5]|2[0-4][0-9]|1?[0-9]{1,2})){3}zIPv4 addressz[0-9a-fA-F]{1,4}hex_integerr     zfull IPv6 addressr   rB  z::zshort IPv6 addressc             C   s   t dd | D dk S )Nc             s   s   | ]}t jj|rd V  qdS )rr   N)rn   
_ipv6_partr  )r   rf  rw   rw   rx   r     s    z,pyparsing_common.<lambda>.<locals>.<genexpr>rw  )rH  )rv   rw   rw   rx   ry     s    z::ffff:zmixed IPv6 addresszIPv6 addressz:[0-9a-fA-F]{2}([:.-])[0-9a-fA-F]{2}(?:\1[0-9a-fA-F]{2}){4}zMAC address%Y-%m-%dc                s    fdd}|S )a  
        Helper to create a parse action for converting parsed date string to Python datetime.date

        Params -
         - fmt - format to be passed to datetime.strptime (default=C{"%Y-%m-%d"})

        Example::
            date_expr = pyparsing_common.iso8601_date.copy()
            date_expr.setParseAction(pyparsing_common.convertToDate())
            print(date_expr.parseString("1999-12-31"))
        prints::
            [datetime.date(1999, 12, 31)]
        c                sL   yt j|d  j S  tk
rF } zt| |t|W Y d d }~X nX d S )Nr   )r   strptimeZdater  r   r{   )r   r5  rv   ve)fmtrw   rx   cvt_fn  s    z.pyparsing_common.convertToDate.<locals>.cvt_fnrw   )r  r  rw   )r  rx   
convertToDate  s    zpyparsing_common.convertToDate%Y-%m-%dT%H:%M:%S.%fc                s    fdd}|S )a  
        Helper to create a parse action for converting parsed datetime string to Python datetime.datetime

        Params -
         - fmt - format to be passed to datetime.strptime (default=C{"%Y-%m-%dT%H:%M:%S.%f"})

        Example::
            dt_expr = pyparsing_common.iso8601_datetime.copy()
            dt_expr.setParseAction(pyparsing_common.convertToDatetime())
            print(dt_expr.parseString("1999-12-31T23:59:59.999"))
        prints::
            [datetime.datetime(1999, 12, 31, 23, 59, 59, 999000)]
        c                sH   yt j|d  S  tk
rB } zt| |t|W Y d d }~X nX d S )Nr   )r   r  r  r   r{   )r   r5  rv   r  )r  rw   rx   r    s    z2pyparsing_common.convertToDatetime.<locals>.cvt_fnrw   )r  r  rw   )r  rx   convertToDatetime  s    z"pyparsing_common.convertToDatetimez7(?P<year>\d{4})(?:-(?P<month>\d\d)(?:-(?P<day>\d\d))?)?zISO8601 datez(?P<year>\d{4})-(?P<month>\d\d)-(?P<day>\d\d)[T ](?P<hour>\d\d):(?P<minute>\d\d)(:(?P<second>\d\d(\.\d*)?)?)?(?P<tz>Z|[+-]\d\d:?\d\d)?zISO8601 datetimez2[0-9a-fA-F]{8}(-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}UUIDc             C   s   t jj|d S )a  
        Parse action to remove HTML tags from web page HTML source

        Example::
            # strip HTML links from normal text 
            text = '<td>More info at the <a href="http://pyparsing.wikispaces.com">pyparsing</a> wiki page</td>'
            td,td_end = makeHTMLTags("TD")
            table_text = td + SkipTo(td_end).setParseAction(pyparsing_common.stripHTMLTags)("body") + td_end
            
            print(table_text.parseString(text).body) # -> 'More info at the pyparsing wiki page'
        r   )rn   _html_stripperr   )r   r5  r  rw   rw   rx   
stripHTMLTags  s    
zpyparsing_common.stripHTMLTagsra  )r  z 	r  r   )r   zcomma separated listc             C   s   t | j S )N)r   r  )rv   rw   rw   rx   ry     s    c             C   s   t | j S )N)r   r  )rv   rw   rw   rx   ry     s    N)r   rB  )r   rB  )r  )r  )?r   r   r   r   rm   ru   ZconvertToIntegerfloatZconvertToFloatr/   rR   ri  r   r  rD   r  r'   Zsigned_integerr  rx  r   r  Z
mixed_integerrH  realZsci_realr  numberr  r4   r3   r  Zipv4_addressr  Z_full_ipv6_addressZ_short_ipv6_addressr~  Z_mixed_ipv6_addressr
   Zipv6_addressZmac_addressr  r  r  Ziso8601_dateZiso8601_datetimeuuidr7   r6   r  r  r   r   r   rV   r.   
_commasepitemr@   rY   r   Zcomma_separated_listrd   rB   rw   rw   rw   rx   rn     sN    ""
28__main__Zselectfromz_$r]  )rb  columnsrj  ZtablesZcommandaK  
        # '*' as column list and dotted table name
        select * from SYS.XYZZY

        # caseless match on "SELECT", and casts back to "select"
        SELECT * from XYZZY, ABC

        # list of column names, and mixed case SELECT keyword
        Select AA,BB,CC from Sys.dual

        # multiple tables
        Select A, B, C from Sys.dual, Table2

        # invalid SELECT keyword - should fail
        Xelect A, B, C from Sys.dual

        # incomplete command - should fail
        Select

        # invalid column name - should fail
        Select ^^^ frox Sys.dual

        z]
        100
        -100
        +100
        3.14159
        6.02e23
        1e-12
        z 
        100
        FF
        z6
        12345678-1234-5678-1234-567812345678
        )rq   )ra  F)N)FT)T)r   )T)r   __version__Z__versionTime__
__author__r   weakrefr   r   r   r~   r  rd  r  r  r"  r<  r  r   _threadr   ImportErrorZ	threadingr   r  Zordereddict__all__r  version_infor;  r  maxsizer  r{   r   chrru  r   rH  r   r  reversedr   r  r  r6  r  r  rI  ZmaxintZxranger   Z__builtin__r   Zfnamer   rJ  r   r   r   r   r   r   Zascii_uppercaseZascii_lowercaser4   rR   rD   r3   rk  r   Z	printablerV   rK  r   r   r!   r#   r&   r   r"   MutableMappingregisterr9   rJ   rG   r/  r2  r4  rQ   rM  r$   r,   r
   r   r   r  rQ  r   r   r   rl   r/   r'   r%   r	   r.   r0  r   r   r   r*   r)   r1   r0   r    r   r   r   r   r   r   r   rJ  r   r2   rM  rN  r   r(   r   rV  r-   r
   r   r   r+   r   rb   r@   r<   r  rO   rN   r  rS   rA   rg   rh   rj   ri  rC   rI   rH   ra   r`   r   Z_escapedPuncZ_escapedHexCharZ_escape