}t jd dkrZ|t  }||d< t	 }d|i}t
j|t|ddd | j
t jt||g| j|d	 t
t|d
}|drt|dd
|drt|dd
|drt| j| j|dd
d|dr"t||d W  5 Q R  S Q R X d S )Nr      ASCIIZPEP517_BUILD_BACKENDZPEP517_BACKEND_PATHkwargsz
input.json)indent)r)   r1   zoutput.jsonZunsupportedr    Z
no_backendZbackend_invalidZ
backend_errorr   Zhook_missingZ
return_val)sysversion_inforB   encoder    r+   pathsepr   getfilesystemencodingr   r   Z
write_jsonpjoinrC   
executable_in_proc_scriptr=   Z	read_jsongetr(   r   r   r"   )	r   r$   rW   rB   r1   r    r   Z
hook_inputdatar   r   r   rJ      sB    


zPep517HookCaller._call_hook)NN)N)NT)NN)N)N)
r   r   r   r   r   r   rF   rG   rL   rP   rR   rS   rJ   r   r   r   r   r<   ]   s      

	
  
  


r<   c                   @   s<   e Zd ZdZdd Zdd Zedd Zdd	 Zd
d Z	dS )

LoggerWrapperzd
    Read messages from a pipe and redirect them
    to a logger (see python's logging module).
    c                 C   sH   t j|  d| _|| _|| _t \| _| _	t
| j| _|   d S )NT)
	threadingThreadr   Zdaemonloggerlevelr+   pipeZfd_readfd_writefdopenreaderstart)r   rg   rh   r   r   r   r     s    zLoggerWrapper.__init__c                 C   s   | j S r   )rj   r@   r   r   r   fileno  s    zLoggerWrapper.filenoc                 C   s   |  tjr| d d S | S )N)endswithr+   linesep)msgr   r   r   remove_newline!  s    zLoggerWrapper.remove_newlinec                 C   s    | j D ]}| | | qd S r   )rl   _writers   )r   liner   r   r   run%  s    
zLoggerWrapper.runc                 C   s   | j | j| d S r   )rg   logrh   )r   r!   r   r   r   rt   )  s    zLoggerWrapper._writeN)
r   r   r   r   r   rn   staticmethodrs   rv   rt   r   r   r   r   rd     s   

rd   )NN)NN)"re   
contextlibr   r+   Zos.pathr   r   r   r_   r
   
subprocessr   r   r   rZ   Ztempfiler	   rY   r   __file__ra   r   	Exceptionr   r   r"   r(   r2   r4   r;   objectr<   rf   rd   r   r   r   r   <module>   s*   

	
	 /PK       ! 9    ,  pep517/__pycache__/meta.cpython-38.opt-1.pycnu [        U

    .e	                     @   sB  d Z ddlZddlZddlZddlZddlZzddlmZ W n e	k
rX   ddl
ZY nX zddlmZ W n  e	k
r   ddl
mZ Y nX ddlmZ ddlmZmZ ddlmZmZmZ ddlmZmZmZ eeZd	d
 Zddd
ZefddZdd Z e! Z"e"j#ddd e"j#dddd dd Z$edkr>e$  dS )z2Build metadata for a project using PEP 517 hooks.
    N)Path   )BuildEnvironment)Pep517HookCallerquiet_subprocess_runner)tempdirmkdir_pdir_to_zipfile)validate_systemload_system
compat_systemc              
   C   s   |  i }td| || td t J}td| | |i }tj||}t	
|tj|tj| W 5 Q R X d S )NzGot build requires: %sz$Installed dynamic build dependencieszTrying to build metadata in %s)Zget_requires_for_build_wheelloginfopip_installr   Z prepare_metadata_for_build_wheelospathjoinshutilZmovebasename)hooksenvdestZreqsZtdfilenamesource r   ;/usr/lib/python3.8/site-packages/pip/_vendor/pep517/meta.py
_prep_meta   s    


r   .c              
   C   s   |p
t | }tj| |pd}t| t| t| |d |d}|t	2 t
  }||d  t||| W 5 Q R X W 5 Q R X d S )NZdistz
build-backendzbackend-pathZrequires)
r   r   r   r   r   r
   r   getZsubprocess_runnerr   r   r   r   )
source_dirr   systemr   r   r   r   r   build)   s      r!   c              
   C   s0   t   }| |d t|W  5 Q R  S Q R X d S )N)r   )r   r	   )builderout_dirr   r   r   build_as_zip8   s    
r$   c                 C   s:   t j| } t| }tjt| |d}tt|}t	
|S )z
    Given a source directory (root) of a package,
    return an importlib.metadata.Distribution object
    with metadata build from that package.
    )r   r    )r   r   
expanduserr   	functoolspartialr!   r   r$   imp_metaZPathDistribution)rootr    r"   r   r   r   r   load>   s
    r*   r   z%A directory containing pyproject.toml)helpz	--out-dirz-oz>Destination in which to save the builds relative to source dirc                  C   s   t  } t| j| j d S )N)parser
parse_argsr!   r   r#   )argsr   r   r   mainV   s    r/   __main__)r   NN)%__doc__argparseZloggingr   r   r&   importlib.metadataZmetadatar(   ImportErrorZimportlib_metadataZzipfiler   ZzippZenvbuildr   Zwrappersr   r   Zdirtoolsr   r   r	   r!   r
   r   r   Z	getLogger__name__r
   r   r$   r*   ArgumentParserr,   add_argumentr/   r   r   r   r   <module>   sF   


 
PK       ! cB    -  pep517/__pycache__/check.cpython-38.opt-1.pycnu [        U

    .e=                     @   s   d Z ddlZddlZddlZddlmZmZ ddlm	Z	m
Z ddlZddl
mZ ddlZddlZddlmZ ddlZddlmZ dd	lmZ dd
lmZ eeZdd Zd
d Zdd ZdddZ dddddZ!dd Z"edkre   dS )zHCheck a project and backend by attempting to build using PEP 517 hooks.
    N)isfilejoin)TomlDecodeErrorload)CalledProcessError)mkdtemp   )enable_colourful_output)BuildEnvironment)Pep517HookCallerc              
   C   s  t  }z|| td W n* tk
rL   td Y W 5 Q R  dS X z| i }td| W n. tk
r   tjddd Y W 5 Q R  dS X z|| td W n* tk
r   td	 Y W 5 Q R  dS X t }td
| zz| |i }td| W n4 tk
r@   tjddd Y W W 5 Q R  dS X |d
sltd| W W 5 Q R  dS t
||}t|rtd| ntd| W FW 5 Q R  dS t|rtd ntd W W 5 Q R  dS W 5 t	
| X W 5 Q R  dS Q R X d S )N#Installed static build dependencies+Failed to install static build dependenciesFGot build requires: %s'Failure in get_requires_for_build_sdistTexc_info$Installed dynamic build dependencies,Failed to install dynamic build dependencieszTrying to build sdist in %szbuild_sdist returned %rzFailure in build_sdistz.tar.gzz*Filename %s doesn't have .tar.gz extensionOutput file %s existsOutput file %s does not existzOutput file is a tar filezOutput file is not a tar file)r
   pip_installloginfor   errorZget_requires_for_build_sdist	Exceptionr   shutilrmtreeZbuild_sdistendswithpjoinr   tarfileZ
is_tarfilehooksZbuild_sys_requiresenvZreqsZtdfilenamepath r%   </usr/lib/python3.8/site-packages/pip/_vendor/pep517/check.pycheck_build_sdist   sZ    





 


r'   c              
   C   s  t  }z|| td W n* tk
rL   td Y W 5 Q R  dS X z| i }td| W n. tk
r   tjddd Y W 5 Q R  dS X z|| td W n* tk
r   td	 Y W 5 Q R  dS X t }td
| zz| |i }td| W n4 tk
r@   tjddd Y W W 5 Q R  dS X |d
sltd| W W 5 Q R  dS t
||}t|rtd| ntd| W FW 5 Q R  dS t|rtd ntd W W 5 Q R  dS W 5 t	
| X W 5 Q R  dS Q R X d S )Nr   r
   Fr   r   Tr   r   r   zTrying to build wheel in %szbuild_wheel returned %rzFailure in build_wheelz.whlz'Filename %s doesn't have .whl extensionr   r   zOutput file is a zip filezOutput file is not a zip file)r
   r   r   r   r   r   Zget_requires_for_build_wheelr   r   r   r   Zbuild_wheelr   r   r   zipfileZ
is_zipfiler    r%   r%   r&   check_build_wheelO   sT    








r)   c              	   C   s   t | d}t|rtd ntd dS zLt|}t|}W 5 Q R X |d }|d }|d }|d}td	 W n( tt	fk
r   tjd
dd Y dS X t
| ||}t||}	t||}
|	st
d
 |
st
d |	S )Nzpyproject.tomlzFound pyproject.tomlzMissing pyproject.tomlFzbuild-systemrequiresz
build-backendzbackend-pathzLoaded pyproject.tomlzInvalid pyproject.tomlTr   z%Sdist checks failed; scroll up to seezWheel checks failed)r   r   r   r   r   open	toml_loadgetr   KeyErrorr   r'   r)   Zwarning)
source_dirZ	pyprojectfZpyproject_dataZbuildsysr*   ZbackendZbackend_pathr!   Zsdist_okZwheel_okr%   r%   r&   check   s0    







r1   c                 C   s`   t  }|jddd || }t  t|j}|rDttdd nttdd t	
d d S )	Nr/   z%A directory containing pyproject.toml)helpz
Checks passedgreenz
Checks failedredr   )argparseArgumentParseradd_argument
parse_argsr	   r1   r/   printansisysexit)argvZapargsokr%   r%   r&   main   s    

r@   z[0mz[1mz[31mz[32m)resetZboldr4   r3   c                 C   s8   t jdkr,tj r,t| t|  td  S t| S d S )NntrA   )osnamer;   stdoutisatty
ansi_codesstr)sattrr%   r%   r&   r:      s    r:   __main__)N)#__doc__r5   ZloggingrC   Zos.pathr   r   r   Ztomlr   r   r,   r   
subprocessr   r;   r   Ztempfiler   r(   Zcolorlogr	   Zenvbuildr
   Zwrappersr   Z	getLogger__name__r   r'   r)   r1   r@   rG   r:   r%   r%   r%   r&   <module>   s6   
98"
PK       ! +1     0  pep517/__pycache__/dirtools.cpython-38.opt-1.pycnu [        U

    .ei                     @   sZ   d dl Z d dlZd dlZd dlZd dlZd dlZd dlZejdd Zdd Z	dd Z
dS )    Nc               	   c   s$   t  } z
| V  W 5 t|  X dS )z2Create a temporary directory in a context manager.N)tempfileZmkdtempshutilZrmtree)Ztd r   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/dirtools.pytempdir
   s    
r   c               
   O   sD   zt j| |W S  tk
r> } z|jtjkr. W 5 d}~X Y nX dS )zWLike `mkdir`, but does not raise an exception if the
    directory already exists.
    N)osmkdirOSErrorerrnoZEEXIST)argskwargsexcr   r   r   mkdir_p   s
    r   c                 C   s   t  }t|d}t| D ]r\} }}|D ]0}tj| |}tj|| }|	|d d q,|D ],}tj| |}tj|| }|
|| qbq|S )z0Construct an in-memory zip file for a directory.w/ )ioBytesIOzipfileZZipFiler   walkpathjoinrelpathZwritestrwrite)rootbufferZzip_filedirsfilesr   Zfs_pathZrel_pathr   r   r   dir_to_zipfile   s    r   )r   r   
contextlibr   r   r
   r   contextmanagerr   r   r   r   r   r   r   <module>   s   
	PK       ! AײS"  "  0  pep517/__pycache__/envbuild.cpython-38.opt-1.pycnu [        U

    .e                     @   s   d Z ddlZddlZddlZddlZddlmZ ddlZddlm	Z	 ddl
mZ ddlm
Z
mZ eeZdd	 ZG d
d deZddd
ZdddZdS )zIBuild wheels/sdists by installing build deps to a temporary environment.
    N)
check_call)	get_paths)mkdtemp   )Pep517HookCaller
LoggerWrapperc              	   C   sH   t tj| d}t|}W 5 Q R X |d }|d |d |dfS )Nzpyproject.tomlzbuild-systemrequiresz
build-backendzbackend-path)openospathjointomlloadget)
source_dirfZpyproject_dataZbuildsys r   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/envbuild.py_load_pyproject   s    r   c                   @   s6   e Zd ZdZdZdddZdd Zdd	 Zd
d ZdS )
BuildEnvironmentzContext manager to install build deps in a simple temporary environment

    Based on code I wrote for pip, which is MIT licensed.
    NTc                 C   s
   || _ d S )N)_cleanup)selfZcleanupr   r   r   __init__9   s    zBuildEnvironment.__init__c                 C   s   t dd| _td| j tjdd | _tjdd | _tj	dkrHdnd}t
|| j| jdd	}|d
 }| jr|tj | j tjd< n|tj tj tjd< |d |d kr|d }n|d tj |d  }| jr|tj | j tjd< n
|tjd< | S )
Nzpep517-build-env-)prefixzTemporary build environment: %sPATH
PYTHONPATHntZposix_prefix)baseZplatbase)varsscriptsZpurelibZplatlib)
r   r   loginfor
   environr   	save_pathsave_pythonpathnamer   pathsepdefpath)r   Zinstall_schemeZinstall_dirsr   Zlib_dirsr   r   r   	__enter__<   s0    


zBuildEnvironment.__enter__c                 C   sT   |sdS t d| tjddddd| jgt| }t|tt tj	tt tj
d dS )	zAInstall dependencies into this env by calling pip in a subprocessNzCalling pip to install %sz-mZpipZinstallz--ignore-installedz--prefix)stdoutstderr)r    r!   sys
executabler   listr   r   loggingINFOZERROR)r   reqscmdr   r   r   pip_install\   s$         

zBuildEnvironment.pip_installc                 C   s~   | j o| jd k	otj| j}|r.t| j | jd krHtjdd  n| jtjd< | j	d krntjdd  n| j	tjd< d S )Nr   r   )
r   r   r
   isdirshutilZrmtreer#   r"   popr$   )r   exc_typeZexc_valZexc_tbZ
needs_cleanupr   r   r   __exit__j   s    

zBuildEnvironment.__exit__)T)	__name__
__module____qualname____doc__r   r   r(   r2   r7   r   r   r   r   r      s   
 r   c           	   
   C   sn   |dkri }t | \}}}t| ||}t 8}|| ||}|| |||W  5 Q R  S Q R X dS )am  Build a wheel from a source directory using PEP 517 hooks.

    :param str source_dir: Source directory containing pyproject.toml
    :param str wheel_dir: Target directory to create wheel in
    :param dict config_settings: Options to pass to build backend

    This is a blocking function which will run pip in a subprocess to install
    build requirements.
    N)r   r   r   r2   Zget_requires_for_build_wheelbuild_wheel)	r   Z	wheel_dirconfig_settingsr   backendbackend_pathhooksenvr0   r   r   r   r<   ~   s    



r<   c           	   
   C   sn   |dkri }t | \}}}t| ||}t 8}|| ||}|| |||W  5 Q R  S Q R X dS )am  Build an sdist from a source directory using PEP 517 hooks.

    :param str source_dir: Source directory containing pyproject.toml
    :param str sdist_dir: Target directory to place sdist in
    :param dict config_settings: Options to pass to build backend

    This is a blocking function which will run pip in a subprocess to install
    build requirements.
    N)r   r   r   r2   Zget_requires_for_build_sdistbuild_sdist)	r   Z	sdist_dirr=   r   r>   r?   r@   rA   r0   r   r   r   rB      s    



rB   )N)N)r;   r
   r.   r
   r4   
subprocessr   r+   Z	sysconfigr   Ztempfiler   Zwrappersr   r   Z	getLoggerr8   r    r   objectr   r<   rB   r   r   r   r   <module>   s   
a
PK       ! AײS"  "  *  pep517/__pycache__/envbuild.cpython-38.pycnu [        U

    .e                     @   s   d Z ddlZddlZddlZddlZddlmZ ddlZddlm	Z	 ddl
mZ ddlm
Z
mZ eeZdd	 ZG d
d deZddd
ZdddZdS )zIBuild wheels/sdists by installing build deps to a temporary environment.
    N)
check_call)	get_paths)mkdtemp   )Pep517HookCaller
LoggerWrapperc              	   C   sH   t tj| d}t|}W 5 Q R X |d }|d |d |dfS )Nzpyproject.tomlzbuild-systemrequiresz
build-backendzbackend-path)openospathjointomlloadget)
source_dirfZpyproject_dataZbuildsys r   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/envbuild.py_load_pyproject   s    r   c                   @   s6   e Zd ZdZdZdddZdd Zdd	 Zd
d ZdS )
BuildEnvironmentzContext manager to install build deps in a simple temporary environment

    Based on code I wrote for pip, which is MIT licensed.
    NTc                 C   s
   || _ d S )N)_cleanup)selfZcleanupr   r   r   __init__9   s    zBuildEnvironment.__init__c                 C   s   t dd| _td| j tjdd | _tjdd | _tj	dkrHdnd}t
|| j| jdd	}|d
 }| jr|tj | j tjd< n|tj tj tjd< |d |d kr|d }n|d tj |d  }| jr|tj | j tjd< n
|tjd< | S )
Nzpep517-build-env-)prefixzTemporary build environment: %sPATH
PYTHONPATHntZposix_prefix)baseZplatbase)varsscriptsZpurelibZplatlib)
r   r   loginfor
   environr   	save_pathsave_pythonpathnamer   pathsepdefpath)r   Zinstall_schemeZinstall_dirsr   Zlib_dirsr   r   r   	__enter__<   s0    


zBuildEnvironment.__enter__c                 C   sT   |sdS t d| tjddddd| jgt| }t|tt tj	tt tj
d dS )	zAInstall dependencies into this env by calling pip in a subprocessNzCalling pip to install %sz-mZpipZinstallz--ignore-installedz--prefix)stdoutstderr)r    r!   sys
executabler   listr   r   loggingINFOZERROR)r   reqscmdr   r   r   pip_install\   s$         

zBuildEnvironment.pip_installc                 C   s~   | j o| jd k	otj| j}|r.t| j | jd krHtjdd  n| jtjd< | j	d krntjdd  n| j	tjd< d S )Nr   r   )
r   r   r
   isdirshutilZrmtreer#   r"   popr$   )r   exc_typeZexc_valZexc_tbZ
needs_cleanupr   r   r   __exit__j   s    

zBuildEnvironment.__exit__)T)	__name__
__module____qualname____doc__r   r   r(   r2   r7   r   r   r   r   r      s   
 r   c           	   
   C   sn   |dkri }t | \}}}t| ||}t 8}|| ||}|| |||W  5 Q R  S Q R X dS )am  Build a wheel from a source directory using PEP 517 hooks.

    :param str source_dir: Source directory containing pyproject.toml
    :param str wheel_dir: Target directory to create wheel in
    :param dict config_settings: Options to pass to build backend

    This is a blocking function which will run pip in a subprocess to install
    build requirements.
    N)r   r   r   r2   Zget_requires_for_build_wheelbuild_wheel)	r   Z	wheel_dirconfig_settingsr   backendbackend_pathhooksenvr0   r   r   r   r<   ~   s    



r<   c           	   
   C   sn   |dkri }t | \}}}t| ||}t 8}|| ||}|| |||W  5 Q R  S Q R X dS )am  Build an sdist from a source directory using PEP 517 hooks.

    :param str source_dir: Source directory containing pyproject.toml
    :param str sdist_dir: Target directory to place sdist in
    :param dict config_settings: Options to pass to build backend

    This is a blocking function which will run pip in a subprocess to install
    build requirements.
    N)r   r   r   r2   Zget_requires_for_build_sdistbuild_sdist)	r   Z	sdist_dirr=   r   r>   r?   r@   rA   r0   r   r   r   rB      s    



rB   )N)N)r;   r
   r.   r
   r4   
subprocessr   r+   Z	sysconfigr   Ztempfiler   Zwrappersr   r   Z	getLoggerr8   r    r   objectr   r<   rB   r   r   r   r   <module>   s   
a
PK       ! K͘
  
  -  pep517/__pycache__/build.cpython-38.opt-1.pycnu [        U

    .e                     @   s   d Z ddlZddlZddlZddlZddlZddlmZ ddlm	Z	 ddl
mZmZ ddl
mZ eeZdd	 Zd
d Zdd
 Zdd Zd"ddZe Zejddd ejddddd ejddddd ejdddd dd  Zed!kree  dS )#z%Build a project using PEP 517 hooks.
    N   )BuildEnvironment)Pep517HookCaller)tempdirmkdir_p)FileNotFoundErrorc                 C   s4   ddh}|t | ks0dj|t |  d}t|dS )z7
    Ensure build system has the requisite fields.
    requires
build-backendz"Missing required fields: {missing})ZmissingN)setformat
ValueError)systemZrequiredmessage r   </usr/lib/python3.8/site-packages/pip/_vendor/pep517/build.pyvalidate_system   s    
r   c              	   C   s4   t j| d}t|}t|}W 5 Q R X |d S )zC
    Load the build system from a source dir (pyproject.toml).
    zpyproject.tomlzbuild-system)ospathjoinopentomlload)
source_dirZ	pyprojectfZpyproject_datar   r   r   load_system   s    
r   c              	   C   sJ   zt | }W n ttfk
r(   i }Y nX |dd |dddg |S )z
    Given a source dir, attempt to get a build system backend
    and requirements from pyproject.toml. Fallback to
    setuptools but only if the file was not found or a build
    system was not indicated.
    r	   z setuptools.build_meta:__legacy__r   Z
setuptoolswheel)r   r   KeyError
setdefault)r   r
   r   r   r   
compat_system'   s    
r   c              
   C   s   dj f t }t| |}|i }td| || td t b}td|| dj f t }t| |}	|	|i }
tj	||
}t
|tj	|tj|
 W 5 Q R X d S )Nzget_requires_for_build_{dist}zGot build requires: %sz$Installed dynamic build dependencieszTrying to build %s in %szbuild_{dist})
r   localsgetattrloginfopip_installr   r   r   r   shutilZmovebasename)hooksenvdistdestZget_requires_nameZget_requiresZreqsZtdZ
build_namebuildfilenamesourcer   r   r   	_do_build:   s    




r-   c              	   C   sv   |p
t | }tj| |pd}t| t| t| |d |d}t "}|	|d  t
|||| W 5 Q R X d S )Nr(   r	   zbackend-pathr   )r   r   r   r   r   r   r   getr   r#   r-   )r   r(   r)   r
   r&   r'   r   r   r   r*   L   s      r*   r   z%A directory containing pyproject.toml)helpz--binaryz-b
store_trueF)actiondefaultz--sourcez-sz	--out-dirz-oz>Destination in which to save the builds relative to source dirc                 C   sP   t td | js| jsdnd | js$| js(dnd f}|D ]}t| j|| j q6d S )NZsdistr   )listfilterr,   Zbinaryr*   r   Zout_dir)argsZdistsr(   r   r   r   mainp   s    r6   __main__)NN)__doc__argparseZloggingr   r   r$   Zenvbuildr   Zwrappersr   Zdirtoolsr   r   compatr   Z	getLogger__name__r!   r   r   r   r-   r*   ArgumentParserparseradd_argumentr6   
parse_argsr   r   r   r   <module>   sP   


   PK       ! 
g)  g)    pep517/wrappers.pynu [        import threading
from contextlib import contextmanager
import os
from os.path import dirname, abspath, join as pjoin
import shutil
from subprocess import check_call, check_output, STDOUT
import sys
from tempfile import mkdtemp

from . import compat

_in_proc_script = pjoin(dirname(abspath(__file__)), '_in_process.py')


@contextmanager
def tempdir():
    td = mkdtemp()
    try:
        yield td
    finally:
        shutil.rmtree(td)


class BackendUnavailable(Exception):
    """Will be raised if the backend cannot be imported in the hook process."""
    def __init__(self, traceback):
        self.traceback = traceback


class BackendInvalid(Exception):
    """Will be raised if the backend is invalid."""
    def __init__(self, backend_name, backend_path, message):
        self.backend_name = backend_name
        self.backend_path = backend_path
        self.message = message


class HookMissing(Exception):
    """Will be raised on missing hooks."""
    def __init__(self, hook_name):
        super(HookMissing, self).__init__(hook_name)
        self.hook_name = hook_name


class UnsupportedOperation(Exception):
    """May be raised by build_sdist if the backend indicates that it can't."""
    def __init__(self, traceback):
        self.traceback = traceback


def default_subprocess_runner(cmd, cwd=None, extra_environ=None):
    """The default method of calling the wrapper subprocess."""
    env = os.environ.copy()
    if extra_environ:
        env.update(extra_environ)

    check_call(cmd, cwd=cwd, env=env)


def quiet_subprocess_runner(cmd, cwd=None, extra_environ=None):
    """A method of calling the wrapper subprocess while suppressing output."""
    env = os.environ.copy()
    if extra_environ:
        env.update(extra_environ)

    check_output(cmd, cwd=cwd, env=env, stderr=STDOUT)


def norm_and_check(source_tree, requested):
    """Normalise and check a backend path.

    Ensure that the requested backend path is specified as a relative path,
    and resolves to a location under the given source tree.

    Return an absolute version of the requested path.
    """
    if os.path.isabs(requested):
        raise ValueError("paths must be relative")

    abs_source = os.path.abspath(source_tree)
    abs_requested = os.path.normpath(os.path.join(abs_source, requested))
    # We have to use commonprefix for Python 2.7 compatibility. So we
    # normalise case to avoid problems because commonprefix is a character
    # based comparison :-(
    norm_source = os.path.normcase(abs_source)
    norm_requested = os.path.normcase(abs_requested)
    if os.path.commonprefix([norm_source, norm_requested]) != norm_source:
        raise ValueError("paths must be inside source tree")

    return abs_requested


class Pep517HookCaller(object):
    """A wrapper around a source directory to be built with a PEP 517 backend.

    source_dir : The path to the source directory, containing pyproject.toml.
    build_backend : The build backend spec, as per PEP 517, from
        pyproject.toml.
    backend_path : The backend path, as per PEP 517, from pyproject.toml.
    runner : A callable that invokes the wrapper subprocess.

    The 'runner', if provided, must expect the following:
        cmd : a list of strings representing the command and arguments to
            execute, as would be passed to e.g. 'subprocess.check_call'.
        cwd : a string representing the working directory that must be
            used for the subprocess. Corresponds to the provided source_dir.
        extra_environ : a dict mapping environment variable names to values
            which must be set for the subprocess execution.
    """
    def __init__(
            self,
            source_dir,
            build_backend,
            backend_path=None,
            runner=None,
    ):
        if runner is None:
            runner = default_subprocess_runner

        self.source_dir = abspath(source_dir)
        self.build_backend = build_backend
        if backend_path:
            backend_path = [
                norm_and_check(self.source_dir, p) for p in backend_path
            ]
        self.backend_path = backend_path
        self._subprocess_runner = runner

    # TODO: Is this over-engineered? Maybe frontends only need to
    #       set this when creating the wrapper, not on every call.
    @contextmanager
    def subprocess_runner(self, runner):
        """A context manager for temporarily overriding the default subprocess
        runner.
        """
        prev = self._subprocess_runner
        self._subprocess_runner = runner
        yield
        self._subprocess_runner = prev

    def get_requires_for_build_wheel(self, config_settings=None):
        """Identify packages required for building a wheel

        Returns a list of dependency specifications, e.g.:
            ["wheel >= 0.25", "setuptools"]

        This does not include requirements specified in pyproject.toml.
        It returns the result of calling the equivalently named hook in a
        subprocess.
        """
        return self._call_hook('get_requires_for_build_wheel', {
            'config_settings': config_settings
        })

    def prepare_metadata_for_build_wheel(
            self, metadata_directory, config_settings=None,
            _allow_fallback=True):
        """Prepare a *.dist-info folder with metadata for this project.

        Returns the name of the newly created folder.

        If the build backend defines a hook with this name, it will be called
        in a subprocess. If not, the backend will be asked to build a wheel,
        and the dist-info extracted from that (unless _allow_fallback is
        False).
        """
        return self._call_hook('prepare_metadata_for_build_wheel', {
            'metadata_directory': abspath(metadata_directory),
            'config_settings': config_settings,
            '_allow_fallback': _allow_fallback,
        })

    def build_wheel(
            self, wheel_directory, config_settings=None,
            metadata_directory=None):
        """Build a wheel from this project.

        Returns the name of the newly created file.

        In general, this will call the 'build_wheel' hook in the backend.
        However, if that was previously called by
        'prepare_metadata_for_build_wheel', and the same metadata_directory is
        used, the previously built wheel will be copied to wheel_directory.
        """
        if metadata_directory is not None:
            metadata_directory = abspath(metadata_directory)
        return self._call_hook('build_wheel', {
            'wheel_directory': abspath(wheel_directory),
            'config_settings': config_settings,
            'metadata_directory': metadata_directory,
        })

    def get_requires_for_build_sdist(self, config_settings=None):
        """Identify packages required for building a wheel

        Returns a list of dependency specifications, e.g.:
            ["setuptools >= 26"]

        This does not include requirements specified in pyproject.toml.
        It returns the result of calling the equivalently named hook in a
        subprocess.
        """
        return self._call_hook('get_requires_for_build_sdist', {
            'config_settings': config_settings
        })

    def build_sdist(self, sdist_directory, config_settings=None):
        """Build an sdist from this project.

        Returns the name of the newly created file.

        This calls the 'build_sdist' backend hook in a subprocess.
        """
        return self._call_hook('build_sdist', {
            'sdist_directory': abspath(sdist_directory),
            'config_settings': config_settings,
        })

    def _call_hook(self, hook_name, kwargs):
        # On Python 2, pytoml returns Unicode values (which is correct) but the
        # environment passed to check_call needs to contain string values. We
        # convert here by encoding using ASCII (the backend can only contain
        # letters, digits and _, . and : characters, and will be used as a
        # Python identifier, so non-ASCII content is wrong on Python 2 in
        # any case).
        # For backend_path, we use sys.getfilesystemencoding.
        if sys.version_info[0] == 2:
            build_backend = self.build_backend.encode('ASCII')
        else:
            build_backend = self.build_backend
        extra_environ = {'PEP517_BUILD_BACKEND': build_backend}

        if self.backend_path:
            backend_path = os.pathsep.join(self.backend_path)
            if sys.version_info[0] == 2:
                backend_path = backend_path.encode(sys.getfilesystemencoding())
            extra_environ['PEP517_BACKEND_PATH'] = backend_path

        with tempdir() as td:
            hook_input = {'kwargs': kwargs}
            compat.write_json(hook_input, pjoin(td, 'input.json'),
                              indent=2)

            # Run the hook in a subprocess
            self._subprocess_runner(
                [sys.executable, _in_proc_script, hook_name, td],
                cwd=self.source_dir,
                extra_environ=extra_environ
            )

            data = compat.read_json(pjoin(td, 'output.json'))
            if data.get('unsupported'):
                raise UnsupportedOperation(data.get('traceback', ''))
            if data.get('no_backend'):
                raise BackendUnavailable(data.get('traceback', ''))
            if data.get('backend_invalid'):
                raise BackendInvalid(
                    backend_name=self.build_backend,
                    backend_path=self.backend_path,
                    message=data.get('backend_error', '')
                )
            if data.get('hook_missing'):
                raise HookMissing(hook_name)
            return data['return_val']


class LoggerWrapper(threading.Thread):
    """
    Read messages from a pipe and redirect them
    to a logger (see python's logging module).
    """

    def __init__(self, logger, level):
        threading.Thread.__init__(self)
        self.daemon = True

        self.logger = logger
        self.level = level

        # create the pipe and reader
        self.fd_read, self.fd_write = os.pipe()
        self.reader = os.fdopen(self.fd_read)

        self.start()

    def fileno(self):
        return self.fd_write

    @staticmethod
    def remove_newline(msg):
        return msg[:-1] if msg.endswith(os.linesep) else msg

    def run(self):
        for line in self.reader:
            self._write(self.remove_newline(line))

    def _write(self, message):
        self.logger.log(self.level, message)
PK       ! 
V      pep517/colorlog.pynu [        """Nicer log formatting with colours.

Code copied from Tornado, Apache licensed.
"""
# Copyright 2012 Facebook
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import logging
import sys

try:
    import curses
except ImportError:
    curses = None


def _stderr_supports_color():
    color = False
    if curses and hasattr(sys.stderr, 'isatty') and sys.stderr.isatty():
        try:
            curses.setupterm()
            if curses.tigetnum("colors") > 0:
                color = True
        except Exception:
            pass
    return color


class LogFormatter(logging.Formatter):
    """Log formatter with colour support
    """
    DEFAULT_COLORS = {
        logging.INFO: 2,  # Green
        logging.WARNING: 3,  # Yellow
        logging.ERROR: 1,  # Red
        logging.CRITICAL: 1,
    }

    def __init__(self, color=True, datefmt=None):
        r"""
        :arg bool color: Enables color support.
        :arg string fmt: Log message format.
        It will be applied to the attributes dict of log records. The
        text between ``%(color)s`` and ``%(end_color)s`` will be colored
        depending on the level if color support is on.
        :arg dict colors: color mappings from logging level to terminal color
        code
        :arg string datefmt: Datetime format.
        Used for formatting ``(asctime)`` placeholder in ``prefix_fmt``.
        .. versionchanged:: 3.2
        Added ``fmt`` and ``datefmt`` arguments.
        """
        logging.Formatter.__init__(self, datefmt=datefmt)
        self._colors = {}
        if color and _stderr_supports_color():
            # The curses module has some str/bytes confusion in
            # python3. Until version 3.2.3, most methods return
            # bytes, but only accept strings. In addition, we want to
            # output these strings with the logging module, which
            # works with unicode strings. The explicit calls to
            # unicode() below are harmless in python2 but will do the
            # right conversion in python 3.
            fg_color = (curses.tigetstr("setaf") or
                        curses.tigetstr("setf") or "")
            if (3, 0) < sys.version_info < (3, 2, 3):
                fg_color = str(fg_color, "ascii")

            for levelno, code in self.DEFAULT_COLORS.items():
                self._colors[levelno] = str(
                    curses.tparm(fg_color, code), "ascii")
            self._normal = str(curses.tigetstr("sgr0"), "ascii")

            scr = curses.initscr()
            self.termwidth = scr.getmaxyx()[1]
            curses.endwin()
        else:
            self._normal = ''
            # Default width is usually 80, but too wide is
            # worse than too narrow
            self.termwidth = 70

    def formatMessage(self, record):
        mlen = len(record.message)
        right_text = '{initial}-{name}'.format(initial=record.levelname[0],
                                               name=record.name)
        if mlen + len(right_text) < self.termwidth:
            space = ' ' * (self.termwidth - (mlen + len(right_text)))
        else:
            space = '  '

        if record.levelno in self._colors:
            start_color = self._colors[record.levelno]
            end_color = self._normal
        else:
            start_color = end_color = ''

        return record.message + space + start_color + right_text + end_color


def enable_colourful_output(level=logging.INFO):
    handler = logging.StreamHandler()
    handler.setFormatter(LogFormatter())
    logging.root.addHandler(handler)
    logging.root.setLevel(level)
PK       ! ɝ      pep517/envbuild.pynu [        """Build wheels/sdists by installing build deps to a temporary environment.
"""

import os
import logging
import toml
import shutil
from subprocess import check_call
import sys
from sysconfig import get_paths
from tempfile import mkdtemp

from .wrappers import Pep517HookCaller, LoggerWrapper

log = logging.getLogger(__name__)


def _load_pyproject(source_dir):
    with open(os.path.join(source_dir, 'pyproject.toml')) as f:
        pyproject_data = toml.load(f)
    buildsys = pyproject_data['build-system']
    return (
        buildsys['requires'],
        buildsys['build-backend'],
        buildsys.get('backend-path'),
    )


class BuildEnvironment(object):
    """Context manager to install build deps in a simple temporary environment

    Based on code I wrote for pip, which is MIT licensed.
    """
    # Copyright (c) 2008-2016 The pip developers (see AUTHORS.txt file)
    #
    # Permission is hereby granted, free of charge, to any person obtaining
    # a copy of this software and associated documentation files (the
    # "Software"), to deal in the Software without restriction, including
    # without limitation the rights to use, copy, modify, merge, publish,
    # distribute, sublicense, and/or sell copies of the Software, and to
    # permit persons to whom the Software is furnished to do so, subject to
    # the following conditions:
    #
    # The above copyright notice and this permission notice shall be
    # included in all copies or substantial portions of the Software.
    #
    # THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    # EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    # MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    # NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    # LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
    # OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    # WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    path = None

    def __init__(self, cleanup=True):
        self._cleanup = cleanup

    def __enter__(self):
        self.path = mkdtemp(prefix='pep517-build-env-')
        log.info('Temporary build environment: %s', self.path)

        self.save_path = os.environ.get('PATH', None)
        self.save_pythonpath = os.environ.get('PYTHONPATH', None)

        install_scheme = 'nt' if (os.name == 'nt') else 'posix_prefix'
        install_dirs = get_paths(install_scheme, vars={
            'base': self.path,
            'platbase': self.path,
        })

        scripts = install_dirs['scripts']
        if self.save_path:
            os.environ['PATH'] = scripts + os.pathsep + self.save_path
        else:
            os.environ['PATH'] = scripts + os.pathsep + os.defpath

        if install_dirs['purelib'] == install_dirs['platlib']:
            lib_dirs = install_dirs['purelib']
        else:
            lib_dirs = install_dirs['purelib'] + os.pathsep + \
                install_dirs['platlib']
        if self.save_pythonpath:
            os.environ['PYTHONPATH'] = lib_dirs + os.pathsep + \
                self.save_pythonpath
        else:
            os.environ['PYTHONPATH'] = lib_dirs

        return self

    def pip_install(self, reqs):
        """Install dependencies into this env by calling pip in a subprocess"""
        if not reqs:
            return
        log.info('Calling pip to install %s', reqs)
        cmd = [
            sys.executable, '-m', 'pip', 'install', '--ignore-installed',
            '--prefix', self.path] + list(reqs)
        check_call(
            cmd,
            stdout=LoggerWrapper(log, logging.INFO),
            stderr=LoggerWrapper(log, logging.ERROR),
        )

    def __exit__(self, exc_type, exc_val, exc_tb):
        needs_cleanup = (
            self._cleanup and
            self.path is not None and
            os.path.isdir(self.path)
        )
        if needs_cleanup:
            shutil.rmtree(self.path)

        if self.save_path is None:
            os.environ.pop('PATH', None)
        else:
            os.environ['PATH'] = self.save_path

        if self.save_pythonpath is None:
            os.environ.pop('PYTHONPATH', None)
        else:
            os.environ['PYTHONPATH'] = self.save_pythonpath


def build_wheel(source_dir, wheel_dir, config_settings=None):
    """Build a wheel from a source directory using PEP 517 hooks.

    :param str source_dir: Source directory containing pyproject.toml
    :param str wheel_dir: Target directory to create wheel in
    :param dict config_settings: Options to pass to build backend

    This is a blocking function which will run pip in a subprocess to install
    build requirements.
    """
    if config_settings is None:
        config_settings = {}
    requires, backend, backend_path = _load_pyproject(source_dir)
    hooks = Pep517HookCaller(source_dir, backend, backend_path)

    with BuildEnvironment() as env:
        env.pip_install(requires)
        reqs = hooks.get_requires_for_build_wheel(config_settings)
        env.pip_install(reqs)
        return hooks.build_wheel(wheel_dir, config_settings)


def build_sdist(source_dir, sdist_dir, config_settings=None):
    """Build an sdist from a source directory using PEP 517 hooks.

    :param str source_dir: Source directory containing pyproject.toml
    :param str sdist_dir: Target directory to place sdist in
    :param dict config_settings: Options to pass to build backend

    This is a blocking function which will run pip in a subprocess to install
    build requirements.
    """
    if config_settings is None:
        config_settings = {}
    requires, backend, backend_path = _load_pyproject(source_dir)
    hooks = Pep517HookCaller(source_dir, backend, backend_path)

    with BuildEnvironment() as env:
        env.pip_install(requires)
        reqs = hooks.get_requires_for_build_sdist(config_settings)
        env.pip_install(reqs)
        return hooks.build_sdist(sdist_dir, config_settings)
PK       ! .RT   T     pep517/__init__.pynu [        """Wrappers to build Python packages using PEP 517 hooks
"""

__version__ = '0.7.0'
PK       ! /찬      pep517/build.pynu [        """Build a project using PEP 517 hooks.
"""
import argparse
import logging
import os
import toml
import shutil

from .envbuild import BuildEnvironment
from .wrappers import Pep517HookCaller
from .dirtools import tempdir, mkdir_p
from .compat import FileNotFoundError

log = logging.getLogger(__name__)


def validate_system(system):
    """
    Ensure build system has the requisite fields.
    """
    required = {'requires', 'build-backend'}
    if not (required <= set(system)):
        message = "Missing required fields: {missing}".format(
            missing=required-set(system),
        )
        raise ValueError(message)


def load_system(source_dir):
    """
    Load the build system from a source dir (pyproject.toml).
    """
    pyproject = os.path.join(source_dir, 'pyproject.toml')
    with open(pyproject) as f:
        pyproject_data = toml.load(f)
    return pyproject_data['build-system']


def compat_system(source_dir):
    """
    Given a source dir, attempt to get a build system backend
    and requirements from pyproject.toml. Fallback to
    setuptools but only if the file was not found or a build
    system was not indicated.
    """
    try:
        system = load_system(source_dir)
    except (FileNotFoundError, KeyError):
        system = {}
    system.setdefault(
        'build-backend',
        'setuptools.build_meta:__legacy__',
    )
    system.setdefault('requires', ['setuptools', 'wheel'])
    return system


def _do_build(hooks, env, dist, dest):
    get_requires_name = 'get_requires_for_build_{dist}'.format(**locals())
    get_requires = getattr(hooks, get_requires_name)
    reqs = get_requires({})
    log.info('Got build requires: %s', reqs)

    env.pip_install(reqs)
    log.info('Installed dynamic build dependencies')

    with tempdir() as td:
        log.info('Trying to build %s in %s', dist, td)
        build_name = 'build_{dist}'.format(**locals())
        build = getattr(hooks, build_name)
        filename = build(td, {})
        source = os.path.join(td, filename)
        shutil.move(source, os.path.join(dest, os.path.basename(filename)))


def build(source_dir, dist, dest=None, system=None):
    system = system or load_system(source_dir)
    dest = os.path.join(source_dir, dest or 'dist')
    mkdir_p(dest)

    validate_system(system)
    hooks = Pep517HookCaller(
        source_dir, system['build-backend'], system.get('backend-path')
    )

    with BuildEnvironment() as env:
        env.pip_install(system['requires'])
        _do_build(hooks, env, dist, dest)


parser = argparse.ArgumentParser()
parser.add_argument(
    'source_dir',
    help="A directory containing pyproject.toml",
)
parser.add_argument(
    '--binary', '-b',
    action='store_true',
    default=False,
)
parser.add_argument(
    '--source', '-s',
    action='store_true',
    default=False,
)
parser.add_argument(
    '--out-dir', '-o',
    help="Destination in which to save the builds relative to source dir",
)


def main(args):
    # determine which dists to build
    dists = list(filter(None, (
        'sdist' if args.source or not args.binary else None,
        'wheel' if args.binary or not args.source else None,
    )))

    for dist in dists:
        build(args.source_dir, dist, args.out_dir)


if __name__ == '__main__':
    main(parser.parse_args())
PK       ! N=  =    pep517/check.pynu [        """Check a project and backend by attempting to build using PEP 517 hooks.
"""
import argparse
import logging
import os
from os.path import isfile, join as pjoin
from toml import TomlDecodeError, load as toml_load
import shutil
from subprocess import CalledProcessError
import sys
import tarfile
from tempfile import mkdtemp
import zipfile

from .colorlog import enable_colourful_output
from .envbuild import BuildEnvironment
from .wrappers import Pep517HookCaller

log = logging.getLogger(__name__)


def check_build_sdist(hooks, build_sys_requires):
    with BuildEnvironment() as env:
        try:
            env.pip_install(build_sys_requires)
            log.info('Installed static build dependencies')
        except CalledProcessError:
            log.error('Failed to install static build dependencies')
            return False

        try:
            reqs = hooks.get_requires_for_build_sdist({})
            log.info('Got build requires: %s', reqs)
        except Exception:
            log.error('Failure in get_requires_for_build_sdist', exc_info=True)
            return False

        try:
            env.pip_install(reqs)
            log.info('Installed dynamic build dependencies')
        except CalledProcessError:
            log.error('Failed to install dynamic build dependencies')
            return False

        td = mkdtemp()
        log.info('Trying to build sdist in %s', td)
        try:
            try:
                filename = hooks.build_sdist(td, {})
                log.info('build_sdist returned %r', filename)
            except Exception:
                log.info('Failure in build_sdist', exc_info=True)
                return False

            if not filename.endswith('.tar.gz'):
                log.error(
                    "Filename %s doesn't have .tar.gz extension", filename)
                return False

            path = pjoin(td, filename)
            if isfile(path):
                log.info("Output file %s exists", path)
            else:
                log.error("Output file %s does not exist", path)
                return False

            if tarfile.is_tarfile(path):
                log.info("Output file is a tar file")
            else:
                log.error("Output file is not a tar file")
                return False

        finally:
            shutil.rmtree(td)

        return True


def check_build_wheel(hooks, build_sys_requires):
    with BuildEnvironment() as env:
        try:
            env.pip_install(build_sys_requires)
            log.info('Installed static build dependencies')
        except CalledProcessError:
            log.error('Failed to install static build dependencies')
            return False

        try:
            reqs = hooks.get_requires_for_build_wheel({})
            log.info('Got build requires: %s', reqs)
        except Exception:
            log.error('Failure in get_requires_for_build_sdist', exc_info=True)
            return False

        try:
            env.pip_install(reqs)
            log.info('Installed dynamic build dependencies')
        except CalledProcessError:
            log.error('Failed to install dynamic build dependencies')
            return False

        td = mkdtemp()
        log.info('Trying to build wheel in %s', td)
        try:
            try:
                filename = hooks.build_wheel(td, {})
                log.info('build_wheel returned %r', filename)
            except Exception:
                log.info('Failure in build_wheel', exc_info=True)
                return False

            if not filename.endswith('.whl'):
                log.error("Filename %s doesn't have .whl extension", filename)
                return False

            path = pjoin(td, filename)
            if isfile(path):
                log.info("Output file %s exists", path)
            else:
                log.error("Output file %s does not exist", path)
                return False

            if zipfile.is_zipfile(path):
                log.info("Output file is a zip file")
            else:
                log.error("Output file is not a zip file")
                return False

        finally:
            shutil.rmtree(td)

        return True


def check(source_dir):
    pyproject = pjoin(source_dir, 'pyproject.toml')
    if isfile(pyproject):
        log.info('Found pyproject.toml')
    else:
        log.error('Missing pyproject.toml')
        return False

    try:
        with open(pyproject) as f:
            pyproject_data = toml_load(f)
        # Ensure the mandatory data can be loaded
        buildsys = pyproject_data['build-system']
        requires = buildsys['requires']
        backend = buildsys['build-backend']
        backend_path = buildsys.get('backend-path')
        log.info('Loaded pyproject.toml')
    except (TomlDecodeError, KeyError):
        log.error("Invalid pyproject.toml", exc_info=True)
        return False

    hooks = Pep517HookCaller(source_dir, backend, backend_path)

    sdist_ok = check_build_sdist(hooks, requires)
    wheel_ok = check_build_wheel(ho