Z	pyprojectfZpyproject_dataZbuildsysr*   ZbackendZbackend_pathr!   Zsdist_okZwheel_okr%   r%   r&   check   s0    







r1   c                 C   s`   t  }|jddd || }t  t|j}|rDttdd nttdd t	
d d S )	Nr/   z%A directory containing pyproject.toml)helpz
Checks passedgreenz
Checks failedredr   )argparseArgumentParseradd_argument
parse_argsr	   r1   r/   printansisysexit)argvZapargsokr%   r%   r&   main   s    

r@   z[0mz[1mz[31mz[32m)resetZboldr4   r3   c                 C   s8   t jdkr,tj r,t| t|  td  S t| S d S )NntrA   )osnamer;   stdoutisatty
ansi_codesstr)sattrr%   r%   r&   r:      s    r:   __main__)N)#__doc__r5   ZloggingrC   Zos.pathr   r   r   Ztomlr   r   r,   r   
subprocessr   r;   r   Ztempfiler   r(   Zcolorlogr	   Zenvbuildr
   Zwrappersr   Z	getLogger__name__r   r'   r)   r1   r@   rG   r:   r%   r%   r%   r&   <module>   s6   
98"
PK       ! K͘
  
  '  pep517/__pycache__/build.cpython-38.pycnu [        U

    .e                     @   s   d Z ddlZddlZddlZddlZddlZddlmZ ddlm	Z	 ddl
mZmZ ddl
mZ eeZdd	 Zd
d Zdd
 Zdd Zd"ddZe Zejddd ejddddd ejddddd ejdddd dd  Zed!kree  dS )#z%Build a project using PEP 517 hooks.
    N   )BuildEnvironment)Pep517HookCaller)tempdirmkdir_p)FileNotFoundErrorc                 C   s4   ddh}|t | ks0dj|t |  d}t|dS )z7
    Ensure build system has the requisite fields.
    requires
build-backendz"Missing required fields: {missing})ZmissingN)setformat
ValueError)systemZrequiredmessage r   </usr/lib/python3.8/site-packages/pip/_vendor/pep517/build.pyvalidate_system   s    
r   c              	   C   s4   t j| d}t|}t|}W 5 Q R X |d S )zC
    Load the build system from a source dir (pyproject.toml).
    zpyproject.tomlzbuild-system)ospathjoinopentomlload)
source_dirZ	pyprojectfZpyproject_datar   r   r   load_system   s    
r   c              	   C   sJ   zt | }W n ttfk
r(   i }Y nX |dd |dddg |S )z
    Given a source dir, attempt to get a build system backend
    and requirements from pyproject.toml. Fallback to
    setuptools but only if the file was not found or a build
    system was not indicated.
    r	   z setuptools.build_meta:__legacy__r   Z
setuptoolswheel)r   r   KeyError
setdefault)r   r
   r   r   r   
compat_system'   s    
r   c              
   C   s   dj f t }t| |}|i }td| || td t b}td|| dj f t }t| |}	|	|i }
tj	||
}t
|tj	|tj|
 W 5 Q R X d S )Nzget_requires_for_build_{dist}zGot build requires: %sz$Installed dynamic build dependencieszTrying to build %s in %szbuild_{dist})
r   localsgetattrloginfopip_installr   r   r   r   shutilZmovebasename)hooksenvdistdestZget_requires_nameZget_requiresZreqsZtdZ
build_namebuildfilenamesourcer   r   r   	_do_build:   s    




r-   c              	   C   sv   |p
t | }tj| |pd}t| t| t| |d |d}t "}|	|d  t
|||| W 5 Q R X d S )Nr(   r	   zbackend-pathr   )r   r   r   r   r   r   r   getr   r#   r-   )r   r(   r)   r
   r&   r'   r   r   r   r*   L   s      r*   r   z%A directory containing pyproject.toml)helpz--binaryz-b
store_trueF)actiondefaultz--sourcez-sz	--out-dirz-oz>Destination in which to save the builds relative to source dirc                 C   sP   t td | js| jsdnd | js$| js(dnd f}|D ]}t| j|| j q6d S )NZsdistr   )listfilterr,   Zbinaryr*   r   Zout_dir)argsZdistsr(   r   r   r   mainp   s    r6   __main__)NN)__doc__argparseZloggingr   r   r$   Zenvbuildr   Zwrappersr   Zdirtoolsr   r   compatr   Z	getLogger__name__r!   r   r   r   r-   r*   ArgumentParserparseradd_argumentr6   
parse_argsr   r   r   r   <module>   sP   


   PK       ! Afrd  d  0  pep517/__pycache__/colorlog.cpython-38.opt-1.pycnu [        U

    .e                     @   sf   d Z ddlZddlZzddlZW n ek
r8   dZY nX dd ZG dd dejZejfddZ	dS )	zONicer log formatting with colours.

Code copied from Tornado, Apache licensed.
    Nc                  C   sV   d} t rRttjdrRtj rRzt   t ddkr:d} W n tk
rP   Y nX | S )NFisattyZcolorsr   T)curseshasattrsysstderrr   Z	setuptermZtigetnum	Exception)color r	   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/colorlog.py_stderr_supports_color   s    r   c                   @   s>   e Zd ZdZejdejdejdejdiZ	dddZ
d	d
 ZdS )LogFormatterz&Log formatter with colour support
             TNc                 C   s   t jj| |d i | _|rt rtdp6tdp6d}dtj  k rNdk r\n n
t	|d}| j
 D ] \}}t	t||d| j|< qft	tdd| _
t }| d	 | _t  nd| _
d
| _dS )aO  
        :arg bool color: Enables color support.
        :arg string fmt: Log message format.
        It will be applied to the attributes dict of log records. The
        text between ``%(color)s`` and ``%(end_color)s`` will be colored
        depending on the level if color support is on.
        :arg dict colors: color mappings from logging level to terminal color
        code
        :arg string datefmt: Datetime format.
        Used for formatting ``(asctime)`` placeholder in ``prefix_fmt``.
        .. versionchanged:: 3.2
        Added ``fmt`` and ``datefmt`` arguments.
        )datefmtZsetafZsetf )r   r   )r   r
   r   asciiZsgr0r   F   N)logging	Formatter__init___colorsr   r   Ztigetstrr   version_infostrDEFAULT_COLORSitemsZtparm_normalZinitscrZgetmaxyx	termwidthZendwin)selfr   r   Zfg_colorlevelnocodeZscrr	   r	   r
   r   2   s*    



 
zLogFormatter.__init__c                 C   s   t |j}dj|jd |jd}|t | | jk rJd| j|t |   }nd}|j| jkrn| j|j }| j}nd }}|j| | | | S )Nz{initial}-{name}r   )initialname z  r   )	lenmessageformatZ	levelnamer"   r   r   r   r   )r   recordZmlenZ
right_textZspaceZstart_colorZ	end_colorr	   r	   r
   
formatMessage]   s    
zLogFormatter.formatMessage)TN)__name__
__module____qualname____doc__r   INFOZWARNINGZERRORZCRITICALr   r   r(   r	   r	   r	   r
   r   (   s       
+r   c                 C   s0   t  }|t  t j| t j|  d S )N)r   Z
StreamHandlerZsetFormatterr   rootZ
addHandlerZsetLevel)levelZhandlerr	   r	   r
   enable_colourful_outputo   s    r0   )
r,   r   r   r   ImportErrorr   r   r   r-   r0   r	   r	   r	   r
   <module>   s   
GPK       !     -  pep517/__pycache__/_in_process.cpython-38.pycnu [        U

    .ep                     @   s0  d Z ddlmZ ddlmZ ddlZddlZddlmZ ddlZddl	Z	ddl
Z
ddlZddlZG dd de
ZG dd	 d	e
ZG d
d de
Zdd
 Zdd Zdd Zdd ZdZdd Zdd Zdd Zd(ddZdd ZG dd  d e
ZG d!d" d"e
Zd#d$ Zddddd$hZd%d& Ze d'kr,e  dS ))ag  This is invoked in a subprocess to call the build backend hooks.

It expects:
- Command line args: hook_name, control_dir
- Environment variables:
      PEP517_BUILD_BACKEND=entry.point:spec
      PEP517_BACKEND_PATH=paths (separated with os.pathsep)
- control_dir/input.json:
  - {"kwargs": {...}}

Results:
- control_dir/output.json
  - {"return_val": ...}
    )glob)
import_moduleN)joinc                   @   s   e Zd ZdZdd ZdS )BackendUnavailablez&Raised if we cannot import the backendc                 C   s
   || _ d S N	tracebackselfr    r   B/usr/lib/python3.8/site-packages/pip/_vendor/pep517/_in_process.py__init__   s    zBackendUnavailable.__init__N__name__
__module____qualname____doc__r
   r   r   r   r   r      s   r   c                   @   s   e Zd ZdZdd ZdS )BackendInvalidz Raised if the backend is invalidc                 C   s
   || _ d S r   )message)r
   r   r   r   r   r
   %   s    zBackendInvalid.__init__Nr   r   r   r   r   r   #   s   r   c                   @   s   e Zd ZdZdS )HookMissingzARaised if a hook is missing and we are not executing the fallbackNr   r   r   r   r   r   r   r   r   )   s   r   c                 C   s<   t jt j| } t jt j|}t j| |g|kS )z5Test if a file is located within the given directory.)ospathnormcaseabspathcommonprefix)filenameZ	directoryr   r   r   contained_in-   s    r   c                     s   t jd} | r*| t j}|tjdd< t jd }|d\}}}zt| W n  t	k
rp   t
t Y nX | rt
 fdd|D std|r|d	D ]}t | q S )
zFind and load the build backendZPEP517_BACKEND_PATHNr   ZPEP517_BUILD_BACKEND:c                 3   s   | ]}t  j|V  qd S r   )r   __file__).0r   objr   r   	<genexpr>D   s   z!_build_backend.<locals>.<genexpr>z(Backend was not loaded from backend-path.)r   environgetsplitpathsepsysr   	partitionr   ImportErrorr   r   
format_excanyr   getattr)Zbackend_pathZextra_pathitemsZepZmod_path_Zobj_pathZ	path_partr   r!   r   _build_backend4   s&    
r0   c                 C   s6   t  }z
|j}W n tk
r(   g  Y S X || S dS zfInvoke the optional get_requires_for_build_wheel hook

    Returns [] if the hook is not defined.
    N)r0   get_requires_for_build_wheelAttributeErrorconfig_settingsbackendhookr   r   r   r2   P   s    

r2   c                 C   sJ   t  }z
|j}W n* tk
r:   |s*t t|| | Y S X || |S dS )zInvoke optional prepare_metadata_for_build_wheel

    Implements a fallback by building a wheel if the hook isn't defined,
    unless _allow_fallback is False in which case HookMissing is raised.
    N)r0    prepare_metadata_for_build_wheelr3   r   _get_wheel_metadata_from_wheel)metadata_directoryr5   Z_allow_fallbackr6   r7   r   r   r   r8   ^   s    

r8   ZPEP517_ALREADY_BUILT_WHEELc                 C   s@   g }|   D ]}td|}|r|| q|r4|S tddS )z6Identify the .dist-info folder inside a wheel ZipFile.z[^/\\]+-[^/\\]+\.dist-info/z#No .dist-info folder found in wheelN)Znamelistrematchappend	Exception)Zwhl_zipresr   mr   r   r   _dist_info_filest   s    rA   c              	   C   s   ddl m} | ||}ttj|td W 5 Q R X tj||}||}t|}|j	||d W 5 Q R X |d 
dd S )zBuild a wheel and extract the metadata from it.

    Fallback for when the build backend does not
    define the 'get_wheel_metadata' hook.
    r   )ZipFilewb)r   members/)ZzipfilerB   build_wheelopenr   r   r   WHEEL_BUILT_MARKERrA   Z
extractallr'   )r6   r:   r5   rB   Zwhl_basenameZwhl_fileZzipfZ	dist_infor   r   r   r9      s    

r9   c                 C   sl   | sdS t j| }t jt|ts*dS tt j|d}|sLtd dS t	|dkrdtd dS |d S )zHCheck for a wheel already built during the get_wheel_metadata hook.
    Nz*.whlz+Found wheel built marker, but no .whl files   zHFound multiple .whl files; unspecified behaviour. Will call build_wheel.r   )
r   r   dirnameisfilepjoinrH   r   r   printlen)r:   Zmetadata_parentZ	whl_filesr   r   r   _find_already_built_wheel   s    rO   c                 C   s4   t |}|r$t||  tj|S t | ||S )zInvoke the mandatory build_wheel hook.

    If a wheel was already built in the
    prepare_metadata_for_build_wheel fallback, this
    will copy it rather than rebuilding the wheel.
    )rO   shutilZcopy2r   r   basenamer0   rF   )Zwheel_directoryr5   r:   Zprebuilt_whlr   r   r   rF      s    
rF   c                 C   s6   t  }z
|j}W n tk
r(   g  Y S X || S dS r1   )r0   get_requires_for_build_sdistr3   r4   r   r   r   rR      s    

rR   c                   @   s   e Zd ZdZdS )_DummyExceptionz(Nothing should ever raise this exceptionNr   r   r   r   r   rS      s   rS   c                   @   s   e Zd ZdZdd ZdS )GotUnsupportedOperationz9For internal use when backend raises UnsupportedOperationc                 C   s
   || _ d S r   r   r	   r   r   r   r
      s    z GotUnsupportedOperation.__init__Nr   r   r   r   r   rT      s   rT   c                 C   sB   t  }z|| |W S  t|dtk
r<   tt Y nX dS )z&Invoke the mandatory build_sdist hook.UnsupportedOperationN)r0   build_sdistr.   rS   rT   r   r,   )Zsdist_directoryr5   r6   r   r   r   rV      s
    rV   c               
   C   sN  t tjdk rtd tjd } tjd }| tkrBtd|   t |  }tt|d}dd d}z|f |d	 |d
< W n t	k
r } zd|d< |j
|d
< W 5 d }~X Y n tk
r } zd|d< |j|d< W 5 d }~X Y nR t
k
r } zd|d< |j
|d
< W 5 d }~X Y n tk
r2   d|d< Y nX tj|t|ddd d S )N   z"Needs args: hook_name, control_dirrI      zUnknown hook: %sz
input.jsonF)unsupported
return_valkwargsrZ   TZ
no_backendr   Zbackend_invalidZ
backend_errorrY   Zhook_missingzoutput.json)indent)rN   r)   argvexit
HOOK_NAMESglobalscompatZ	read_jsonrL   r   r   r   r   rT   r   Z
write_json)Z	hook_nameZcontrol_dirr7   Z
hook_inputZjson_outer   r   r   main   s.    




rc   __main__)N)!r   r   	importlibr   r   Zos.pathr   rL   r;   rP   r)   r   ra   r>   r   r   r   r   r0   r2   r8   rH   rA   r9   rO   rF   rR   rS   rT   rV   r_   rc   r   r   r   r   r   <module>   sF   

	
PK       ! 9    &  pep517/__pycache__/meta.cpython-38.pycnu [        U

    .e	     