ZzddlmZ W n e	k
rX   ddl
ZY nX zddlmZ W n  e	k
r   ddl
mZ Y nX ddlmZ ddlmZmZ ddlmZmZmZ ddlmZmZmZ eeZd	d
 Zddd
ZefddZdd Z e! Z"e"j#ddd e"j#dddd dd Z$edkr>e$  dS )z2Build metadata for a project using PEP 517 hooks.
    N)Path   )BuildEnvironment)Pep517HookCallerquiet_subprocess_runner)tempdirmkdir_pdir_to_zipfile)validate_systemload_system
compat_systemc              
   C   s   |  i }td| || td t J}td| | |i }tj||}t	
|tj|tj| W 5 Q R X d S )NzGot build requires: %sz$Installed dynamic build dependencieszTrying to build metadata in %s)Zget_requires_for_build_wheelloginfopip_installr   Z prepare_metadata_for_build_wheelospathjoinshutilZmovebasename)hooksenvdestZreqsZtdfilenamesource r   ;/usr/lib/python3.8/site-packages/pip/_vendor/pep517/meta.py
_prep_meta   s    


r   .c              
   C   s   |p
t | }tj| |pd}t| t| t| |d |d}|t	2 t
  }||d  t||| W 5 Q R X W 5 Q R X d S )NZdistz
build-backendzbackend-pathZrequires)
r   r   r   r   r   r
   r   getZsubprocess_runnerr   r   r   r   )
source_dirr   systemr   r   r   r   r   build)   s      r!   c              
   C   s0   t   }| |d t|W  5 Q R  S Q R X d S )N)r   )r   r	   )builderout_dirr   r   r   build_as_zip8   s    
r$   c                 C   s:   t j| } t| }tjt| |d}tt|}t	
|S )z
    Given a source directory (root) of a package,
    return an importlib.metadata.Distribution object
    with metadata build from that package.
    )r   r    )r   r   
expanduserr   	functoolspartialr!   r   r$   imp_metaZPathDistribution)rootr    r"   r   r   r   r   load>   s
    r*   r   z%A directory containing pyproject.toml)helpz	--out-dirz-oz>Destination in which to save the builds relative to source dirc                  C   s   t  } t| j| j d S )N)parser
parse_argsr!   r   r#   )argsr   r   r   mainV   s    r/   __main__)r   NN)%__doc__argparseZloggingr   r   r&   importlib.metadataZmetadatar(   ImportErrorZimportlib_metadataZzipfiler   ZzippZenvbuildr   Zwrappersr   r   Zdirtoolsr   r   r	   r!   r
   r   r   Z	getLogger__name__r
   r   r$   r*   ArgumentParserr,   add_argumentr/   r   r   r   r   <module>   sF   


 
PK       ! p      0  pep517/__pycache__/__init__.cpython-38.opt-1.pycnu [        U

    .eT                      @   s   d Z dZdS )z6Wrappers to build Python packages using PEP 517 hooks
z0.7.0N)__doc____version__ r   r   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/__init__.py<module>   s   PK       ! M-'  '  *  pep517/__pycache__/wrappers.cpython-38.pycnu [        U

    .eg)                     @   s  d dl Z d dlmZ d dlZd dlmZmZmZ d dl	Z	d dl
mZmZm
Z
 d dlZd dlmZ ddlmZ eeeedZed	d
 ZG dd deZG d
d deZG dd deZG dd deZdddZdddZdd ZG dd deZG dd de j Z!dS )    N)contextmanager)dirnameabspathjoin)
check_callcheck_outputSTDOUT)mkdtemp   )compatz_in_process.pyc               	   c   s"   t  } z
| V  W 5 t|  X d S N)r	   shutilZrmtree)td r   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/wrappers.pytempdir   s    
r   c                   @   s   e Zd ZdZdd ZdS )BackendUnavailablezEWill be raised if the backend cannot be imported in the hook process.c                 C   s
   || _ d S r   	tracebackselfr   r   r   r   __init__   s    zBackendUnavailable.__init__N__name__
__module____qualname____doc__r   r   r   r   r   r      s   r   c                   @   s   e Zd ZdZdd ZdS )BackendInvalidz)Will be raised if the backend is invalid.c                 C   s   || _ || _|| _d S r   backend_namebackend_pathmessage)r   r   r    r!   r   r   r   r       s    zBackendInvalid.__init__Nr   r   r   r   r   r      s   r   c                       s    e Zd ZdZ fddZ  ZS )HookMissingz Will be raised on missing hooks.c                    s   t t| | || _d S r   )superr"   r   	hook_name)r   r$   	__class__r   r   r   (   s    zHookMissing.__init__)r   r   r   r   r   
__classcell__r   r   r%   r   r"   &   s   r"   c                   @   s   e Zd ZdZdd ZdS )UnsupportedOperationzDMay be raised by build_sdist if the backend indicates that it can't.c                 C   s
   || _ d S r   r   r   r   r   r   r   /   s    zUnsupportedOperation.__init__Nr   r   r   r   r   r(   -   s   r(   c                 C   s*   t j }|r|| t| ||d dS )z5The default method of calling the wrapper subprocess.)cwdenvN)osenvironcopyupdater   cmdr)   
extra_environr*   r   r   r   default_subprocess_runner3   s    

r2   c                 C   s,   t j }|r|| t| ||td dS )zDA method of calling the wrapper subprocess while suppressing output.)r)   r*   stderrN)r+   r,   r-   r.   r   r   r/   r   r   r   quiet_subprocess_runner<   s    

r4   c                 C   sn   t j|rtdt j| }t jt j||}t j|}t j|}t j||g|krjtd|S )zNormalise and check a backend path.

    Ensure that the requested backend path is specified as a relative path,
    and resolves to a location under the given source tree.

    Return an absolute version of the requested path.
    zpaths must be relativez paths must be inside source tree)	r+   pathisabs
ValueErrorr   normpathr   normcasecommonprefix)Zsource_treeZ	requestedZ
abs_sourceZ
abs_requestedZnorm_sourceZnorm_requestedr   r   r   norm_and_checkE   s    r;   c                   @   s`   e Zd ZdZdddZedd ZdddZdd
dZddd
Z	dddZ
dddZdd ZdS )Pep517HookCallerae  A wrapper around a source directory to be built with a PEP 517 backend.

    source_dir : The path to the source directory, containing pyproject.toml.
    build_backend : The build backend spec, as per PEP 517, from
        pyproject.toml.
    backend_path : The backend path, as per PEP 517, from pyproject.toml.
    runner : A callable that invokes the wrapper subprocess.

    The 'runner', if provided, must expect the following:
        cmd : a list of strings representing the command and arguments to
            execute, as would be passed to e.g. 'subprocess.check_call'.
        cwd : a string representing the working directory that must be
            used for the subprocess. Corresponds to the provided source_dir.
        extra_environ : a dict mapping environment variable names to values
            which must be set for the subprocess execution.
    Nc                    sB   |d krt }t| _| _|r2 fdd|D }| _| _d S )Nc                    s   g | ]}t  j|qS r   )r;   
source_dir).0pr   r   r   
<listcomp>{   s    z-Pep517HookCaller.__init__.<locals>.<listcomp>)r2   r   r=   
build_backendr    _subprocess_runner)r   r=   rB   r    runnerr   r@   r   r   n   s    

zPep517HookCaller.__init__c                 c   s   | j }|| _ dV  || _ dS )z\A context manager for temporarily overriding the default subprocess
        runner.
        N)rC   )r   rD   prevr   r   r   subprocess_runner   s    z"Pep517HookCaller.subprocess_runnerc                 C   s   |  dd|iS )aG  Identify packages required for building a wheel

        Returns a list of dependency specifications, e.g.:
            ["wheel >= 0.25", "setuptools"]

        This does not include requirements specified in pyproject.toml.
        It returns the result of calling the equivalently named hook in a
        subprocess.
        get_requires_for_build_wheelconfig_settings
_call_hookr   rH   r   r   r   rG      s    
 z-Pep517HookCaller.get_requires_for_build_wheelTc                 C   s   |  dt|||dS )aq  Prepare a *.dist-info folder with metadata for this project.

        Returns the name of the newly created folder.

        If the build backend defines a hook with this name, it will be called
        in a subprocess. If not, the backend will be asked to build a wheel,
        and the dist-info extracted from that (unless _allow_fallback is
        False).
         prepare_metadata_for_build_wheel)metadata_directoryrH   _allow_fallbackrJ   r   )r   rM   rH   rN   r   r   r   rL      s
    z1Pep517HookCaller.prepare_metadata_for_build_wheelc                 C   s(   |dk	rt |}| dt |||dS )av  Build a wheel from this project.

        Returns the name of the newly created file.

        In general, this will call the 'build_wheel' hook in the backend.
        However, if that was previously called by
        'prepare_metadata_for_build_wheel', and the same metadata_directory is
        used, the previously built wheel will be copied to wheel_directory.
        Nbuild_wheel)wheel_directoryrH   rM   )r   rJ   )r   rQ   rH   rM   r   r   r   rP      s    zPep517HookCaller.build_wheelc                 C   s   |  dd|iS )a<  Identify packages required for building a wheel

        Returns a list of dependency specifications, e.g.:
            ["setuptools >= 26"]

        This does not include requirements specified in pyproject.toml.
        It returns the result of calling the equivalently named hook in a
        subprocess.
        get_requires_for_build_sdistrH   rI   rK   r   r   r   rR      s    
 z-Pep517HookCaller.get_requires_for_build_sdistc                 C   s   |  dt||dS )zBuild an sdist from this project.

        Returns the name of the newly created file.

        This calls the 'build_sdist' backend hook in a subprocess.
        build_sdist)sdist_directoryrH   rO   )r   rT   rH   r   r   r   rS      s    zPep517HookCaller.build_sdistc           	   
   C   s@