 j | jf S r   )r   r   r   r   r   r   
with_hostmaskJ  s    z_BaseNetwork.with_hostmaskc                 C   s   t | jt | j d S )z&Number of hosts in the current subnet.r&   )r   rx   r   r   r   r   r   
num_addressesN  s    z_BaseNetwork.num_addressesc                 C   s   dt | f }t|d S )Nz%%200s has no associated address classr   r   r   r   r   r   S  s    z_BaseNetwork._address_classc                 C   s   | j S r   )r}   r   r   r   r   r   [  s    z_BaseNetwork.prefixlenc                 c   s  | j |j kstd| |f t|ts2td| || sLtd|| f || krXdS |d|j|jf }| 	 \}}||kr||kr||r|V  |	 \}}qz||r|V  |	 \}}qzt
d|||f qz||kr|V  n"||kr|V  nt
d|||f dS )a  Remove an address from a larger block.

        For example:

            addr1 = ip_network('192.0.2.0/28')
            addr2 = ip_network('192.0.2.1/32')
            list(addr1.address_exclude(addr2)) =
                [IPv4Network('192.0.2.0/32'), IPv4Network('192.0.2.2/31'),
                 IPv4Network('192.0.2.4/30'), IPv4Network('192.0.2.8/29')]

        or IPv6:

            addr1 = ip_network('2001:db8::1/32')
            addr2 = ip_network('2001:db8::1/128')
            list(addr1.address_exclude(addr2)) =
                [ip_network('2001:db8::1/128'),
                 ip_network('2001:db8::2/127'),
                 ip_network('2001:db8::4/126'),
                 ip_network('2001:db8::8/125'),
                 ...
                 ip_network('2001:db8:8000::/33')]

        Args:
            other: An IPv4Network or IPv6Network object of the same type.

        Returns:
            An iterator of the IPv(4|6)Network objects which is self
            minus other.

        Raises:
            TypeError: If self and other are of differing address
              versions, or if other is not a network object.
            ValueError: If other is not completely contained by self.

        rh   z%s is not a network objectz%s not contained in %sNr   z3Error performing exclusion: s1: %s s2: %s other: %s)r|   rk   r   r   	subnet_ofrG   r   r   r   ry   r   )r.   r/   s1s2r   r   r   address_exclude_  s@    $ 




z_BaseNetwork.address_excludec                 C   s`   | j |j krtd| |f | j|jk r,dS | j|jkr<dS | j|jk rLdS | j|jkr\dS dS )a  Compare two IP objects.

        This is only concerned about the comparison of the integer
        representation of the network addresses.  This means that the
        host bits aren't considered at all in this method.  If you want
        to compare host bits, you can easily enough do a
        'HostA._ip < HostB._ip'

        Args:
            other: An IP object.

        Returns:
            If the IP versions of self and other are the same, returns:

            -1 if self < other:
              eg: IPv4Network('192.0.2.0/25') < IPv4Network('192.0.2.128/25')
              IPv6Network('2001:db8::1000/124') <
                  IPv6Network('2001:db8::2000/124')
            0 if self == other
              eg: IPv4Network('192.0.2.0/24') == IPv4Network('192.0.2.0/24')
              IPv6Network('2001:db8::1000/124') ==
                  IPv6Network('2001:db8::1000/124')
            1 if self > other
              eg: IPv4Network('192.0.2.128/25') > IPv4Network('192.0.2.0/25')
                  IPv6Network('2001:db8::2000/124') >
                      IPv6Network('2001:db8::1000/124')

          Raises:
              TypeError if the IP versions are different.

        r   r{   r&   r   )r|   rk   r   r   r-   r   r   r   compare_networks  s    ! z_BaseNetwork.compare_networksc                 C   s   | j | j| jfS )zNetwork-only key function.

        Returns an object that identifies this address' network and
        netmask. This function is a suitable "key" argument for sorted()
        and list.sort().

        )r|   r   r   r   r   r   r   r     s    z_BaseNetwork._get_networks_keyr&   Nc           	      c   s   | j | jkr| V  dS |dk	rJ|| j k r0td|dkr@td|| j  }|dk rZtd| j | }|| jkr~td|| f t| j}t| jd }t| jd |? }t|||D ]}| ||f}|V  qdS )a  The subnets which join to make the current subnet.

        In the case that self contains only one IP
        (self._prefixlen == 32 for IPv4 or self._prefixlen == 128
        for IPv6), yield an iterator with just ourself.

        Args:
            prefixlen_diff: An integer, the amount the prefix length
              should be increased by. This should not be set if
              new_prefix is also set.
            new_prefix: The desired new prefix length. This must be a
              larger number (smaller prefix) than the existing prefix.
              This should not be set if prefixlen_diff is also set.

        Returns:
            An iterator of IPv(4|6) objects.

        Raises:
            ValueError: The prefixlen_diff is too small or too large.
                OR
            prefixlen_diff and new_prefix are both set or new_prefix
              is a smaller number than the current prefix (smaller
              number means a larger network)

        Nznew prefix must be longerr&   (cannot set prefixlen_diff and new_prefixr   zprefix length diff must be > 0z0prefix length diff %d is invalid for netblock %s)	r}   rm   rG   r   r   rx   r   r*   r   )	r.   prefixlen_diff
new_prefix
new_prefixlenr'   r(   r)   Znew_addrZcurrentr   r   r   ry     s2    



 
z_BaseNetwork.subnetsc                 C   s   | j dkr| S |dk	rB|| j kr(td|dkr8td| j | }| j| }|dk rftd| j|f | t| jt| j|> @ |fS )a  The supernet containing the current network.

        Args:
            prefixlen_diff: An integer, the amount the prefix length of
              the network should be decreased by.  For example, given a
              /24 network and a prefixlen_diff of 3, a supernet with a
              /21 netmask is returned.

        Returns:
            An IPv4 network object.

        Raises:
            ValueError: If self.prefixlen - prefixlen_diff < 0. I.e., you have
              a negative prefix length.
                OR
            If prefixlen_diff and new_prefix are both set or new_prefix is a
              larger number than the current prefix (larger number means a
              smaller network)

        r   Nznew prefix must be shorterr&   r   z;current prefixlen is %d, cannot have a prefixlen_diff of %d)r}   rG   r   r   r   r   r   )r.   r   r   r   r   r   r   rs     s&    



z_BaseNetwork.supernetc                 C   s   | j jo| jjS zTest if the address is reserved for multicast use.

        Returns:
            A boolean, True if the address is a multicast address.
            See RFC 2373 2.7 for details.

        )r   is_multicastrx   r   r   r   r   r   A  s    	z_BaseNetwork.is_multicastc                 C   s^   z4| j |j krtd| ||j| jko2|j| jkW S  tk
rX   td| |f Y nX d S )Nrh   z3Unable to test subnet containment between %s and %s)r|   rk   r   rx   r~   )ar
   r   r   r   
_is_subnet_ofM  s    
z_BaseNetwork._is_subnet_ofc                 C   s   |  | |S )z1Return True if this network is a subnet of other.r   r-   r   r   r   r   Y  s    z_BaseNetwork.subnet_ofc                 C   s   |  || S )z3Return True if this network is a supernet of other.r   r-   r   r   r   supernet_of]  s    z_BaseNetwork.supernet_ofc                 C   s   | j jo| jjS )Test if the address is otherwise IETF reserved.

        Returns:
            A boolean, True if the address is within one of the
            reserved IPv6 Network ranges.

        )r   is_reservedrx   r   r   r   r   r   a  s    	z_BaseNetwork.is_reservedc                 C   s   | j jo| jjS zTest if the address is reserved for link-local.

        Returns:
            A boolean, True if the address is reserved per RFC 4291.

        )r   
is_link_localrx   r   r   r   r   r   m  s    z_BaseNetwork.is_link_localc                 C   s   | j jo| jjS )zTest if this address is allocated for private networks.

        Returns:
            A boolean, True if the address is reserved per
            iana-ipv4-special-registry or iana-ipv6-special-registry.

        )r   
is_privaterx   r   r   r   r   r   x  s    	z_BaseNetwork.is_privatec                 C   s   | j  S )zTest if this address is allocated for public networks.

        Returns:
            A boolean, True if the address is not reserved per
            iana-ipv4-special-registry or iana-ipv6-special-registry.

        r   r   r   r   r   	is_global  s    	z_BaseNetwork.is_globalc                 C   s   | j jo| jjS )Test if the address is unspecified.

        Returns:
            A boolean, True if this is the unspecified address as defined in
            RFC 2373 2.5.2.

        )r   is_unspecifiedrx   r   r   r   r   r     s    	z_BaseNetwork.is_unspecifiedc                 C   s   | j jo| jjS )Test if the address is a loopback address.

        Returns:
            A boolean, True if the address is a loopback address as defined in
            RFC 2373 2.5.3.

        )r   is_loopbackrx   r   r   r   r   r     s    	z_BaseNetwork.is_loopback)r&   N)r&   N)(r;   r<   r=   rB   r   r   r   r   r   r   r4   r0   r   r   r   r   rx   r   r   r   r   r   r   r   r   r   r   ry   rs   r   staticmethodr   r   r   r   r   r   r   r   r   r   r   r   r   r     sf   









K0

5
(








r   c                
   @   s   e Zd ZdZdZdZde d ZedZ	eddd	d
ddd
ddg	Z
eZi Zdd Z
edd Zedd Zedd Zedd Zdd Zdd Zedd Zed d! Zd"S )#r   zyBase IPv4 object.

    The following methods are used by IPv4 objects in both single IP
    addresses and networks.

    r   r   r   r&   
0123456789                     r   r   c                 C   s   t | S r   r   r   r   r   r   r     s    z$_BaseV4._explode_shorthand_ip_stringc                 C   sn   || j krdt|tr|}n.z| |}W n tk
rF   | |}Y nX t| |}||f| j |< | j | S a  Make a (netmask, prefix_len) tuple from the given argument.

        Argument can be:
        - an integer (the prefix length)
        - a string representing the prefix length (e.g. "24")
        - a string representing the prefix netmask (e.g. "255.255.255.0")
        )_netmask_cacher   r   r   rC   r   rD   r   r   argr   r   r   r   r   
_make_netmask  s    	

z_BaseV4._make_netmaskc              
   C   sz   |st d|d}t|dkr.t d| ztt| j|dW S  tk
rt } zt d||f W 5 d}~X Y nX dS )a  Turn the given IP string into an integer for comparison.

        Args:
            ip_str: A string, the IP ip_str.

        Returns:
            The IP ip_str as an integer.

        Raises:
            AddressValueError: if ip_str isn't a valid IPv4 Address.

        Address cannot be empty.r   zExpected 4 octets in %rr   %s in %rN)r@   rX   rY   r   map_parse_octetrG   )r   r   Zoctetsexcr   r   r   r     s    

 z_BaseV4._ip_int_from_stringc                 C   s   |st d| j|s(d}t || t|dkrDd}t || t|d}|dkrr|d dkrrd	}t || |d
krt d| |S )a  Convert a decimal octet into an integer.

        Args:
            octet_str: A string, the number to parse.

        Returns:
            The octet as an integer.

        Raises:
            ValueError: if the octet isn't strictly a decimal from [0..255].

        zEmpty octet not permittedz#Only decimal digits permitted in %r   z$At most 3 characters permitted in %r
      r   0z3Ambiguous (octal/decimal) value in %r not permittedr   zOctet %d (> 255) not permitted)rG   r   r   rY   r   )r   Z	octet_strr   Z	octet_intr   r   r   r     s    
z_BaseV4._parse_octetc                 C   s   d dd t|ddD S )zTurns a 32-bit integer into dotted decimal notation.

        Args:
            ip_int: An integer, the IP address.

        Returns:
            The IP address as a string in dotted decimal notation.

        r   c                 s   s0   | ](}t t|tr"td |d n|V  qdS )r   r   N)rW   r   rF   r	   r
   r   r   r   r   	<genexpr>%  s   z._BaseV4._string_from_ip_int.<locals>.<genexpr>r   r   )joinr   )r   r   r   r   r   r     s    

z_BaseV4._string_from_ip_intc                    sj   | d}z fddtt|D }W n tk
r<   Y dS X t|t|krRdS |d |d k rfdS dS )zTest if the IP string is a hostmask (rather than a netmask).

        Args:
            ip_str: A string, the potential hostmask.

        Returns:
            A boolean, True if the IP string is a hostmask.

        r   c                    s   g | ]}| j kr|qS r   )_valid_mask_octetsr   r   r   r   r   r   6  s     
 z(_BaseV4._is_hostmask.<locals>.<listcomp>Fr   r{   T)rX   r   r   rG   rY   )r.   r   rf   partsr   r   r   _is_hostmask*  s    

z_BaseV4._is_hostmaskc                 C   s&   t | dddd }d|d S )zReturn the reverse DNS pointer name for the IPv4 address.

        This implements the method described in RFC1035 3.5.

        r   Nr{   z
.in-addr.arpa)rW   rX   r  )r.   Zreverse_octetsr   r   r   r   ?  s    z_BaseV4._reverse_pointerc                 C   s   | j S r   rm   r   r   r   r   
max_prefixlenH  s    z_BaseV4.max_prefixlenc                 C   s   | j S r   r   r   r   r   r   rl   L  s    z_BaseV4.versionN)r;   r<   r=   rB   r>   r|   
IPV4LENGTHrn   	frozensetr   r  rm   r   r   r   r   r   r   r   r  r   r   r
  rl   r   r   r   r   r     s.   


$
	
r   c                   @   s|   e Zd ZdZdZdd Zedd Zedd Zed	d
 Z	edd Z
ed
d Zedd Zedd Z
edd ZdS )rD   z/Represent and manipulate single IPv4 Addresses.r^   __weakref__c                 C   sx   t |tr| | || _dS t |trL| |d t|}t|d| _dS t|}d|krht	d| | 
|| _dS )a  
        Args:
            address: A string or integer representing the IP

              Additionally, an integer can be passed, so
              IPv4Address('192.0.2.1') == IPv4Address(3221225985).
              or, more generally
              IPv4Address(int(IPv4Address('192.0.2.1'))) ==
                IPv4Address('192.0.2.1')

        Raises:
            AddressValueError: If ipaddress isn't a valid IPv4 address.

        Nr   r   rV   Unexpected '/' in %rr   r   r   r^   rF   r   r   r   rW   r@   r   r.   rI   ZbvsZaddr_strr   r   r   r   W  s    


zIPv4Address.__init__c                 C   s
   t | jS z*The binary representation of this address.)rT   r^   r   r   r   r   packed{  s    zIPv4Address.packedc                 C   s   | | j jkS )zTest if the address is otherwise IETF reserved.

         Returns:
             A boolean, True if the address is within the
             reserved IPv4 Network range.

        )
_constants_reserved_networkr   r   r   r   r     s    	zIPv4Address.is_reservedc                    s   t  fdd jjD S )zTest if this address is allocated for private networks.

        Returns:
            A boolean, True if the address is reserved per
            iana-ipv4-special-registry.

        c                 3   s   | ]} |kV  qd S r   r   r   ro   r   r   r   r    s     z)IPv4Address.is_private.<locals>.<genexpr>anyr  _private_networksr   r   r   r   r     s    	zIPv4Address.is_privatec                 C   s   | | j jko| j S r   )r  _public_networkr   r   r   r   r   r     s    zIPv4Address.is_globalc                 C   s   | | j jkS )zTest if the address is reserved for multicast use.

        Returns:
            A boolean, True if the address is multicast.
            See RFC 3171 for details.

        r  _multicast_networkr   r   r   r   r     s    	zIPv4Address.is_multicastc                 C   s   | | j jkS )zTest if the address is unspecified.

        Returns:
            A boolean, True if this is the unspecified address as defined in
            RFC 5735 3.

        )r  _unspecified_addressr   r   r   r   r     s    	zIPv4Address.is_unspecifiedc                 C   s   | | j jkS )zTest if the address is a loopback address.

        Returns:
            A boolean, True if the address is a loopback per RFC 3330.

        )r  _loopback_networkr   r   r   r   r     s    zIPv4Address.is_loopbackc                 C   s   | | j jkS )zTest if the address is reserved for link-local.

        Returns:
            A boolean, True if the address is link-local per RFC 3927.

        r  _linklocal_networkr   r   r   r   r     s    zIPv4Address.is_link_localN)r;   r<   r=   rB   r>   r   r   r  r   r   r   r   r   r   r   r   r   r   r   rD   Q  s&   $










	rD   c                   @   sj   e Zd Zdd Zdd Zdd Zdd Zd	d
 Zej	Z	e
dd Ze
d
d Ze
dd Z
e
dd ZdS )rO   c                 C   s   t |ttfr2t| | t| j| _| j| _	d S t |t
rt| |d  t|dkrht|d | _	n| j| _	t|dd| _| jj
| _
| jj| _d S t|}t| |d  t|dd| _| jj	| _	| jj
| _
| jj| _d S Nr   r&   F)rM   )r   rF   r   rD   r   rK   r^   r   rm   r}   tuplerY   r   r   r   r[   r.   rI   rZ   r   r   r   r     s(    




zIPv4Interface.__init__c                 C   s   d|  | j| jjf S r   r   r^   r   r   r   r   r   r   r     s    zIPv4Interface.__str__c                 C   sF   t | |}|r|tkr|S z| j|jkW S  tk
r@   Y dS X d S r   )rD   r0   r1   r   r~   r.   r/   Z
address_equalr   r   r   r0     s    zIPv4Interface.__eq__c                 C   sR   t | |}|tkrtS z| j|jk p4| j|jko4|W S  tk
rL   Y dS X d S r   )rD   r4   r1   r   r~   r.   r/   Zaddress_lessr   r   r   r4     s    zIPv4Interface.__lt__c                 C   s   | j | jA t| jjA S r   r^   r}   r   r   r   r   r   r   r   r    