                 @   s   e Zd ZdZdZdS )r   aA  Context manager for temporarily redirecting stdout to another file.

        # How to send help() to stderr
        with redirect_stdout(sys.stderr):
            help(dir)

        # How to write help() to a file
        with open('help.txt', 'w') as f:
            with redirect_stdout(f):
                help(pow)
    stdoutNr/   r0   r1   r2   r^   r   r   r   r   r     s   c                   @   s   e Zd ZdZdZdS )r   zCContext manager for temporarily redirecting stderr to another file.stderrNrf   r   r   r   r   r     s   c                   @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r
   a?  Context manager to suppress specified exceptions

    After the exception is suppressed, execution proceeds with the next
    statement following the with statement.

         with suppress(FileNotFoundError):
             os.remove(somefile)
         # Execution still resumes here if the file was already removed
    c                 G   s
   || _ d S r   )_exceptions)r'   
exceptionsr   r   r   rG   )  s    zsuppress.__init__c                 C   s   d S r   r   r&   r   r   r   r(   ,  s    zsuppress.__enter__c                 C   s   |d k	ot || jS r   )
issubclassrh   ra   r   r   r   r,   /  s    
zsuppress.__exit__NrY   r   r   r   r   r
     s   
r   c                    s    fdd}|S )Nc                    s4   | j }||krd S |d ks*| kr$q*|} q || _ d S r   )__context__)new_excold_excexc_context	frame_excr   r   _fix_exception_context@  s    z3_make_context_fixer.<locals>._fix_exception_contextr   )rp   rq   r   ro   r   _make_context_fixer?  s    
rr   c                 C   s<   z| d j }| d W n  tk
r6   || d _  Y nX d S )NrL   )rk   
BaseException)exc_details	fixed_ctxr   r   r   _reraise_with_existing_contextO  s    

rv   c                 C   s   dd S )Nc                 S   s   d S r   r   )rl   rm   r   r   r   <lambda>[      z%_make_context_fixer.<locals>.<lambda>r   ro   r   r   r   rr   Z  s    c                 C   s   | \}}}t d d S )Nz!raise exc_type, exc_value, exc_tb)exec)rt   r)   r*   Zexc_tbr   r   r   rv   _  s    
)InstanceTypec                 C   s   t | }|tkr| jS |S r   )rE   rz   rH   )objZobj_typer   r   r   	_get_typek  s    r|   c                   @   sX   e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	dd Z
dd Zdd ZdS )r
   a  Context manager for dynamic management of a stack of exit callbacks

    For example:

        with ExitStack() as stack:
            files = [stack.enter_context(open(fname)) for fname in filenames]
            # All opened files will automatically be closed at the end of
            # the with statement, even if attempts to open files later
            # in the list raise an exception

    c                 C   s   t  | _d S r   )r   _exit_callbacksr&   r   r   r   rG     s    zExitStack.__init__c                 C   s   t |  }| j|_t | _|S )z?Preserve the context stack by transferring it to a new instance)rE   r}   r   )r'   	new_stackr   r   r   pop_all  s    
zExitStack.pop_allc                    s"    fdd} |_ | | dS )z:Helper to correctly register callbacks to __exit__ methodsc                     s    f|  S r   r   )rt   cmcm_exitr   r   
_exit_wrapper  s    z.ExitStack._push_cm_exit.<locals>._exit_wrapperN)__self__push)r'   r   r   r   r   r   r   
_push_cm_exit  s    zExitStack._push_cm_exitc                 C   sD   t |}z
|j}W n  tk
r2   | j| Y nX | || |S )a  Registers a callback with the standard __exit__ method signature

        Can suppress exceptions the same way __exit__ methods can.

        Also accepts any object with an __exit__ method (registering a call
        to the method instead of the object itself)
        )r|   r,   r   r}   r   r   )r'   exit_cb_typeexit_methodr   r   r   r     s    

zExitStack.pushc                    s$    fdd}|_ | | S )z\Registers an arbitrary callback and arguments.

        Cannot suppress exceptions.
        c                    s     d S r   r   )r)   rS   tbr<   callbackr=   r   r   r     s    z)ExitStack.callback.<locals>._exit_wrapper)__wrapped__r   )r'   r   r<   r=   r   r   r   r   r     s    
zExitStack.callbackc                 C   s(   t |}|j}||}| || |S )zEnters the supplied context manager

        If successful, also pushes its __exit__ method as a callback and
        returns the result of the __enter__ method.
        )r|   r,   r(   r   )r'   r   _cm_type_exitr   r   r   r   
enter_context  s
    
zExitStack.enter_contextc                 C   s   |  ddd dS )z$Immediately unwind the context stackN)r,   r&   r   r   r   rX     s    zExitStack.closec                 C   s   | S r   r   r&   r   r   r   r(     s    zExitStack.__enter__c           	      G   s   |d d k	}t  d }t|}d}d}| jr| j }z|| rNd}d}d}W q(   t  }||d |d  d}|}Y q(X q(|rt| |o|S )Nr   rL   FT)NNN)rP   rQ   rr   r}   r`   rv   )	r'   rt   received_excrp   rq   suppressed_exc
pending_raisecbnew_exc_detailsr   r   r   r,     s(    
zExitStack.__exit__N)
r/   r0   r1   r2   rG   r   r   r   r   r   rX   r(   r,   r   r   r   r   r
   s  s   

c                       s8   e Zd ZdZ fddZdd Zdd Zdd	 Z  ZS )
r   z+Backwards compatibility alias for ExitStackc                    s   t dt tt|   d S )Nz*ContextStack has been renamed to ExitStack)r6   r7   r8   superr   rG   r&   rH   r   r   rG     s    zContextStack.__init__c                 C   s
   |  |S r   )r   )r'   r   r   r   r   
register_exit  s    zContextStack.register_exitc                 O   s   | j |f||S r   )r   )r'   r   r<   r=   r   r   r   register  s    zContextStack.registerc                 C   s   |   S r   )r   r&   r   r   r   preserve  s    zContextStack.preserve)	r/   r0   r1   r2   rG   r   r   r   
__classcell__r   r   r   r   r     s
   c                   @   s*   e Zd ZdZd	ddZdd Zdd ZdS )
r   aM  Context manager that does no additional processing.
    Used as a stand-in for a normal context manager, when a particular
    block of code is only sometimes used with a normal context manager:
    cm = optional_cm if condition else nullcontext()
    with cm:
        # Perform operation, using optional_cm if condition is True
    Nc                 C   s
   || _ d S r   enter_result)r'   r   r   r   r   rG     s    znullcontext.__init__c                 C   s   | j S r   r   r&   r   r   r   r(     s    znullcontext.__enter__c                 G   s   d S r   r   )r'   excinfor   r   r   r,     s    znullcontext.__exit__)NrY   r   r   r   r   r     s   
)$r2   r3   rP   r6   collectionsr   	functoolsr   __all__version_infor   Z_abc_ABCABCMetaobjectr   r%   r   r	   rB   r   r   rZ   r   r   r
   rN   rr   rv   typesrz   ImportErrorrE   r|   r
   r   r   r   r   r   r   <module>   sT      

(H"

qPK       ! Zd    $  __pycache__/ipaddress.cpython-38.pycnu [        U

    .e7                    @   sl  d Z ddlmZ ddlZddlZdZefZzeefZW n e	k
rJ   Y nX ze
ZW n$ e	k
rx   eZe
eksttY nX ddkrdd Zndd Zz
ejZW n ek
r   dd	 ZY nX d
d Zeedrd
d Zndd ZdNddZG dd deZdZdZG dd deZG dd deZdd ZdOddZd d! Z d"d# Z!d$d% Z"d&d' Z#d(d) Z$d*d+ Z%d,d- Z&d.d/ Z'd0d1 Z(d2d3 Z)G d4d5 d5eZ*G d6d7 d7e*Z+G d8d9 d9e*Z,G d:d; d;eZ-G d<d= d=e-e+Z.G d>d? d?e.Z/G d@dA dAe-e,Z0G dBdC dCeZ1e1e._2G dDdE dEeZ3G dFdG dGe3e+Z4G dHdI dIe4Z5G dJdK dKe3e,Z6G dLdM dMeZ7e7e4_2dS )PzA fast, lightweight IPv4/IPv6 manipulation library in Python.

This library is used to create/poke/manipulate IPv4 and IPv6 addresses
and networks.

    )unicode_literalsNz1.0.22c                 C   s   | S N Zbytr   r   9/usr/lib/python3.8/site-packages/pip/_vendor/ipaddress.py_compat_bytes_to_byte_vals   s    r   c                 C   s   dd | D S )Nc                 S   s   g | ]}t d |d qS )   !Br   )structunpack.0br   r   r   
<listcomp>#   s     z._compat_bytes_to_byte_vals.<locals>.<listcomp>r   r   r   r   r   r   "   s    c                 C   s8   |dkst d}| D ]}t|ts&t |d> | }q|S )Nbigr      )AssertionError
isinstance_compat_int_types)Zbytvals	endianessresZbvr   r   r   _compat_int_from_byte_vals'   s    r   c                 C   s   t | tst|dkst|dkrH| dk s2| dkr<tdtd| S |dkr| dk sd| dd	 krntd
td| d? | d
@ S t d S )Nr      r   l        z(integer out of range for 'I' format codes   !I         z)integer out of range for 'QQ' format codes   !QQ@   l    )r   r   r   r	   errorpackNotImplementedError)ZintvalZlengthr   r   r   r   _compat_to_bytes0   s    

r   
bit_lengthc                 C   s   |   S r   )r    )ir   r   r   _compat_bit_lengthA   s    r"   c                 C   s&   t  D ]}| |? dkr|  S qd S Nr   )	itertoolscount)r!   r   r   r   r   r"   D   s       c                 c   s,   |dkst | }||k r(|V  ||7 }qd S r#   )r   )startendstepr!   r   r   r   
_compat_rangeJ   s
    r*   c                   @   s@   e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	dS )_TotalOrderingMixinr   c                 C   s   t d S r   r   selfotherr   r   r   __eq__Y   s    z_TotalOrderingMixin.__eq__c                 C   s   |  |}|tkrtS | S r   )r0   NotImplemented)r.   r/   equalr   r   r   __ne__\   s    
z_TotalOrderingMixin.__ne__c                 C   s   t d S r   r,   r-   r   r   r   __lt__b   s    z_TotalOrderingMixin.__lt__c                 C   s$   |  |}|tks|s | |S |S r   r4   r1   r0   r.   r/   lessr   r   r   __le__e   s    

z_TotalOrderingMixin.__le__c                 C   s6   |  |}|tkrtS | |}|tkr,tS |p2| S r   r5   )r.   r/   r7   r2   r   r   r   __gt__k   s    

z_TotalOrderingMixin.__gt__c                 C   s   |  |}|tkrtS | S r   )r4   r1   r6   r   r   r   __ge__t   s    
z_TotalOrderingMixin.__ge__N)
__name__
__module____qualname__	__slots__r0   r3   r4   r8   r9   r:   r   r   r   r   r+   R   s   	r+       r   c                   @   s   e Zd ZdZdS )AddressValueErrorz%A Value Error related to the address.Nr;   r<   r=   __doc__r   r   r   r   r@      s   r@   c                   @   s   e Zd ZdZdS )NetmaskValueErrorz%A Value Error related to the netmask.NrA   r   r   r   r   rC      s   rC   c              	   C   sn   z
t | W S  ttfk
r"   Y nX z
t| W S  ttfk
rF   Y nX t| tr^td|  td|  dS )a  Take an IP string/int and return an object of the correct type.

    Args:
        address: A string or integer, the IP address.  Either IPv4 or
          IPv6 addresses may be supplied; integers less than 2**32 will
          be considered to be IPv4 by default.

    Returns:
        An IPv4Address or IPv6Address object.

    Raises:
        ValueError: if the *address* passed isn't either a v4 or a v6
          address

    zx%r does not appear to be an IPv4 or IPv6 address. Did you pass in a bytes (str in Python 2) instead of a unicode object?z0%r does not appear to be an IPv4 or IPv6 addressN)IPv4Addressr@   rC   IPv6Addressr   bytes
ValueErroraddressr   r   r   
ip_address   s"    


rJ   Tc              	   C   sr   zt | |W S  ttfk
r$   Y nX zt| |W S  ttfk
rJ   Y nX t| trbtd|  td|  dS )a  Take an IP string/int and return an object of the correct type.

    Args:
        address: A string or integer, the IP network.  Either IPv4 or
          IPv6 networks may be supplied; integers less than 2**32 will
          be considered to be IPv4 by default.

    Returns:
        An IPv4Network or IPv6Network object.

    Raises:
        ValueError: if the string passed isn't either a v4 or a v6
          address. Or if the network has host bits set.

    zx%r does not appear to be an IPv4 or IPv6 network. Did you pass in a bytes (str in Python 2) instead of a unicode object?z0%r does not appear to be an IPv4 or IPv6 networkN)IPv4Networkr@   rC   IPv6Networkr   rF   rG   )rI   strictr   r   r   
ip_network   s"    
rN   c              	   C   sX   z
t | W S  ttfk
r"   Y nX z
t| W S  ttfk
rF   Y nX td|  dS )ag  Take an IP string/int and return an object of the correct type.

    Args:
        address: A string or integer, the IP address.  Either IPv4 or
          IPv6 addresses may be supplied; integers less than 2**32 will
          be considered to be IPv4 by default.

    Returns:
        An IPv4Interface or IPv6Interface object.

    Raises:
        ValueError: if the string passed isn't either a v4 or a v6
          address.

    Notes:
        The IPv?Interface classes describe an Address on a particular
        Network, so they're basically a combination of both the Address
        and Network classes.

    z2%r does not appear to be an IPv4 or IPv6 interfaceN)
IPv4Interfacer@   rC   
IPv6InterfacerG   rH   r   r   r   ip_interface   s    

rQ   c              	   C   s6   zt | ddW S  tjtfk
r0   tdY nX dS )a`  Represent an address as 4 packed bytes in network (big-endian) order.

    Args:
        address: An integer representation of an IPv4 IP address.

    Returns:
        The integer address packed as 4 bytes in network (big-endian) order.

    Raises:
        ValueError: If the integer is negative or too large to be an
          IPv4 IP address.

    r   r   z&Address negative or too large for IPv4Nr   r	   r   
OverflowErrorrG   rH   r   r   r   v4_int_to_packed   s    rT   c              	   C   s6   zt | ddW S  tjtfk
r0   tdY nX dS )zRepresent an address as 16 packed bytes in network (big-endian) order.

    Args:
        address: An integer representation of an IPv6 IP address.

    Returns:
        The integer address packed as 16 bytes in network (big-endian) order.

    r   r   z&Address negative or too large for IPv6NrR   rH   r   r   r   v6_int_to_packed  s    
rU   c                 C   s*   t | d}t|dkr&td|  |S )zAHelper to split the netmask and raise AddressValueError if needed/r   zOnly one '/' permitted in %r)_compat_strsplitlenr@   )rI   addrr   r   r   _split_optional_netmask  s    r[   c                 c   sN   t | }t| }}|D ]&}|j|jd kr:||fV  |}|}q||fV  dS )zFind a sequence of sorted deduplicated IPv#Address.

    Args:
        addresses: a list of IPv#Address objects.

    Yields:
        A tuple containing the first and last IP addresses in the sequence.

    r&   N)iternext_ip)	addressesitfirstlastipr   r   r   _find_address_range  s    

rd   c                 C   s$   | dkr|S t |t|  | d @ S )zCount the number of zero bits on the right hand side.

    Args:
        number: an integer.
        bits: maximum number of bits to count.

    Returns:
        The number of zero bits on the right hand side of the number.

    r   r&   )minr"   )Znumberbitsr   r   r   _count_righthand_zero_bits2  s    rg   c                 c   s   t | trt |tstd| j|jkr8td| |f | |krHtd| jdkrXt}n| jdkrht}ntd| j}| j}|j}||krt	t
||t|| d d }|||| f}|V  |d|> 7 }|d |jkrqqdS )	a  Summarize a network range given the first and last IP addresses.

    Example:
        >>> list(summarize_address_range(IPv4Address('192.0.2.0'),
        ...                              IPv4Address('192.0.2.130')))
        ...                                #doctest: +NORMALIZE_WHITESPACE
        [IPv4Network('192.0.2.0/25'), IPv4Network('192.0.2.128/31'),
         IPv4Network('192.0.2.130/32')]

    Args:
        first: the first IPv4Address or IPv6Address in the range.
        last: the last IPv4Address or IPv6Address in the range.

    Returns:
        An iterator of the summarized IPv(4|6) network objects.

    Raise:
        TypeError:
            If the first and last objects are not IP addresses.
            If the first and last objects are not the same version.
        ValueError:
            If the last object is not greater than the first.
            If the version of the first address is not 4 or 6.

    z1first and last must be IP addresses, not networks%%s and %s are not of the same versionz*last IP address must be greater than firstr      zunknown IP versionr&   N)
r   _BaseAddress	TypeErrorversionrG   rK   rL   _max_prefixlenr^   re   rg   r"   	_ALL_ONES)ra   rb   rc   Zip_bitsZ	first_intZlast_intZnbitsnetr   r   r   summarize_address_rangeB  s8    
 


rp   c                 c   s   t | }i }|rV| }| }||}|dkr<|||< q||kr||= || qd}t| D ]$}|dk	r|j|jkrqf|V  |}qfdS )au  Loops through the addresses, collapsing concurrent netblocks.

    Example:

        ip1 = IPv4Network('192.0.2.0/26')
        ip2 = IPv4Network('192.0.2.64/26')
        ip3 = IPv4Network('192.0.2.128/26')
        ip4 = IPv4Network('192.0.2.192/26')

        _collapse_addresses_internal([ip1, ip2, ip3, ip4]) ->
          [IPv4Network('192.0.2.0/24')]

        This shouldn't be called directly; it is called via
          collapse_addresses([]).

    Args:
        addresses: A list of IPv4Network's or IPv6Network's

    Returns:
        A list of IPv4Network's or IPv6Network's depending on what we were
        passed.

    N)listpopsupernetgetappendsortedvaluesbroadcast_address)r_   Zto_mergesubnetsro   rs   Zexistingrb   r   r   r   _collapse_addresses_internaly  s$    

rz   c              	   C   s0  g }g }g }| D ]}t |trR|rF|d j|jkrFtd||d f || q|j|jkr|r|d j|jkrtd||d f z||j W q tk
r   ||j	 Y qX q|r|d j|jkrtd||d f || qt
t|}|r$t|D ]\}}|
t|| qt|| S )a  Collapse a list of IP objects.

    Example:
        collapse_addresses([IPv4Network('192.0.2.0/25'),
                            IPv4Network('192.0.2.128/25')]) ->
                           [IPv4Network('192.0.2.0/24')]

    Args:
        addresses: An iterator of IPv4Network or IPv6Network objects.

    Returns:
        An iterator of the collapsed IPv(4|6)Network objects.

    Raises:
        TypeError: If passed a list of mixed version objects.

    rh   )r   rj   _versionrk   ru   
_prefixlenrm   rc   AttributeErrornetwork_addressrv   setrd   extendrp   rz   )r_   ZaddrsZipsZnetsrc   ra   rb   r   r   r   collapse_addresses  s@    
   r   c                 C   s(   t | tr|  S t | tr$|  S tS )a2  Return a key suitable for sorting between networks and addresses.

    Address and Network objects are not sortable by default; they're
    fundamentally different so the expression

        IPv4Address('192.0.2.0') <= IPv4Network('192.0.2.0/24')

    doesn't make any sense.  There are some times however, where you may wish
    to have ipaddress sort these for you anyway. If you need to do this, you
    can use this function as the key= argument to sorted().

    Args:
      obj: either a Network or Address object.
    Returns:
      appropriate key.

    )r   _BaseNetwork_get_networks_keyrj   _get_address_keyr1   )objr   r   r   get_mixed_type_key  s
    

r   c                   @   s   e Zd ZdZdZedd Zedd Zedd Zed	d
 Z	dd Z
d
d Zedd Z
edd Zedd Zedd Zedd Zdd ZdS )_IPAddressBasezThe mother class.r   c                 C   s   |   S )z:Return the longhand version of the IP address as a string.)_explode_shorthand_ip_stringr.   r   r   r   exploded  s    z_IPAddressBase.explodedc                 C   s   t | S )z;Return the shorthand version of the IP address as a string.rW   r   r   r   r   
compressed  s    z_IPAddressBase.compressedc                 C   s   |   S )aI  The name of the reverse DNS pointer for the IP address, e.g.:
            >>> ipaddress.ip_address("127.0.0.1").reverse_pointer
            '1.0.0.127.in-addr.arpa'
            >>> ipaddress.ip_address("2001:db8::1").reverse_pointer
            '1.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.8.b.d.0.1.0.0.2.ip6.arpa'

        )_reverse_pointerr   r   r   r   reverse_pointer	  s    	z_IPAddressBase.reverse_pointerc                 C   s   dt | f }t|d S )Nz%200s has no version specifiedtyper   r.   msgr   r   r   rl     s    z_IPAddressBase.versionc                 C   sF   |dk rd}t ||| jf || jkrBd}t ||| j| jf d S )Nr   z-%d (< 0) is not permitted as an IPv%d addressz2%d (>= 2**%d) is not permitted as an IPv%d address)r@   r|   rn   rm   )r.   rI   r   r   r   r   _check_int_address  s    

z!_IPAddressBase._check_int_addressc                 C   s.   t |}||kr*d}t||||| jf d S )Nz~%r (len %d != %d) is not permitted as an IPv%d address. Did you pass in a bytes (str in Python 2) instead of a unicode object?)rY   r@   r|   )r.   rI   Zexpected_lenZaddress_lenr   r   r   r   _check_packed_address"  s     z$_IPAddressBase._check_packed_addressc                 C   s   | j | j |? A S )zTurn the prefix length into a bitwise netmask

        Args:
            prefixlen: An integer, the prefix length.

        Returns:
            An integer.

        )rn   )cls	prefixlenr   r   r   _ip_int_from_prefix,  s    z"_IPAddressBase._ip_int_from_prefixc           	      C   s\   t || j}| j| }||? }d|> d }||krX| jd }t||d}d}t|| |S )a  Return prefix length from the bitwise netmask.

        Args:
            ip_int: An integer, the netmask in expanded bitwise format

        Returns:
            An integer, the prefix length.

        Raises:
            ValueError: If the input intermingles zeroes & ones
        r&   r   r   z&Netmask pattern %r mixes zeroes & ones)rg   rm   r   rG   )	r   ip_intZtrailing_zeroesr   Zleading_onesZall_onesZbyteslenZdetailsr   r   r   r   _prefix_from_ip_int9  s    


z"_IPAddressBase._prefix_from_ip_intc                 C   s   d| }t |d S )Nz%r is not a valid netmask)rC   )r   Znetmask_strr   r   r   r   _report_invalid_netmaskR  s    z&_IPAddressBase._report_invalid_netmaskc                 C   sh   t j|s| | zt|}W n tk
r@   | | Y nX d|  krX| jksdn | | |S )a	  Return prefix length from a numeric string

        Args:
            prefixlen_str: The string to be converted

        Returns:
            An integer, the prefix length.

        Raises:
            NetmaskValueError: If the input is not a valid netmask
        r   )_BaseV4_DECIMAL_DIGITS
issupersetr   intrG   rm   )r   Z
prefixlen_strr   r   r   r   _prefix_from_prefix_stringW  s    

z)_IPAddressBase._prefix_from_prefix_stringc                 C   s   z|  |}W n tk
r,   | | Y nX z| |W S  tk
rN   Y nX || jN }z| |W S  tk
r   | | Y nX dS )a  Turn a netmask/hostmask string into a prefix length

        Args:
            ip_str: The netmask/hostmask to be converted

        Returns:
            An integer, the prefix length.

        Raises:
            NetmaskValueError: If the input is not a valid netmask/hostmask
        N)_ip_int_from_stringr@   r   r   rG   rn   )r   ip_strr   r   r   r   _prefix_from_ip_stringp  s    
z%_IPAddressBase._prefix_from_ip_stringc                 C   s   | j t| ffS r   )	__class__rW   r   r   r   r   
__reduce__  s    z_IPAddressBase.__reduce__N)r;   r<   r=   rB   r>   propertyr   r   r   rl   r   r   classmethodr   r   r   r   r   r   r   r   r   r   r     s.   




	





!r   c                   @   sd   e Zd ZdZdZdd Zdd Zdd Zd	d
 Zdd Z	d
d Z
dd Zdd Zdd Z
dd ZdS )rj   zA generic IP object.

    This IP class contains the version independent methods which are
    used by single IP addresses.
    r   c                 C   s   | j S r   r^   r   r   r   r   __int__  s    z_BaseAddress.__int__c                 C   s8   z| j |j ko| j|jkW S  tk
r2   t Y S X d S r   )r^   r|   r~   r1   r-   r   r   r   r0     s    
z_BaseAddress.__eq__c                 C   s`   t |tstS t |ts(td| |f | j|jkrDtd| |f | j|jkr\| j|jk S dS N"%s and %s are not of the same typerh   F)r   r   r1   rj   rk   r|   r^   r-   r   r   r   r4     s    

  z_BaseAddress.__lt__c                 C   s    t |tstS | t| | S r   r   r   r1   r   r   r-   r   r   r   __add__  s    
z_BaseAddress.__add__c                 C   s    t |tstS | t| | S r   r   r-   r   r   r   __sub__  s    
z_BaseAddress.__sub__c                 C   s   d| j jt| f S Nz%s(%r)r   r;   rW   r   r   r   r   __repr__  s    z_BaseAddress.__repr__c                 C   s   t | | jS r   )rW   _string_from_ip_intr^   r   r   r   r   __str__  s    z_BaseAddress.__str__c                 C   s   t tt| jS r   )hashhexr   r^   r   r   r   r   __hash__  s    z_BaseAddress.__hash__c                 C   s
   | j | fS r   r|   r   r   r   r   r     s    z_BaseAddress._get_address_keyc                 C   s   | j | jffS r   )r   r^   r   r   r   r   r     s    z_BaseAddress.__reduce__N)r;   r<   r=   rB   r>   r   r0   r4   r   r   r   r   r   r   r   r   r   r   r   rj     s   rj   c                   @   sd  e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	dd Z
dd Zdd Zdd Z
dd Zedd Zedd Zedd Zedd Zed d! Zed"d# Zed$d% Zed&d' Zd(d) Zd*d+ Zd,d- ZdHd0d1ZdId2d3Zed4d5 Zed6d7 Zd8d9 Z d:d; Z!ed<d= Z"ed>d? Z#ed@dA Z$edBdC Z%edDdE Z&edFdG Z'd/S )Jr   z~A generic IP network object.

    This IP class contains the version independent methods which are
    used by networks.

    c                 C   s
   i | _ d S r   )_cache)r.   rI   r   r   r   __init__  s    z_BaseNetwork.__init__c                 C   s   d| j jt| f S r   r   r   r   r   r   r     s    z_BaseNetwork.__repr__c                 C   s   d| j | jf S N%s/%d)r   r   r   r   r   r   r     s    z_BaseNetwork.__str__c                 c   s8   t | j}t | j}t|d |D ]}| |V  q"dS )zGenerate Iterator over usable hosts in a network.

        This is like __iter__ except it doesn't return the network
        or broadcast addresses.

        r&   Nr   r   rx   r*   _address_classr.   network	broadcastxr   r   r   hosts  s    

z_BaseNetwork.hostsc                 c   s8   t | j}t | j}t||d D ]}| |V  q"d S Nr&   r   r   r   r   r   __iter__  s    

z_BaseNetwork.__iter__c                 C   sl   t | j}t | j}|dkr>|| |kr0td| || S |d7 }|| |k rZtd| || S d S )Nr   zaddress out of ranger&   )r   r   rx   
IndexErrorr   )r.   nr   r   r   r   r   __getitem__  s    

z_BaseNetwork.__getitem__c                 C   sx   t |tstS t |ts(td| |f | j|jkrDtd| |f | j|jkr\| j|jk S | j|jkrt| j|jk S dS r   )r   r   r1   r   rk   r|   r   netmaskr-   r   r   r   r4     s"    

  z_BaseNetwork.__lt__c                 C   sL   z.| j |j ko,| j|jko,t| jt|jkW S  tk
rF   t Y S X d S r   )r|   r   r   r   r~   r1   r-   r   r   r   r0     s    
z_BaseNetwork.__eq__c                 C   s   t t| jt| jA S r   )r   r   r   r   r   r   r   r   r     s    z_BaseNetwork.__hash__c                 C   sL   | j |j krdS t|trdS t| jt|j  koBt| jkS   S d S NF)r|   r   r   r   r   r^   rx   r-   r   r   r   __contains__  s    
z_BaseNetwork.__contains__c                 C   s(   | j |kp&| j|kp&|j | kp&|j| kS )z*Tell if self is partly contained in other.)r   rx   r-   r   r   r   overlaps*  s
    


z_BaseNetwork.overlapsc                 C   s<   | j d}|d kr8| t| jt| jB }|| j d< |S )Nrx   )r   rt   r   r   r   hostmaskr.   r   r   r   r   rx   1  s    
z_BaseNetwork.broadcast_addressc                 C   s8   | j d}|d kr4| t| j| jA }|| j d< |S )Nr   )r   rt   r   r   r   rn   r   r   r   r   r   :  s
    
z_BaseNetwork.hostmaskc                 C   s   d| j | jf S r   )r   r}   r   r   r   r   with_prefixlenB  s    z_BaseNetwork.with_prefixlenc                 C   s   d| j | jf S N%s/%s)r   r   r   r   r   r   with_netmaskF  s