| jS r   )rD   r^   r   r   r   r   rc     s    zIPv4Interface.ipc                 C   s   d|  | j| jf S r   r   r^   r}   r   r   r   r   r   
  s    zIPv4Interface.with_prefixlenc                 C   s   d|  | j| jf S r   r   r^   r   r   r   r   r   r     s    zIPv4Interface.with_netmaskc                 C   s   d|  | j| jf S r   r   r^   r   r   r   r   r   r     s    zIPv4Interface.with_hostmaskN)r;   r<   r=   r   r   r0   r4   r   r   r   r   rc   r   r   r   r   r   r   r   rO     s   


rO   c                   @   s*   e Zd ZdZeZdddZedd ZdS )	rK   ae  This class represents and manipulates 32-bit IPv4 network + addresses..

    Attributes: [examples for IPv4Network('192.0.2.0/27')]
        .network_address: IPv4Address('192.0.2.0')
        .hostmask: IPv4Address('0.0.0.31')
        .broadcast_address: IPv4Address('192.0.2.32')
        .netmask: IPv4Address('255.255.255.224')
        .prefixlen: 27

    Tc                 C   s|  t | | t|ttfr<t|| _| | j\| _	| _
dS t|trt|dkr\|d }n| j}t|d | _| |\| _	| _
t
| j}|t
| j	@ |kr|rtd|  nt|t
| j	@ | _dS t|}t| |d | _t|dkr|d }n| j}| |\| _	| _
|rDtt
| jt
| j	@ | jkrDtd|  tt
| jt
| j	@ | _| j
| jd krx| j| _dS )a  Instantiate a new IPv4 network object.

        Args:
            address: A string or integer representing the IP [& network].
              '192.0.2.0/24'
              '192.0.2.0/255.255.255.0'
              '192.0.0.2/0.0.0.255'
              are all functionally the same in IPv4. Similarly,
              '192.0.2.1'
              '192.0.2.1/255.255.255.255'
              '192.0.2.1/32'
              are also functionally equivalent. That is to say, failing to
              provide a subnetmask will create an object with a mask of /32.

              If the mask (portion after the / in the argument) is given in
              dotted quad form, it is treated as a netmask if it starts with a
              non-zero field (e.g. /255.0.0.0 == /8) and as a hostmask if it
              starts with a zero field (e.g. 0.255.255.255 == /8), with the
              single exception of an all-zero mask which is treated as a
              netmask == /0. If no mask is given, a default of /32 is used.

              Additionally, an integer can be passed, so
              IPv4Network('192.0.2.1') == IPv4Network(3221225985)
              or, more generally
              IPv4Interface(int(IPv4Interface('192.0.2.1'))) ==
                IPv4Interface('192.0.2.1')

        Raises:
            AddressValueError: If ipaddress isn't a valid IPv4 address.
            NetmaskValueError: If the netmask isn't valid for
              an IPv4 address.
            ValueError: If strict is True and a network address is not
              supplied.

        Nr&   r   %s has host bits setr   )r   r   r   r   rF   rD   r   r   rm   r   r}   r%  rY   r   rG   r[   r   r   r   r.   rI   rM   r   r  rZ   r   r   r   r   )  sJ    %





zIPv4Network.__init__c                 C   s&   | j tdko| jtdk o$| j S )zTest if this address is allocated for public networks.

        Returns:
            A boolean, True if the address is not reserved per
            iana-ipv4-special-registry.

        
100.64.0.0/10)r   rK   rx   r   r   r   r   r   r   ~  s
    	zIPv4Network.is_globalN)T)	r;   r<   r=   rB   rD   r   r   r   r   r   r   r   r   rK     s
   
UrK   c                   @   s   e Zd ZedZedZedZedZededededededed	ed
ededed
edededgZedZ	e
dZdS )_IPv4Constantsz169.254.0.0/16z127.0.0.0/8z224.0.0.0/4r0  z	0.0.0.0/8z
10.0.0.0/8z
172.16.0.0/12z192.0.0.0/29z192.0.0.170/31z192.0.2.0/24z192.168.0.0/16z
198.18.0.0/15z198.51.100.0/24z203.0.113.0/24z240.0.0.0/4z255.255.255.255/32z0.0.0.0N)r;   r<   r=   rK   r#  r!  r  r  r  r  rD   r   r   r   r   r   r1    s*   r1  c                   @   s   e Zd ZdZdZdZde d ZdZe	dZ
eZi Ze
dd	 Ze
d
d Ze
dd
 Ze
dd Ze
dddZdd Zdd Zedd Zedd ZdS )_BaseV6zyBase IPv6 object.

    The following methods are used by IPv6 objects in both single IP
    addresses and networks.

    r   ri   r   r&   r   Z0123456789ABCDEFabcdefc                 C   sJ   || j kr@t|tr|}n
| |}t| |}||f| j |< | j | S r   )r   r   r   r   rE   r   r   r   r   r   r     s    	


z_BaseV6._make_netmaskc              
   C   s  |st d|d}d}t||k r:d||f }t |d|d krzt| j}W n2 t k
r } zt d||f W 5 d}~X Y nX |d	|d
? d@   |d	|d@   | jd }t||krd
|d |f }t |d}tdt|d D ]*}	||	 s|dk	rd| }t ||	}q|dk	r|}
t|| d }|d sj|
d8 }
|
rjd}t || |d s|d8 }|rd}t || | j|
|  }|dk r0d}t || jd |f njt|| jkrd}t || j|f |d sd}t || |d s d}t || t|}
d}d}znd}
t	|
D ] }	|
d
K }
|
| 
||	 O }
q>|
d
| K }
t	| dD ] }	|
d
K }
|
| 
||	 O }
qx|
W S  tk
r } zt d||f W 5 d}~X Y nX dS )zTurn an IPv6 ip_str into an integer.

        Args:
            ip_str: A string, the IPv6 ip_str.

        Returns:
            An int, the IPv6 address

        Raises:
            AddressValueError: if ip_str isn't a valid IPv6 Address.

        r   :r  z At least %d parts expected in %rr   r{   r   N%xr     r&   z!At most %d colons permitted in %rz At most one '::' permitted in %rr   z0Leading ':' only permitted as part of '::' in %rz1Trailing ':' only permitted as part of '::' in %rz/Expected at most %d other parts with '::' in %rz,Exactly %d parts expected without '::' in %r)r@   rX   rY   rD   rr   r^   ru   
_HEXTET_COUNTr*   range
_parse_hextetrG   )r   r   r
  Z
_min_partsr   Zipv4_intr  Z
_max_partsZ
skip_indexr!   Zparts_hiZparts_loZ
parts_skippedr   r   r   r   r     s    
"
 






z_BaseV6._ip_int_from_stringc                 C   s>   | j |std| t|dkr4d}t|| t|dS )a&  Convert an IPv6 hextet string into an integer.

        Args:
            hextet_str: A string, the number to parse.

        Returns:
            The hextet as an integer.

        Raises:
            ValueError: if the input isn't strictly a hex number from
              [0..FFFF].

        zOnly hex digits permitted in %rr   z$At most 4 characters permitted in %rr   )_HEX_DIGITSr   rG   rY   r   )r   Z
hextet_strr   r   r   r   r8  >  s    z_BaseV6._parse_hextetc           	      C   s   d}d}d}d}t |D ]>\}}|dkrN|d7 }|dkr<|}||krV|}|}qd}d}q|dkr|| }|t|kr~|dg7 }dg|||< |dkrdg| }|S )a  Compresses a list of hextets.

        Compresses a list of strings, replacing the longest continuous
        sequence of "0" in the list with "" and adding empty strings at
        the beginning or at the end of the string such that subsequently
        calling ":".join(hextets) will produce the compressed version of
        the IPv6 address.

        Args:
            hextets: A list of strings, the hextets to compress.

        Returns:
            A list of strings.

        r{   r   r  r&    )	enumeraterY   )	r   hextetsZbest_doublecolon_startZbest_doublecolon_lenZdoublecolon_startZdoublecolon_lenindexZhextetZbest_doublecolon_endr   r   r   _compress_hextetsX  s0    

z_BaseV6._compress_hextetsNc                    sZ   |dkrt | j}|| jkr$tdd|   fddtdddD }| |}d	|S )
a,  Turns a 128-bit integer into hexadecimal notation.

        Args:
            ip_int: An integer, the IP address.

        Returns:
            A string, the hexadecimal representation of the address.

        Raises:
            ValueError: The address is bigger than 128 bits of all ones.

        NzIPv6 address is too large%032xc                    s&   g | ]}d t  ||d  d qS )r4  r   r   )r   r	  Zhex_strr   r   r     s     z/_BaseV6._string_from_ip_int.<locals>.<listcomp>r   r?   r   r3  )r   r^   rn   rG   r7  r>  r  )r   r   r<  r   r@  r   r     s    


z_BaseV6._string_from_ip_intc                    s   t | trt| j}nt | tr,t| j}nt| }| |}d|   fddtdddD }t | ttfrdd	|| j
f S d	|S )	zExpand a shortened IPv6 address.

        Args:
            ip_str: A string, the IPv6 address.

        Returns:
            A string, the expanded IPv6 address.

        r?  c                    s   g | ]} ||d   qS )r   r   r	  r@  r   r   r     s     z8_BaseV6._explode_shorthand_ip_string.<locals>.<listcomp>r   r?   r   r   r3  )r   rL   rW   r   rP   rc   r   r7  r   r  r}   )r.   r   r   r
  r   r@  r   r     s    



z$_BaseV6._explode_shorthand_ip_stringc                 C   s&   | j ddd dd}d|d S )zReturn the reverse DNS pointer name for the IPv6 address.

        This implements the method described in RFC3596 2.5.

        Nr{   r3  r:  r   z	.ip6.arpa)r   replacer  )r.   Z
reverse_charsr   r   r   r     s    z_BaseV6._reverse_pointerc                 C   s   | j S r   r  r   r   r   r   r
    s    z_BaseV6.max_prefixlenc                 C   s   | j S r   r   r   r   r   r   rl     s    z_BaseV6.version)N)r;   r<   r=   rB   r>   r|   
IPV6LENGTHrn   r6  r  r9  rm   r   r   r   r   r8  r>  r   r   r   r   r
  rl   r   r   r   r   r2