  s.   




	





!r   c                   @   sd   e Zd ZdZdZdd Zdd Zdd Zd	d
 Zdd Z	d
d Z
dd Zdd Zdd Z
dd ZdS )rh   zA generic IP object.

    This IP class contains the version independent methods which are
    used by single IP addresses.
    r   c                 C   s   | j S r   r\   r   r   r   r   __int__  s    z_BaseAddress.__int__c                 C   s8   z| j |j ko| j|jkW S  tk
r2   t Y S X d S r   )r\   rz   r|   r-   r)   r   r   r   r,     s    
z_BaseAddress.__eq__c                 C   s`   t |tstS t |ts(td| |f | j|jkrDtd| |f | j|jkr\| j|jk S dS N"%s and %s are not of the same typerf   F)rB   r   r-   rh   ri   rz   r\   r)   r   r   r   r0     s    

  z_BaseAddress.__lt__c                 C   s    t |tstS | t| | S r   rB   _compat_int_typesr-   r   r   r)   r   r   r   __add__  s    
z_BaseAddress.__add__c                 C   s    t |tstS | t| | S r   r   r)   r   r   r   __sub__  s    
z_BaseAddress.__sub__c                 C   s   d| j jt| f S Nz%s(%r)r   r7   rU   r   r   r   r   __repr__  s    z_BaseAddress.__repr__c                 C   s   t | | jS r   )rU   _string_from_ip_intr\   r   r   r   r   __str__  s    z_BaseAddress.__str__c                 C   s   t tt| jS r   )hashhexr   r\   r   r   r   r   __hash__  s    z_BaseAddress.__hash__c                 C   s
   | j | fS r   rz   r   r   r   r   r     s    z_BaseAddress._get_address_keyc                 C   s   | j | jffS r   )r   r\   r   r   r   r   r     s    z_BaseAddress.__reduce__N)r7   r8   r9   r>   r:   r   r,   r0   r   r   r   r   r   r   r   r   r   r   r   rh     s   rh   c                   @   sd  e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	dd Z
dd Zdd Zdd Z
dd Zedd Zedd Zedd Zedd Zed d! Zed"d# Zed$d% Zed&d' Zd(d) Zd*d+ Zd,d- ZdHd0d1ZdId2d3Zed4d5 Zed6d7 Zd8d9 Z d:d; Z!ed<d= Z"ed>d? Z#ed@dA Z$edBdC Z%edDdE Z&edFdG Z'd/S )Jr   z~A generic IP network object.

    This IP class contains the version independent methods which are
    used by networks.

    c                 C   s
   i | _ d S r   )_cache)r*   rF   r   r   r   __init__  s    z_BaseNetwork.__init__c                 C   s   d| j jt| f S r   r   r   r   r   r   r     s    z_BaseNetwork.__repr__c                 C   s   d| j | jf S N%s/%d)r}   r   r   r   r   r   r     s    z_BaseNetwork.__str__c                 c   s8   t | j}t | j}t|d |D ]}| |V  q"dS )zGenerate Iterator over usable hosts in a network.

        This is like __iter__ except it doesn't return the network
        or broadcast addresses.

        r"   Nr   r}   rv   r&   _address_classr*   network	broadcastxr   r   r   hosts  s    

z_BaseNetwork.hostsc                 c   s8   t | j}t | j}t||d D ]}| |V  q"d S Nr"   r   r   r   r   r   __iter__  s    

z_BaseNetwork.__iter__c                 C   sl   t | j}t | j}|dkr>|| |kr0td| || S |d7 }|| |k rZtd| || S d S )Nr   zaddress out of ranger"   )r   r}   rv   
IndexErrorr   )r*   nr   r   r   r   r   __getitem__  s    

z_BaseNetwork.__getitem__c                 C   sx   t |tstS t |ts(td| |f | j|jkrDtd| |f | j|jkr\| j|jk S | j|jkrt| j|jk S dS r   )rB   r   r-   r   ri   rz   r}   netmaskr)   r   r   r   r0     s"    

  z_BaseNetwork.__lt__c                 C   sL   z.| j |j ko,| j|jko,t| jt|jkW S  tk
rF   t Y S X d S r   )rz   r}   r   r   r|   r-   r)   r   r   r   r,     s    
z_BaseNetwork.__eq__c                 C   s   t t| jt| jA S r   )r   r   r}   r   r   r   r   r   r     s    z_BaseNetwork.__hash__c                 C   sL   | j |j krdS t|trdS t| jt|j  koBt| jkS   S d S NF)rz   rB   r   r   r}   r\   rv   r)   r   r   r   __contains__  s    
z_BaseNetwork.__contains__c                 C   s(   | j |kp&| j|kp&|j | kp&|j| kS )z*Tell if self is partly contained in other.)r}   rv   r)   r   r   r   overlaps*  s
    


z_BaseNetwork.overlapsc                 C   s<   | j d}|d kr8| t| jt| jB }|| j d< |S )Nrv   )r   rr   r   r   r}   hostmaskr*   r   r   r   r   rv   1  s    
z_BaseNetwork.broadcast_addressc                 C   s8   | j d}|d kr4| t| j| jA }|| j d< |S )Nr   )r   rr   r   r   r   rl   r   r   r   r   r   :  s
    
z_BaseNetwork.hostmaskc                 C   s   d| j | jf S r   )r}   r{   r   r   r   r   with_prefixlenB  s    z_BaseNetwork.with_prefixlenc                 C   s   d| j | jf S N%s/%s)r}   r   r   r   r   r   with_netmaskF  s    z_BaseNetwork.with_netmaskc                 C   s   d| j | jf S r   )r}   r   r   r   r   r   
with_hostmaskJ  s    z_BaseNetwork.with_hostmaskc                 C   s   t | jt | j d S )z&Number of hosts in the current subnet.r"   )r   rv   r}   r   r   r   r   
num_addressesN  s    z_BaseNetwork.num_addressesc                 C   s   dt | f }t|d S )Nz%%200s has no associated address classr   r   r   r   r   r   S  s    z_BaseNetwork._address_classc                 C   s   | j S r   )r{   r   r   r   r   r   [  s    z_BaseNetwork.prefixlenc                 c   s  | j |j kstd| |f t|ts2td| || sLtd|| f || krXdS |d|j|jf }| 	 \}}||kr||kr||r|V  |	 \}}qz||r|V  |	 \}}qzt
d|||f qz||kr|V  n"||kr|V  nt
d|||f dS )a  Remove an address from a larger block.

        For example:

            addr1 = ip_network('192.0.2.0/28')
            addr2 = ip_network('192.0.2.1/32')
            list(addr1.address_exclude(addr2)) =
                [IPv4Network('192.0.2.0/32'), IPv4Network('192.0.2.2/31'),
                 IPv4Network('192.0.2.4/30'), IPv4Network('192.0.2.8/29')]

        or IPv6:

            addr1 = ip_network('2001:db8::1/32')
            addr2 = ip_network('2001:db8::1/128')
            list(addr1.address_exclude(addr2)) =
                [ip_network('2001:db8::1/128'),
                 ip_network('2001:db8::2/127'),
                 ip_network('2001:db8::4/126'),
                 ip_network('2001:db8::8/125'),
                 ...
                 ip_network('2001:db8:8000::/33')]

        Args:
            other: An IPv4Network or IPv6Network object of the same type.

        Returns:
            An iterator of the IPv(4|6)Network objects which is self
            minus other.

        Raises:
            TypeError: If self and other are of differing address
              versions, or if other is not a network object.
            ValueError: If other is not completely contained by self.

        rf   z%s is not a network objectz%s not contained in %sNr   z3Error performing exclusion: s1: %s s2: %s other: %s)rz   ri   rB   r   	subnet_ofrD   r   r}   r   rw   AssertionError)r*   r+   s1s2r   r   r   address_exclude_  s@    $ 




z_BaseNetwork.address_excludec                 C   s`   | j |j krtd| |f | j|jk r,dS | j|jkr<dS | j|jk rLdS | j|jkr\dS dS )a  Compare two IP objects.

        This is only concerned about the comparison of the integer
        representation of the network addresses.  This means that the
        host bits aren't considered at all in this method.  If you want
        to compare host bits, you can easily enough do a
        'HostA._ip < HostB._ip'

        Args:
            other: An IP object.

        Returns:
            If the IP versions of self and other are the same, returns:

            -1 if self < other:
              eg: IPv4Network('192.0.2.0/25') < IPv4Network('192.0.2.128/25')
              IPv6Network('2001:db8::1000/124') <
                  IPv6Network('2001:db8::2000/124')
            0 if self == other
              eg: IPv4Network('192.0.2.0/24') == IPv4Network('192.0.2.0/24')
              IPv6Network('2001:db8::1000/124') ==
                  IPv6Network('2001:db8::1000/124')
            1 if self > other
              eg: IPv4Network('192.0.2.128/25') > IPv4Network('192.0.2.0/25')
                  IPv6Network('2001:db8::2000/124') >
                      IPv6Network('2001:db8::1000/124')

          Raises:
              TypeError if the IP versions are different.

        r   ry   r"   r   )rz   ri   r}   r   r)   r   r   r 